/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.utils;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.service.AnnouncementService;
import org.exoplatform.addons.gamification.service.ChallengeService;
import org.exoplatform.addons.gamification.service.configuration.DomainService;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.Challenge;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.UserInfo;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class Utils {
    public static final String ANNOUNCEMENT_ACTIVITY_EVENT = "challenge.announcement.activity";
    private static final Log LOG = ExoLogger.getLogger(Utils.class);
    public static final DateTimeFormatter RFC_3339_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.SSS][XXX]").withResolverStyle(ResolverStyle.LENIENT);
    public static final DateTimeFormatter SIMPLE_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd['T00:00:00']").withResolverStyle(ResolverStyle.LENIENT);
    private static final char[] ILLEGAL_MESSAGE_CHARACTERS = new char[]{',', ';', '\n'};
    private static GamificationService gamificationService;
    private static RuleService ruleService;

    private Utils() {
    }

    public static Identity getIdentityByTypeAndId(String type, String name) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        return identityManager.getOrCreateIdentity(type, name);
    }

    public static String getUserRemoteId(String id) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity identity = identityManager.getIdentity(id);
        return identity != null ? identity.getRemoteId() : null;
    }

    public static final String getCurrentUser() {
        if (ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null) {
            return ConversationState.getCurrent().getIdentity().getUserId();
        }
        return null;
    }

    public static final boolean canEditChallenge(List<Long> managersId, String spaceId) {
        String userId = Utils.getCurrentUser();
        Identity identity = Utils.getIdentityByTypeAndId("organization", userId);
        Space space = Utils.getSpaceById(spaceId);
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Boolean isChallengeOwner = false;
        Boolean isSpaceManager = false;
        if (identity != null) {
            isChallengeOwner = managersId.stream().anyMatch(i -> i == Long.parseLong(identity.getId()));
        }
        if (space != null) {
            isSpaceManager = spaceService.isManager(space, userId) || spaceService.isSuperManager(userId);
        }
        return isChallengeOwner != false && isSpaceManager != false;
    }

    public static final boolean canAnnounce(String id) {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Space space = spaceService.getSpaceById(id);
        if (space == null) {
            throw new IllegalArgumentException("space is not exist");
        }
        String currentUser = Utils.getCurrentUser();
        if (StringUtils.isNotBlank((CharSequence)currentUser)) {
            return spaceService.hasRedactor(space) ? spaceService.isRedactor(space, currentUser) || spaceService.isManager(space, currentUser) || spaceService.isSuperManager(currentUser) : spaceService.isMember(space, currentUser);
        }
        return false;
    }

    public static String toRFC3339Date(Date dateTime) {
        if (dateTime == null) {
            return null;
        }
        ZonedDateTime zonedDateTime = dateTime.toInstant().atZone(ZoneOffset.UTC);
        return zonedDateTime.format(RFC_3339_FORMATTER);
    }

    public static String toSimpleDateFormat(Date dateTime) {
        if (dateTime == null) {
            return null;
        }
        ZonedDateTime zonedDateTime = dateTime.toInstant().atZone(ZoneId.systemDefault());
        return zonedDateTime.format(SIMPLE_DATE_FORMATTER);
    }

    public static Date parseRFC3339Date(String dateString) {
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return null;
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateString, RFC_3339_FORMATTER).withZoneSameInstant(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date parseSimpleDate(String dateString) {
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return null;
        }
        ZonedDateTime zonedDateTime = LocalDate.parse(dateString.substring(0, 10), SIMPLE_DATE_FORMATTER).atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static Space getSpaceById(String spaceId) {
        if (StringUtils.isBlank((CharSequence)spaceId)) {
            return null;
        }
        Space space = ((SpaceService)CommonsUtils.getService(SpaceService.class)).getSpaceById(spaceId);
        if (space == null) {
            LOG.warn("space with id {} do not exist", new Object[]{spaceId});
            return null;
        }
        return space;
    }

    public static DomainDTO getDomainByTitle(String domainTitle) {
        if (domainTitle == null || domainTitle.isEmpty()) {
            return null;
        }
        DomainService domainService = (DomainService)CommonsUtils.getService(DomainService.class);
        return domainService.findDomainByTitle(domainTitle);
    }

    public static RuleDTO getRuleById(long ruleId) throws IllegalArgumentException {
        if (ruleId == 0L) {
            return null;
        }
        try {
            RuleService ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
            return ruleService.findRuleById(ruleId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static RuleDTO getRuleByTitle(String title) {
        try {
            return StringUtils.isBlank((CharSequence)title) ? null : Utils.getRuleService().findRuleByTitle("def_" + title);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static List<UserInfo> getManagersByIds(List<Long> ids) {
        try {
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            if (ids.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<UserInfo> users = new ArrayList<UserInfo>();
            for (Long id : ids) {
                Identity identity = identityManager.getIdentity(String.valueOf(id));
                if (identity == null || !"organization".equals(identity.getProviderId())) continue;
                users.add(Utils.createUser(identity));
            }
            return users;
        }
        catch (Exception e) {
            LOG.error((Object)"Error when getting challenge managers {}", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static UserInfo getUserById(Long id, Long challengeId) {
        try {
            if (id == null) {
                return null;
            }
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            Identity identity = identityManager.getIdentity(String.valueOf(id));
            if (identity != null && "organization".equals(identity.getProviderId())) {
                if (challengeId != null) {
                    ChallengeService challengeService = (ChallengeService)CommonsUtils.getService(ChallengeService.class);
                    Challenge challenge = challengeService.getChallengeById(challengeId, Utils.getCurrentUser());
                    Space space = Utils.getSpaceById(String.valueOf(challenge.getAudience()));
                    return Utils.createUser(identity, space, challenge.getManagers());
                }
                return Utils.createUser(identity);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static UserInfo createUser(Identity identity, Space space, List<Long> managersId) {
        UserInfo userInfo = new UserInfo();
        userInfo.setAvatarUrl(identity.getProfile().getAvatarUrl());
        userInfo.setFullName(identity.getProfile().getFullName());
        userInfo.setRemoteId(identity.getRemoteId());
        userInfo.setId(identity.getId());
        String userId = identity.getRemoteId();
        if (space != null) {
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            Boolean isSuperManager = spaceService.isSuperManager(userId);
            boolean isManager = isSuperManager != false || spaceService.isManager(space, userId);
            boolean isMember = isManager || spaceService.isMember(space, userId);
            boolean isRedactor = isManager || spaceService.isRedactor(space, userId);
            boolean hasRedactor = spaceService.hasRedactor(space);
            Boolean isChallengeOwner = managersId.stream().anyMatch(i -> i == Long.parseLong(identity.getId()));
            userInfo.setManager(isManager);
            userInfo.setMember(isMember);
            userInfo.setRedactor(isRedactor);
            userInfo.setCanAnnounce(hasRedactor ? isRedactor : isMember);
            userInfo.setCanEdit(isChallengeOwner != false && isManager);
        }
        return userInfo;
    }

    public static UserInfo createUser(Identity identity) {
        UserInfo userInfo = new UserInfo();
        userInfo.setAvatarUrl(identity.getProfile().getAvatarUrl());
        userInfo.setFullName(identity.getProfile().getFullName());
        userInfo.setRemoteId(identity.getRemoteId());
        userInfo.setId(identity.getId());
        return userInfo;
    }

    public static Long countAnnouncementsByChallenge(Long challengeId) {
        AnnouncementService announcementService = (AnnouncementService)CommonsUtils.getService(AnnouncementService.class);
        try {
            return announcementService.countAllAnnouncementsByChallenge(challengeId);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static GamificationService getGamificationService() {
        if (gamificationService == null) {
            gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);
        }
        return gamificationService;
    }

    public static RuleService getRuleService() {
        if (ruleService == null) {
            ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
        }
        return ruleService;
    }

    public static Long getUserGlobalScore(String earnerId) {
        return StringUtils.isBlank((CharSequence)earnerId) ? 0L : Utils.getGamificationService().computeTotalScore(earnerId);
    }

    public static String getSpaceFromObjectID(String objectID) {
        if (StringUtils.isBlank((CharSequence)objectID) || !objectID.contains("/portal/g/:spaces:")) {
            return null;
        }
        String groupID = objectID.substring(objectID.indexOf(":")).replace(":", "/");
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Space space = spaceService.getSpaceByGroupId(groupID);
        return space != null ? space.getDisplayName() : null;
    }

    public static final Locale getCurrentUserLocale() {
        String username = Utils.getCurrentUser();
        LocalePolicy localePolicy = (LocalePolicy)CommonsUtils.getService(LocalePolicy.class);
        LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((HttpServletRequest)null);
        localeCtx.setUserProfileLocale(Utils.getUserLocale(username));
        localeCtx.setRemoteUser(username);
        Set supportedLocales = LocaleContextInfoUtils.getSupportedLocales();
        Locale locale = localePolicy.determineLocale(localeCtx);
        boolean supported = supportedLocales.contains(locale);
        if (!supported && !"".equals(locale.getCountry())) {
            locale = new Locale(locale.getLanguage());
            supported = supportedLocales.contains(locale);
        }
        if (!supported) {
            LOG.warn((Object)("Unsupported locale returned by LocalePolicy: " + localePolicy + ". Falling back to 'en'."));
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    public static final String getI18NMessage(Locale userLocale, String messageKey) {
        ResourceBundleService resourceBundleService = (ResourceBundleService)CommonsUtils.getService(ResourceBundleService.class);
        if (userLocale == null) {
            userLocale = Locale.ENGLISH;
        }
        try {
            return resourceBundleService.getResourceBundle(resourceBundleService.getSharedResourceBundleNames(), userLocale).getString(messageKey);
        }
        catch (Exception e) {
            LOG.warn((Object)("Resource bundle key " + messageKey + " not found"));
            return null;
        }
    }

    public static final Locale getUserLocale(String username) {
        OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
        UserProfile profile = null;
        try {
            profile = organizationService.getUserProfileHandler().findUserProfileByName(username);
        }
        catch (Exception e) {
            LOG.error((Object)"Error when getting user locale ", (Throwable)e);
        }
        String lang = null;
        if (profile != null) {
            lang = profile.getAttribute("user.language");
        }
        if (StringUtils.isNotBlank(lang)) {
            return LocaleUtils.toLocale((String)lang);
        }
        return null;
    }

    public static String escapeIllegalCharacterInMessage(String message) {
        if (message == null) {
            return null;
        }
        message = StringEscapeUtils.unescapeHtml((String)message);
        for (char c : ILLEGAL_MESSAGE_CHARACTERS) {
            message = message.replace(c, ' ');
        }
        return message;
    }
}

