/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.effective;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.GamificationUtils;
import org.exoplatform.addons.gamification.IdentityType;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.HistoryStatus;
import org.exoplatform.addons.gamification.service.effective.LeaderboardFilter;
import org.exoplatform.addons.gamification.service.effective.PiechartLeaderboard;
import org.exoplatform.addons.gamification.service.effective.ProfileReputation;
import org.exoplatform.addons.gamification.service.effective.StandardLeaderboard;
import org.exoplatform.addons.gamification.service.mapper.DomainMapper;
import org.exoplatform.addons.gamification.storage.dao.GamificationHistoryDAO;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class GamificationService {
    private static final Log LOG = ExoLogger.getLogger(GamificationService.class);
    protected final GamificationHistoryDAO gamificationHistoryDAO;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private DomainMapper domainMapper;
    private RuleService ruleService;

    public GamificationService(IdentityManager identityManager, SpaceService spaceService, GamificationHistoryDAO gamificationHistoryDAO, DomainMapper domainMapper, RuleService ruleService) {
        this.gamificationHistoryDAO = gamificationHistoryDAO;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.domainMapper = domainMapper;
        this.ruleService = ruleService;
    }

    public List<GamificationActionsHistory> findActionHistoryByDateByEarnerId(Date date, String earnerId) {
        return this.gamificationHistoryDAO.findActionHistoryByDateByEarnerId(date, earnerId);
    }

    public int getLeaderboardRank(String earnerId, Date date, String domain) {
        List<StandardLeaderboard> leaderboard = null;
        Identity identity = this.identityManager.getIdentity(earnerId);
        IdentityType identityType = IdentityType.getType(identity.getProviderId());
        leaderboard = date != null ? (domain.equalsIgnoreCase("all") ? this.gamificationHistoryDAO.findAllActionsHistoryByDate(identityType, date) : this.gamificationHistoryDAO.findAllActionsHistoryByDateByDomain(identityType, date, domain)) : (domain.equalsIgnoreCase("all") ? this.gamificationHistoryDAO.findAllActionsHistoryAgnostic(identityType) : this.gamificationHistoryDAO.findAllActionsHistoryByDomain(identityType, domain));
        StandardLeaderboard item = leaderboard.stream().filter((? super T g) -> earnerId.equals(g.getEarnerId())).findAny().orElse(null);
        return leaderboard.indexOf(item) + 1;
    }

    public long findReputationByEarnerId(String earnerId) {
        GamificationActionsHistory aHistory = this.findLatestActionHistoryByEarnerId(earnerId);
        return aHistory != null ? aHistory.getGlobalScore() : 0L;
    }

    public List<ProfileReputation> buildDomainScoreByIdentityId(String earnerId) {
        return this.gamificationHistoryDAO.findDomainScoreByIdentityId(earnerId);
    }

    public GamificationActionsHistory saveActionHistory(GamificationActionsHistory history) {
        return (GamificationActionsHistory)this.gamificationHistoryDAO.create(history);
    }

    public void createHistory(String event, String sender, String receiver, String object) {
        GamificationActionsHistory aHistory = null;
        List<RuleDTO> ruleDtos = null;
        ruleDtos = this.ruleService.findEnabledRulesByEvent(event);
        if (ruleDtos != null) {
            for (RuleDTO ruleDto : ruleDtos) {
                aHistory = this.build(ruleDto, sender, receiver, object);
                if (aHistory == null) continue;
                aHistory = this.saveActionHistory(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getEarnerId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getEvent(), ruleDto.getScore()});
            }
        }
    }

    public GamificationActionsHistory findLatestActionHistoryByEarnerId(String earnerId) {
        List<GamificationActionsHistory> entities = this.gamificationHistoryDAO.findActionsHistoryByEarnerId(earnerId, 1);
        return entities != null && !entities.isEmpty() ? entities.get(0) : null;
    }

    public List<StandardLeaderboard> filter(LeaderboardFilter filter) {
        String currentUser;
        LocalDate now;
        int limit = filter.getLoadCapacity();
        IdentityType identityType = filter.getIdentityType();
        if (identityType.isSpace()) {
            limit *= 3;
        }
        List<StandardLeaderboard> result = null;
        if (StringUtils.isBlank((CharSequence)filter.getDomain()) || filter.getDomain().equalsIgnoreCase("all")) {
            now = LocalDate.now();
            if (filter.getPeriod().equals(LeaderboardFilter.Period.WEEK.name())) {
                Date fromDate = Date.from(now.with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant());
                result = this.gamificationHistoryDAO.findAllActionsHistoryByDate(fromDate, identityType, limit);
            } else if (filter.getPeriod().equals(LeaderboardFilter.Period.MONTH.name())) {
                Date fromDate = Date.from(now.with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant());
                result = this.gamificationHistoryDAO.findAllActionsHistoryByDate(fromDate, identityType, limit);
            } else {
                result = this.gamificationHistoryDAO.findAllActionsHistory(identityType, limit);
            }
        } else {
            now = LocalDate.now();
            if (filter.getPeriod().equals(LeaderboardFilter.Period.WEEK.name())) {
                Date fromDate = Date.from(now.with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant());
                result = this.gamificationHistoryDAO.findActionsHistoryByDateByDomain(fromDate, identityType, filter.getDomain(), limit);
            } else if (filter.getPeriod().equals(LeaderboardFilter.Period.MONTH.name())) {
                Date fromDate = Date.from(now.with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant());
                result = this.gamificationHistoryDAO.findActionsHistoryByDateByDomain(fromDate, identityType, filter.getDomain(), limit);
            } else {
                result = this.gamificationHistoryDAO.findAllActionsHistoryByDomain(filter.getDomain(), identityType, limit);
            }
        }
        if (identityType.isSpace() && result != null && !result.isEmpty() && StringUtils.isNotBlank((CharSequence)(currentUser = filter.getCurrentUser()))) {
            result = this.filterAuthorizedSpaces(result, currentUser, filter.getLoadCapacity());
        }
        return result;
    }

    public List<PiechartLeaderboard> buildStatsByUser(String earnerId, Date startDate, Date endDate) {
        return this.gamificationHistoryDAO.findStatsByUserId(earnerId, startDate, endDate);
    }

    public long findUserReputationScoreBetweenDate(String earnerId, Date fromDate, Date toDate) {
        return this.gamificationHistoryDAO.findUserReputationScoreBetweenDate(earnerId, fromDate, toDate);
    }

    public long findUserReputationScoreByMonth(String earnerId, Date currentMonth) {
        return this.gamificationHistoryDAO.findUserReputationScoreByMonth(earnerId, currentMonth);
    }

    public long findUserReputationScoreByDomainBetweenDate(String earnerId, String domain, Date fromDate, Date toDate) {
        return this.gamificationHistoryDAO.findUserReputationScoreByDomainBetweenDate(earnerId, domain, fromDate, toDate);
    }

    public List<StandardLeaderboard> findAllLeaderboardBetweenDate(IdentityType earnedType, Date fromDate, Date toDate) {
        return this.gamificationHistoryDAO.findAllLeaderboardBetweenDate(earnedType, fromDate, toDate);
    }

    public List<GamificationActionsHistory> findActionsHistoryByEarnerId(String earnerId, int limit) {
        return this.gamificationHistoryDAO.findActionsHistoryByEarnerIdSortedByDate(earnerId, limit);
    }

    public GamificationActionsHistory build(RuleDTO ruleDto, String actor, String receiver, String objectId) {
        GamificationActionsHistory aHistory = null;
        Identity actorIdentity = this.identityManager.getIdentity(actor);
        if (actorIdentity == null || StringUtils.isBlank((CharSequence)actorIdentity.getRemoteId())) {
            LOG.warn("Actor {} has earned some points but doesn't have a social identity", new Object[]{actor});
            return null;
        }
        if (actorIdentity.isDeleted()) {
            LOG.warn("Actor {} has earned some points but is marked as deleted", new Object[]{actor});
            return null;
        }
        if (!actorIdentity.isEnable()) {
            LOG.warn("Actor {} has earned some points but is marked as disabled", new Object[]{actor});
            return null;
        }
        String actorRemoteId = actorIdentity.getRemoteId();
        if (GamificationUtils.isBlackListed(actorRemoteId)) {
            LOG.debug("Actor {} has earned some points but is marked as blacklisted", new Object[]{actor});
            return null;
        }
        if (ruleDto != null) {
            aHistory = new GamificationActionsHistory();
            aHistory.setActionScore(ruleDto.getScore());
            aHistory.setGlobalScore(this.computeTotalScore(actor) + (long)ruleDto.getScore());
            aHistory.setEarnerId(actor);
            aHistory.setEarnerType(IdentityType.getType(actorIdentity.getProviderId()));
            aHistory.setActionTitle(ruleDto.getEvent());
            aHistory.setDomain(ruleDto.getArea());
            if (ruleDto.getDomainDTO() != null) {
                aHistory.setDomainEntity(DomainMapper.domainDTOToDomain(ruleDto.getDomainDTO()));
            }
            aHistory.setReceiver(receiver);
            aHistory.setObjectId(objectId);
            aHistory.setStatus(HistoryStatus.ACCEPTED);
            aHistory.setLastModifiedDate(new Date());
            aHistory.setLastModifiedBy("Gamification Inner Process");
            aHistory.setCreatedBy("Gamification Inner Process");
        }
        return aHistory;
    }

    public long computeTotalScore(String actorIdentityId) {
        return this.gamificationHistoryDAO.getTotalScore(actorIdentityId);
    }

    private List<StandardLeaderboard> filterAuthorizedSpaces(List<StandardLeaderboard> result, String currentUser, int limit) {
        result = result.stream().filter((? super T spacePoint) -> {
            String spaceIdentityId = spacePoint.getEarnerId();
            Identity identity = this.identityManager.getIdentity(spaceIdentityId);
            if (identity == null) {
                LOG.debug("Space Identity with id {} was deleted, ignore it", new Object[]{spaceIdentityId});
                return false;
            }
            String spacePrettyName = identity.getRemoteId();
            Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
            return space != null && (!"hidden".equals(space.getVisibility()) || this.spaceService.isSuperManager(currentUser) || this.spaceService.isMember(space, currentUser));
        }).limit(limit).collect(Collectors.toList());
        return result;
    }
}

