/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.social.profile;

import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceService;

public class GamificationProfileListener
extends ProfileListenerPlugin {
    protected RuleService ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
    protected IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    protected SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
    protected GamificationService gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);

    public void avatarUpdated(ProfileLifeCycleEvent event) {
        Long lastUpdate = event.getProfile().getAvatarLastUpdated();
        String identityId = event.getProfile().getIdentity().getId();
        if (lastUpdate != null) {
            return;
        }
        this.gamificationService.createHistory("addUserProfileAvatar", identityId, identityId, event.getProfile().getUrl());
    }

    public void bannerUpdated(ProfileLifeCycleEvent event) {
        Long lastUpdate = event.getProfile().getBannerLastUpdated();
        String identityId = event.getProfile().getIdentity().getId();
        if (lastUpdate != null) {
            return;
        }
        this.gamificationService.createHistory("addUserProfileBanner", identityId, identityId, event.getProfile().getUrl());
    }

    public void basicInfoUpdated(ProfileLifeCycleEvent event) {
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
    }

    public void headerSectionUpdated(ProfileLifeCycleEvent event) {
    }

    public void createProfile(ProfileLifeCycleEvent event) {
    }

    public void aboutMeUpdated(ProfileLifeCycleEvent event) {
        String identityId = event.getProfile().getIdentity().getId();
        this.gamificationService.createHistory("addUserProfileAboutMe", identityId, identityId, event.getProfile().getUrl());
    }
}

