/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.challenges;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.addons.gamification.service.AnnouncementService;
import org.exoplatform.addons.gamification.service.dto.configuration.Announcement;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;

public class AnnouncementActivityUpdater
extends ActivityListenerPlugin {
    public static final String ANNOUNCEMENT_ID_PARAM = "announcementId";
    public static final String ANNOUNCEMENT_COMMENT_PARAM = "announcementComment";
    private static final Log LOG = ExoLogger.getLogger(AnnouncementActivityUpdater.class);
    private ActivityManager activityManager;
    private AnnouncementService announcementService;

    public AnnouncementActivityUpdater(ActivityManager activityManager, AnnouncementService announcementService) {
        this.activityManager = activityManager;
        this.announcementService = announcementService;
    }

    public void updateActivity(ActivityLifeCycleEvent activityLifeCycleEvent) {
        ExoSocialActivity activity = (ExoSocialActivity)activityLifeCycleEvent.getSource();
        if (!StringUtils.equals((String)activity.getType(), (String)"challenges-announcement")) {
            return;
        }
        long announcementId = Long.parseLong((String)activity.getTemplateParams().get(ANNOUNCEMENT_ID_PARAM));
        Announcement announcement = this.announcementService.getAnnouncementById(announcementId);
        if (announcement != null) {
            try {
                announcement.setComment(activity.getTitle());
                this.announcementService.updateAnnouncement(announcement);
            }
            catch (ObjectNotFoundException e) {
                LOG.warn("Announcement with id {} wasn't found, only the activity message will be updated", new Object[]{announcementId, e});
            }
        }
        if (activity.getTemplateParams().containsKey(ANNOUNCEMENT_COMMENT_PARAM)) {
            activity.getTemplateParams().put(ANNOUNCEMENT_COMMENT_PARAM, null);
            this.activityManager.updateActivity(activity, false);
        }
    }
}

