/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.cached;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.addons.gamification.search.RuleSearchConnector;
import org.exoplatform.addons.gamification.service.dto.configuration.CacheKey;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityType;
import org.exoplatform.addons.gamification.storage.RuleStorage;
import org.exoplatform.addons.gamification.storage.dao.GamificationHistoryDAO;
import org.exoplatform.addons.gamification.storage.dao.RuleDAO;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class RuleCachedStorage
extends RuleStorage {
    private static final int RULE_ID_CONTEXT = 0;
    private static final int RULE_TITLE_CONTEXT = 1;
    private static final int ALL_RULE_CONTEXT = 2;
    private static final int RULES_BY_FILTER_CONTEXT = 3;
    private static final String RULE_CACHE_NAME = "gamification.rule";
    private FutureExoCache<Serializable, Object, CacheKey> ruleFutureCache;

    public RuleCachedStorage(RuleDAO ruleDAO, RuleSearchConnector ruleSearchConnector, CacheService cacheService, GamificationHistoryDAO gamificationHistoryDAO) {
        super(ruleDAO, ruleSearchConnector, gamificationHistoryDAO);
        ExoCache ruleCache = cacheService.getCacheInstance(RULE_CACHE_NAME);
        Loader<Serializable, Object, CacheKey> ruleLoader = new Loader<Serializable, Object, CacheKey>(){

            public Object retrieve(CacheKey context, Serializable key) throws Exception {
                if (context.getContext() == 0) {
                    return RuleCachedStorage.super.findRuleById(context.getId());
                }
                if (context.getContext() == 1) {
                    return RuleCachedStorage.super.findRuleByTitle(context.getTitle());
                }
                if (context.getContext() == 2) {
                    return RuleCachedStorage.super.findAllRules();
                }
                if (context.getContext() == 3) {
                    return RuleCachedStorage.super.findRulesIdsByFilter(context.getRuleFilter(), context.getOffset(), context.getLimit());
                }
                throw new IllegalStateException("Unknown context id " + context);
            }
        };
        this.ruleFutureCache = new FutureExoCache((Loader)ruleLoader, ruleCache);
    }

    @Override
    public RuleDTO saveRule(RuleDTO ruleDTO) {
        try {
            RuleDTO ruleDTO2 = ruleDTO = super.saveRule(ruleDTO);
            return ruleDTO2;
        }
        finally {
            if (EntityType.MANUAL.equals((Object)ruleDTO.getType())) {
                this.ruleFutureCache.clear();
            } else {
                this.ruleFutureCache.remove((Serializable)Integer.valueOf(new CacheKey((Integer)0, ruleDTO.getId()).hashCode()));
                this.ruleFutureCache.remove((Serializable)Integer.valueOf(new CacheKey((Integer)1, ruleDTO.getTitle()).hashCode()));
                this.ruleFutureCache.remove((Serializable)Integer.valueOf(new CacheKey((Integer)2, 0L).hashCode()));
            }
        }
    }

    @Override
    public RuleDTO findRuleById(Long id) {
        CacheKey key = new CacheKey((Integer)0, id);
        return (RuleDTO)this.ruleFutureCache.get((Object)key, (Object)key.hashCode());
    }

    @Override
    public RuleDTO findRuleByTitle(String title) {
        CacheKey key = new CacheKey((Integer)1, title);
        return (RuleDTO)this.ruleFutureCache.get((Object)key, (Object)key.hashCode());
    }

    @Override
    public List<RuleDTO> findAllRules() {
        CacheKey key = new CacheKey((Integer)2, 0L);
        return (List)this.ruleFutureCache.get((Object)key, (Object)key.hashCode());
    }

    @Override
    public RuleDTO deleteRuleById(long ruleId, String userId, boolean force) throws ObjectNotFoundException {
        RuleDTO rule = super.deleteRuleById(ruleId, userId, force);
        this.ruleFutureCache.remove((Serializable)Integer.valueOf(new CacheKey((Integer)0, rule.getId()).hashCode()));
        this.ruleFutureCache.remove((Serializable)Integer.valueOf(new CacheKey((Integer)1, rule.getTitle()).hashCode()));
        this.ruleFutureCache.remove((Serializable)Integer.valueOf(new CacheKey((Integer)2, 0L).hashCode()));
        return rule;
    }

    @Override
    public void clearCache() {
        this.ruleFutureCache.clear();
    }
}

