/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest.builder;

import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.UserInfo;
import io.meeds.gamification.model.UserInfoContext;
import io.meeds.gamification.rest.model.ProgramRestEntity;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import io.meeds.social.translation.service.TranslationService;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ProgramBuilder {
    private static final Log LOG = ExoLogger.getLogger(ProgramBuilder.class);

    private ProgramBuilder() {
    }

    public static ProgramRestEntity toRestEntity(ProgramService programService, RuleService ruleService, TranslationService translationService, UserACL userAcl, ProgramDTO program, Locale locale, String username, List<String> expandFields, boolean expandAdministrators) {
        if (program == null) {
            return null;
        }
        boolean anonymous = StringUtils.isBlank((CharSequence)username);
        ProgramBuilder.translatedLabels(translationService, program, locale);
        int activeRulesCount = 0;
        if (CollectionUtils.isNotEmpty(expandFields) && (expandFields.contains("countActiveRules") || expandFields.contains("countActiveRulesWhenDisabled") && !program.isEnabled())) {
            activeRulesCount = ruleService.countActiveRules(program.getId());
        }
        return new ProgramRestEntity(program.getId(), program.getTitle(), program.getDescription(), program.getColor(), program.getSpaceId(), program.getPriority(), anonymous ? null : program.getCreatedBy(), program.getCreatedDate(), anonymous ? null : program.getLastModifiedBy(), program.getLastModifiedDate(), program.isDeleted(), program.isEnabled(), program.getBudget(), program.getType(), null, null, program.getCoverFileId(), program.getAvatarFileId(), program.getCoverUrl(), program.getAvatarUrl(), anonymous ? null : program.getOwnerIds(), program.getRulesTotalScore(), program.isOpen(), !anonymous && program.getSpaceId() > 0L ? Utils.getSpaceById(String.valueOf(program.getSpaceId())) : null, ProgramBuilder.toUserContext(programService, program, username), anonymous ? Collections.emptyList() : ProgramBuilder.getProgramOwnersByIds(program.getOwnerIds(), program.getSpaceId()), anonymous || !expandAdministrators ? null : ProgramBuilder.buildAdministrators(programService, userAcl), activeRulesCount, program.getVisibility());
    }

    public static void translatedLabels(TranslationService translationService, ProgramDTO program, Locale locale) {
        String translatedDescription;
        if (program == null || locale == null) {
            return;
        }
        String translatedTitle = translationService.getTranslationLabel("program", program.getId(), "title", locale);
        if (StringUtils.isNotBlank((CharSequence)translatedTitle)) {
            program.setTitle(translatedTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)(translatedDescription = translationService.getTranslationLabel("program", program.getId(), "description", locale)))) {
            program.setDescription(translatedDescription);
        }
    }

    public static List<ProgramRestEntity> toRestEntities(ProgramService programService, RuleService ruleService, TranslationService translationService, UserACL userAcl, Locale locale, List<ProgramDTO> programs, List<String> expandFields, String username) {
        return programs.stream().map(program -> ProgramBuilder.toRestEntity(programService, ruleService, translationService, userAcl, program, locale, username, expandFields, false)).toList();
    }

    public static List<String> buildAdministrators(ProgramService programService, UserACL userAcl) {
        if (userAcl == null || programService == null) {
            return Collections.emptyList();
        }
        List<String> administrators = programService.getAdministrators();
        String superUser = userAcl.getSuperUser();
        return administrators == null ? null : administrators.stream().filter(u -> !superUser.equals(u)).toList();
    }

    private static List<UserInfo> getProgramOwnersByIds(Set<Long> ids, long spaceId) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Space space = spaceId > 0L ? spaceService.getSpaceById(String.valueOf(spaceId)) : null;
        return ids.stream().distinct().map(id -> {
            try {
                Identity identity = identityManager.getIdentity(String.valueOf(id));
                if (identity != null && identity.isUser() && (spaceId == 0L || space != null && !spaceService.isManager(space, identity.getRemoteId()) && spaceService.isMember(space, identity.getRemoteId()))) {
                    return ProgramBuilder.toUserInfo(identity);
                }
            }
            catch (Exception e) {
                LOG.warn("Error when getting program owner with id {}. Ignore retrieving identity information", new Object[]{id, e});
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    public static UserInfoContext toUserContext(ProgramService programService, ProgramDTO program, String username) {
        UserInfoContext userContext = new UserInfoContext();
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity identity = StringUtils.isBlank((CharSequence)username) ? null : identityManager.getOrCreateUserIdentity(username);
        ProgramBuilder.mapUserInfo(userContext, identity);
        if (program != null) {
            boolean anonymous = identity == null;
            boolean canView = programService.canViewProgram(program.getId(), username);
            boolean isOwner = !anonymous && programService.isProgramOwner(program.getId(), username);
            boolean isMember = !anonymous && programService.isProgramMember(program.getId(), username);
            boolean canEdit = !anonymous && isOwner && !program.isDeleted();
            userContext.setManager(isOwner);
            userContext.setCanEdit(canEdit);
            userContext.setMember(isMember);
            userContext.setCanView(canView);
            userContext.setProgramOwner(isOwner);
            if (program.isOpen()) {
                userContext.setRedactor(true);
            } else {
                Space space = Utils.getSpaceById(String.valueOf(program.getSpaceId()));
                if (space != null) {
                    boolean isRedactor = !anonymous && ((SpaceService)CommonsUtils.getService(SpaceService.class)).canRedactOnSpace(space, Utils.getUserAclIdentity(username));
                    userContext.setRedactor(isRedactor);
                }
            }
        }
        return userContext;
    }

    private static UserInfo toUserInfo(Identity identity) {
        UserInfo userInfo = new UserInfo();
        ProgramBuilder.mapUserInfo(userInfo, identity);
        return userInfo;
    }

    private static <E extends UserInfo> void mapUserInfo(E userInfo, Identity identity) {
        if (identity != null) {
            userInfo.setAvatarUrl(identity.getProfile().getAvatarUrl());
            userInfo.setFullName(identity.getProfile().getFullName());
            userInfo.setRemoteId(identity.getRemoteId());
            userInfo.setId(identity.getId());
        }
    }
}

