/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RuleService;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class RuleAttachmentPlugin
extends AttachmentPlugin {
    public static final String RULE_OBJECT_TYPE = "rule";
    private ProgramService programService;
    private RuleService ruleService;
    private SpaceService spaceService;
    private IdentityManager identityManager;

    public RuleAttachmentPlugin(ProgramService programService, RuleService ruleService, SpaceService spaceService, IdentityManager identityManager) {
        this.programService = programService;
        this.ruleService = ruleService;
        this.spaceService = spaceService;
        this.identityManager = identityManager;
    }

    public String getObjectType() {
        return RULE_OBJECT_TYPE;
    }

    public boolean hasAccessPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
        try {
            long ruleId = Long.parseLong(entityId);
            String username = userIdentity.getUserId();
            return this.ruleService.findRuleById(ruleId, username) != null;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public boolean hasEditPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
        try {
            long ruleId = Long.parseLong(entityId);
            String username = userIdentity.getUserId();
            RuleDTO rule = this.ruleService.findRuleById(ruleId, username);
            return rule != null && this.programService.isProgramOwner(rule.getProgramId(), username);
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public long getAudienceId(String objectId) throws ObjectNotFoundException {
        long spaceId = this.getSpaceId(objectId);
        if (spaceId == 0L) {
            return 0L;
        }
        Space space = this.spaceService.getSpaceById(String.valueOf(spaceId));
        if (space == null) {
            throw new ObjectNotFoundException(String.format("Space with id %s wasn't found", spaceId));
        }
        return Long.parseLong(this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()).getId());
    }

    public long getSpaceId(String objectId) throws ObjectNotFoundException {
        long ruleId = Long.parseLong(objectId);
        RuleDTO rule = this.ruleService.findRuleById(ruleId);
        if (rule == null) {
            throw new ObjectNotFoundException(String.format("Rule with id %s wasn't found", ruleId));
        }
        return rule.getProgram().getSpaceId();
    }
}

