/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.upgrade;

import io.meeds.gamification.constant.EntityVisibility;
import io.meeds.gamification.upgrade.ProgramVisibilityUpgradePlugin$AjcClosure1;
import io.meeds.gamification.upgrade.ProgramVisibilityUpgradePlugin$AjcClosure3;
import io.meeds.gamification.upgrade.ProgramVisibilityUpgradePlugin$AjcClosure5;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ProgramVisibilityUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG;
    private static final String VISIBILITY_PARAM = "visibility";
    private static final String AUDIENCE_IDS_PARAM = "audienceIds";
    private static final String GET_PROGRAM_SPACE_IDS_QUERY = "SELECT DISTINCT p.audienceId FROM GamificationDomain p WHERE p.audienceId > 0";
    private static final String UPGRADE_PROGRAMS_QUERY = "UPDATE GamificationDomain p SET p.visibility = :visibility";
    private static final String UPGRADE_PROGRAMS_WITH_AUDIENCE_QUERY = "UPDATE GamificationDomain p SET p.visibility = :visibility WHERE p.audienceId IS NULL OR p.audienceId = 0 OR p.audienceId IN (:audienceIds)";
    private static final String UPGRADE_PROGRAMS_NO_AUDIENCE_QUERY = "UPDATE GamificationDomain p SET p.visibility = :visibility WHERE p.audienceId IS NULL OR p.audienceId = 0";
    private EntityManagerService entityManagerService;
    private SpaceService spaceService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public ProgramVisibilityUpgradePlugin(EntityManagerService entityManagerService, SpaceService spaceService, SettingService settingService, InitParams initParams) {
        super(settingService, initParams);
        this.entityManagerService = entityManagerService;
        this.spaceService = spaceService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"Start:: Upgrade Programs Visibility");
        List<Long> spaceIds = this.getProgramSpaceIds();
        spaceIds = spaceIds.stream().map(spaceId -> this.spaceService.getSpaceById(String.valueOf(spaceId))).filter(Objects::nonNull).filter(s -> "open".equals(s.getRegistration())).map(Space::getId).map(Long::parseLong).toList();
        this.upgradeAllProgramsAsRestricted();
        int openProgramsCount = this.upgradeProgramsAsOpen(spaceIds);
        LOG.info("End:: Upgrade Programs Visibility: {} upgraded as Open.", new Object[]{openProgramsCount});
    }

    @ExoTransactional
    public int upgradeAllProgramsAsRestricted() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        ProgramVisibilityUpgradePlugin$AjcClosure1 programVisibilityUpgradePlugin$AjcClosure1 = new ProgramVisibilityUpgradePlugin$AjcClosure1(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(programVisibilityUpgradePlugin$AjcClosure1.linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public int upgradeProgramsAsOpen(List<Long> programSpaceIds) {
        List<Long> list = programSpaceIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), list);
        Object[] objectArray = new Object[]{this, list, joinPoint};
        ProgramVisibilityUpgradePlugin$AjcClosure3 programVisibilityUpgradePlugin$AjcClosure3 = new ProgramVisibilityUpgradePlugin$AjcClosure3(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(programVisibilityUpgradePlugin$AjcClosure3.linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public List<Long> getProgramSpaceIds() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        ProgramVisibilityUpgradePlugin$AjcClosure5 programVisibilityUpgradePlugin$AjcClosure5 = new ProgramVisibilityUpgradePlugin$AjcClosure5(objectArray);
        return (List)ExoTransactionalAspect.aspectOf().around(programVisibilityUpgradePlugin$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    static {
        ProgramVisibilityUpgradePlugin.ajc$preClinit();
        LOG = ExoLogger.getLogger(ProgramVisibilityUpgradePlugin.class);
    }

    static /* synthetic */ int upgradeAllProgramsAsRestricted_aroundBody0(ProgramVisibilityUpgradePlugin ajc$this, JoinPoint joinPoint) {
        EntityManager entityManager = ajc$this.entityManagerService.getEntityManager();
        Query query = entityManager.createQuery(UPGRADE_PROGRAMS_QUERY);
        query.setParameter(VISIBILITY_PARAM, (Object)EntityVisibility.RESTRICTED);
        return query.executeUpdate();
    }

    static /* synthetic */ int upgradeProgramsAsOpen_aroundBody2(ProgramVisibilityUpgradePlugin ajc$this, List programSpaceIds, JoinPoint joinPoint) {
        EntityManager entityManager = ajc$this.entityManagerService.getEntityManager();
        Query query = entityManager.createQuery(programSpaceIds.isEmpty() ? UPGRADE_PROGRAMS_NO_AUDIENCE_QUERY : UPGRADE_PROGRAMS_WITH_AUDIENCE_QUERY);
        query.setParameter(VISIBILITY_PARAM, (Object)EntityVisibility.OPEN);
        if (!programSpaceIds.isEmpty()) {
            query.setParameter(AUDIENCE_IDS_PARAM, (Object)programSpaceIds);
        }
        return query.executeUpdate();
    }

    static /* synthetic */ List getProgramSpaceIds_aroundBody4(ProgramVisibilityUpgradePlugin ajc$this, JoinPoint joinPoint) {
        EntityManager entityManager = ajc$this.entityManagerService.getEntityManager();
        TypedQuery query = entityManager.createQuery(GET_PROGRAM_SPACE_IDS_QUERY, Long.class);
        List result = query.getResultList();
        return result == null ? Collections.emptyList() : result;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProgramVisibilityUpgradePlugin.java", ProgramVisibilityUpgradePlugin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "upgradeAllProgramsAsRestricted", "io.meeds.gamification.upgrade.ProgramVisibilityUpgradePlugin", "", "", "", "int"), 96);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "upgradeProgramsAsOpen", "io.meeds.gamification.upgrade.ProgramVisibilityUpgradePlugin", "java.util.List", "programSpaceIds", "", "int"), 104);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProgramSpaceIds", "io.meeds.gamification.upgrade.ProgramVisibilityUpgradePlugin", "", "", "", "java.util.List"), 116);
    }
}

