/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;

@Asynchronous
public class GamificationUserLoginListener
extends Listener<ConversationRegistry, ConversationState> {
    private static final Log LOG = ExoLogger.getLogger(GamificationUserLoginListener.class);
    protected RuleService ruleService;
    protected IdentityManager identityManager;
    protected RealizationService realizationService;

    public GamificationUserLoginListener(RuleService ruleService, IdentityManager identityManager, RealizationService realizationService) {
        this.ruleService = ruleService;
        this.identityManager = identityManager;
        this.realizationService = realizationService;
    }

    public void onEvent(Event<ConversationRegistry, ConversationState> event) {
        String username = ((ConversationState)event.getData()).getIdentity().getUserId();
        String sender = this.identityManager.getOrCreateIdentity("organization", username).getId();
        this.realizationService.createRealizationsAsync("userLogin", sender, sender, null, null);
        LOG.debug("User Login Gamification for {}", new Object[]{username});
    }
}

