/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.plugin.ConnectorPlugin;
import io.meeds.gamification.rest.ConnectorRest;
import io.meeds.gamification.test.AbstractServiceTest;
import java.util.Map;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.security.ConversationState;
import org.junit.Before;
import org.junit.Test;

public class TestConnectorRest
extends AbstractServiceTest {
    private static final String CONNECTOR_NAME = "connectorName";

    protected Class<?> getComponentClass() {
        return ConnectorRest.class;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.registry(this.getComponentClass());
        ConversationState.setCurrent(null);
    }

    @Test
    public void testGetConnectors() throws Exception {
        this.startSessionAs("root1");
        ContainerResponse response = this.getResponse("GET", this.getURLResource("connectors?username=root1"), null);
        TestConnectorRest.assertNotNull((Object)response);
        TestConnectorRest.assertEquals((int)200, (int)response.getStatus());
        this.startSessionAs("user");
        response = this.getResponse("GET", this.getURLResource("connectors?username=root1&expand=userIdentifier"), null);
        TestConnectorRest.assertNotNull((Object)response);
        TestConnectorRest.assertEquals((int)200, (int)response.getStatus());
        this.startSessionAs("user");
        response = this.getResponse("GET", this.getURLResource("connectors?username=root1&expand=secretKey"), null);
        TestConnectorRest.assertNotNull((Object)response);
        TestConnectorRest.assertEquals((int)401, (int)response.getStatus());
    }

    @Test
    public void testConnect() throws Exception {
        this.startSessionAs("root1");
        this.setConnectorPlugin();
        ContainerResponse response = this.launcher.service("GET", this.getURLResource("connectors/oauthCallback/connectorName?code=accessToken"), "", null, null, null);
        TestConnectorRest.assertNotNull((Object)response);
        TestConnectorRest.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testDisconnect() throws Exception {
        this.startSessionAs("root1");
        this.setConnectorPlugin();
        ContainerResponse response = this.launcher.service("GET", this.getURLResource("connectors/oauthCallback/connectorName?code=accessToken"), "", null, null, null);
        TestConnectorRest.assertNotNull((Object)response);
        TestConnectorRest.assertEquals((int)200, (int)response.getStatus());
        byte[] formData = "remoteId=connectorRemoteId".getBytes();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        response = this.launcher.service("DELETE", this.getURLResource("connectors/disconnect/connectorName"), "", (Map)headers, formData, null);
        TestConnectorRest.assertNotNull((Object)response);
        TestConnectorRest.assertEquals((int)204, (int)response.getStatus());
    }

    @Test
    public void testSaveConnectorSettings() throws Exception {
        this.startSessionAs("user");
        ContainerResponse response = this.getPostResponse("connectorName1", "apikey123", "secretKey123", "http://localhost:8080", true);
        TestConnectorRest.assertNotNull((Object)response);
        TestConnectorRest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAsAdministrator("root1");
        response = this.getPostResponse(CONNECTOR_NAME, "apikey12", "secretKey12", "http://localhost:8080", true);
        TestConnectorRest.assertNotNull((Object)response);
        TestConnectorRest.assertEquals((int)204, (int)response.getStatus());
    }

    @Test
    public void testDeleteConnectorSettings() throws Exception {
        this.startSessionAs("user");
        ContainerResponse response = this.getResponse("DELETE", this.getURLResource("connectors/settings/connectorName1"), null);
        TestConnectorRest.assertNotNull((Object)response);
        TestConnectorRest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAsAdministrator("root1");
        response = this.getResponse("DELETE", this.getURLResource("connectors/settings/connectorName1"), null);
        TestConnectorRest.assertNotNull((Object)response);
        TestConnectorRest.assertEquals((int)204, (int)response.getStatus());
    }

    private ContainerResponse getPostResponse(String connectorName, String apiKey, String secretKey, String redirectUrl, boolean enabled) throws Exception {
        byte[] formData = ("connectorName=" + connectorName + "&apiKey=" + apiKey + "&secretKey=" + secretKey + "&redirectUrl=" + redirectUrl + "&enabled=" + enabled).getBytes();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        return this.launcher.service("POST", this.getURLResource("connectors/settings"), "", (Map)headers, formData, null);
    }

    private void removeConnectorPlugin() {
        this.connectorService.removePlugin(CONNECTOR_NAME);
    }

    private void setConnectorPlugin() {
        this.removeConnectorPlugin();
        ConnectorPlugin connectorPlugin = new ConnectorPlugin(){

            public String validateToken(String accessToken) {
                return "connectorRemoteId";
            }

            public String getConnectorName() {
                return TestConnectorRest.CONNECTOR_NAME;
            }
        };
        connectorPlugin.setName(CONNECTOR_NAME);
        this.connectorService.addPlugin(connectorPlugin);
    }
}

