/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceService;

public class GamificationSpaceListener
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(GamificationSpaceListener.class);
    protected RuleService ruleService;
    protected IdentityManager identityManager;
    protected SpaceService spaceService;
    protected ListenerService listenerService;

    public GamificationSpaceListener(RuleService ruleService, IdentityManager identityManager, SpaceService spaceService, ListenerService listenerService) {
        this.ruleService = ruleService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.listenerService = listenerService;
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        String username = (String)event.getSource();
        Space space = event.getSpace();
        this.createRealization(username, space, "addSpace");
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
        String username = (String)event.getSource();
        Space space = event.getSpace();
        this.createRealization(username, space, "updateSpaceDescription");
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
        String username = (String)event.getSource();
        Space space = event.getSpace();
        this.createRealization(username, space, "updateSpaceAvatar");
    }

    public void spaceBannerEdited(SpaceLifeCycleEvent event) {
        String username = (String)event.getSource();
        Space space = event.getSpace();
        this.createRealization(username, space, "updateSpaceBanner");
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
        this.triggerSpaceApplicationCustomizationEvent(event);
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
        this.triggerSpaceApplicationCustomizationEvent(event);
    }

    public void joined(SpaceLifeCycleEvent event) {
        String username = (String)event.getSource();
        Space space = event.getSpace();
        this.createRealization(username, space, "joinSpace");
    }

    public void left(SpaceLifeCycleEvent event) {
        String username = (String)event.getSource();
        Space space = event.getSpace();
        this.cancelRealization(username, space, "joinSpace");
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
        String username = (String)event.getSource();
        Space space = event.getSpace();
        this.createRealization(username, space, "becomeSpaceManager");
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
        String username = (String)event.getSource();
        Space space = event.getSpace();
        this.triggerRealization(space, this.getCurrentIdentityId(), "spaceMembership", space.getId() + "-" + Utils.getUserIdentityId(username), "inviteUserToSpace", "exo.gamification.generic.action");
    }

    public void removeInvitedUser(SpaceLifeCycleEvent event) {
        String username = (String)event.getSource();
        Space space = event.getSpace();
        this.triggerRealization(space, this.getCurrentIdentityId(), "spaceMembership", space.getId() + "-" + Utils.getUserIdentityId(username), "inviteUserToSpace", "gamification.cancel.event.action");
    }

    private void createRealization(String username, Space space, String gamificationEventName) {
        this.triggerRealization(space, this.getModifierIdentityId(username), "identity", null, gamificationEventName, "exo.gamification.generic.action");
    }

    private void cancelRealization(String username, Space space, String gamificationEventName) {
        this.triggerRealization(space, this.getModifierIdentityId(username), "identity", null, gamificationEventName, "gamification.cancel.event.action");
    }

    private void triggerRealization(Space space, String earnerIdentityId, String objectType, String objectId, String gamificationEventName, String eventName) {
        if (space == null) {
            LOG.warn("Can't gamify on null space with modification of type {}", new Object[]{gamificationEventName});
            return;
        }
        if (StringUtils.isBlank((CharSequence)earnerIdentityId)) {
            LOG.info("Can't determine user to gamify space {} modification of type {}", new Object[]{space.getDisplayName(), gamificationEventName});
            return;
        }
        Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        if (spaceIdentity == null) {
            LOG.warn("Can't gamify on space {} having null identity for modification of type {}", new Object[]{space.getDisplayName(), gamificationEventName});
            return;
        }
        String receiverId = spaceIdentity.getId();
        if (StringUtils.equals((CharSequence)objectType, (CharSequence)"identity")) {
            objectId = receiverId;
        }
        HashMap<String, String> gam = new HashMap<String, String>();
        try {
            gam.put("eventId", gamificationEventName);
            gam.put("objectId", objectId);
            gam.put("objectType", objectType);
            gam.put("senderId", earnerIdentityId);
            gam.put("receiverId", receiverId);
            this.listenerService.broadcast(eventName, gam, null);
        }
        catch (Exception e) {
            LOG.error("Error while broadcasting gamification event: {}", new Object[]{gam, e});
        }
        try {
            gam = new HashMap();
            gam.put("eventId", gamificationEventName);
            gam.put("objectId", objectId);
            gam.put("objectType", objectType);
            gam.put("senderId", receiverId);
            gam.put("receiverId", earnerIdentityId);
            this.listenerService.broadcast(eventName, gam, null);
        }
        catch (Exception e) {
            LOG.error("Error while broadcasting gamification event: {}", new Object[]{gam, e});
        }
    }

    private void triggerSpaceApplicationCustomizationEvent(SpaceLifeCycleEvent event) {
        String username = (String)event.getSource();
        Space space = event.getSpace();
        this.createRealization(username, space, "updateSpaceApplications");
    }

    private String getModifierIdentityId(String username) {
        long userIdentityId;
        if (StringUtils.isNotBlank((CharSequence)username) && (userIdentityId = Utils.getUserIdentityId(username)) > 0L) {
            return String.valueOf(userIdentityId);
        }
        return this.getCurrentIdentityId();
    }

    private String getCurrentIdentityId() {
        long currentUserIdentityId = Utils.getCurrentUserIdentityId();
        if (currentUserIdentityId > 0L) {
            return String.valueOf(currentUserIdentityId);
        }
        return null;
    }
}

