/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.liquibase;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;

public class ResetMySQLAutoIncrement
implements CustomTaskChange {
    private String tableName;

    public String getConfirmationMessage() {
        return "Auto increment counter for table '" + this.tableName + "' has been reset";
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public void execute(Database database) throws CustomChangeException {
        JdbcConnection connection = (JdbcConnection)database.getConnection();
        try {
            connection.attached(database);
            CallableStatement statement = connection.prepareCall("SELECT MAX(id)+1 FROM " + this.tableName);
            ResultSet indexResults = statement.executeQuery();
            if (!indexResults.next()) {
                return;
            }
            String result = indexResults.getString(1);
            if (result == null) {
                return;
            }
            CallableStatement query = connection.prepareCall("ALTER TABLE GAMIFICATION_RULE AUTO_INCREMENT = " + result);
            query.execute();
            connection.commit();
        }
        catch (Exception e) {
            throw new CustomChangeException("Error resetting auto increment counter of table " + this.tableName, (Throwable)e);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

