/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.web.filter;

import io.meeds.gamification.web.filter.PublicActionAccessFilter;
import io.meeds.portal.security.constant.UserRegistrationType;
import io.meeds.portal.security.service.SecuritySettingService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class PublicActionAccessFilterTest {
    private static MockedStatic<ExoContainerContext> containerContent;
    @Mock
    LayoutService layoutService;
    @Mock
    SecuritySettingService securitySettingService;
    @Mock
    PortalConfig portalConfig;
    @Mock
    HttpServletRequest request;
    @Mock
    HttpServletResponse response;
    @Mock
    FilterChain filterChain;

    @BeforeClass
    public static void initClassContext() {
        containerContent = Mockito.mockStatic(ExoContainerContext.class);
    }

    @AfterClass
    public static void endClassContext() {
        containerContent.close();
    }

    @Before
    public void setup() {
        containerContent.when(() -> ExoContainerContext.getService(LayoutService.class)).thenReturn((Object)this.layoutService);
        containerContent.when(() -> ExoContainerContext.getService(SecuritySettingService.class)).thenReturn((Object)this.securitySettingService);
    }

    @Test
    public void testDoFilterAnonymousUser() throws IOException, ServletException {
        Mockito.when((Object)this.request.getRequestURI()).thenReturn((Object)"/portal/meeds/overview/contributions/actions/1234");
        new PublicActionAccessFilter().doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendRedirect(ArgumentMatchers.anyString());
        ((FilterChain)Mockito.verify((Object)this.filterChain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Mockito.when((Object)this.securitySettingService.getRegistrationType()).thenReturn((Object)UserRegistrationType.OPEN);
        new PublicActionAccessFilter().doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((LayoutService)Mockito.verify((Object)this.layoutService, (VerificationMode)Mockito.times((int)1))).getPortalConfig((SiteKey)ArgumentMatchers.any(SiteKey.class));
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendRedirect(ArgumentMatchers.anyString());
        ((FilterChain)Mockito.verify((Object)this.filterChain, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Mockito.when((Object)this.layoutService.getPortalConfig(SiteKey.portal((String)"public"))).thenReturn((Object)this.portalConfig);
        new PublicActionAccessFilter().doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendRedirect(ArgumentMatchers.anyString());
        ((FilterChain)Mockito.verify((Object)this.filterChain, (VerificationMode)Mockito.times((int)3))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Mockito.when((Object)this.portalConfig.getAccessPermissions()).thenReturn((Object)new String[]{"/platform/users"});
        new PublicActionAccessFilter().doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendRedirect(ArgumentMatchers.anyString());
        ((FilterChain)Mockito.verify((Object)this.filterChain, (VerificationMode)Mockito.times((int)4))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Mockito.when((Object)this.portalConfig.getAccessPermissions()).thenReturn((Object)new String[]{"Everyone"});
        new PublicActionAccessFilter().doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).sendRedirect("/portal/public/overview/actions/1234");
        ((FilterChain)Mockito.verify((Object)this.filterChain, (VerificationMode)Mockito.times((int)4))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
    }

    @Test
    public void testDoFilterAuthenticatedUser() throws IOException, ServletException {
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn((Object)"user");
        Mockito.when((Object)this.request.getRequestURI()).thenReturn((Object)"/portal/meeds/overview/contributions/actions/1234");
        new PublicActionAccessFilter().doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendRedirect(ArgumentMatchers.anyString());
        ((FilterChain)Mockito.verify((Object)this.filterChain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Mockito.when((Object)this.securitySettingService.getRegistrationType()).thenReturn((Object)UserRegistrationType.OPEN);
        new PublicActionAccessFilter().doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((LayoutService)Mockito.verify((Object)this.layoutService, (VerificationMode)Mockito.never())).getPortalConfig((SiteKey)ArgumentMatchers.any(SiteKey.class));
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendRedirect(ArgumentMatchers.anyString());
        ((FilterChain)Mockito.verify((Object)this.filterChain, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Mockito.when((Object)this.layoutService.getPortalConfig(SiteKey.portal((String)"public"))).thenReturn((Object)this.portalConfig);
        new PublicActionAccessFilter().doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((LayoutService)Mockito.verify((Object)this.layoutService, (VerificationMode)Mockito.never())).getPortalConfig((SiteKey)ArgumentMatchers.any(SiteKey.class));
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendRedirect(ArgumentMatchers.anyString());
        ((FilterChain)Mockito.verify((Object)this.filterChain, (VerificationMode)Mockito.times((int)3))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Mockito.when((Object)this.portalConfig.getAccessPermissions()).thenReturn((Object)new String[]{"/platform/users"});
        new PublicActionAccessFilter().doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((LayoutService)Mockito.verify((Object)this.layoutService, (VerificationMode)Mockito.never())).getPortalConfig((SiteKey)ArgumentMatchers.any(SiteKey.class));
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendRedirect(ArgumentMatchers.anyString());
        ((FilterChain)Mockito.verify((Object)this.filterChain, (VerificationMode)Mockito.times((int)4))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Mockito.when((Object)this.portalConfig.getAccessPermissions()).thenReturn((Object)new String[]{"Everyone"});
        new PublicActionAccessFilter().doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ((LayoutService)Mockito.verify((Object)this.layoutService, (VerificationMode)Mockito.never())).getPortalConfig((SiteKey)ArgumentMatchers.any(SiteKey.class));
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).sendRedirect(ArgumentMatchers.anyString());
        ((FilterChain)Mockito.verify((Object)this.filterChain, (VerificationMode)Mockito.times((int)5))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
    }
}

