/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service;

import io.meeds.gamification.model.BadgeDTO;
import io.meeds.gamification.plugin.BadgeConfigPlugin;
import io.meeds.gamification.service.impl.BadgeRegistryImpl;
import io.meeds.gamification.test.AbstractServiceTest;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.junit.Before;
import org.junit.Test;

public class BadgeRegistryTest
extends AbstractServiceTest {
    private BadgeRegistryImpl badgeRegistry;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (this.badgeRegistry == null) {
            this.badgeRegistry = new BadgeRegistryImpl(this.fileService, this.badgeService);
        }
    }

    @Test
    public void testAddPlugin() throws Exception {
        InitParams initParams = new InitParams();
        String title = "Test Bagde1";
        this.addValueParam(initParams, "badge-title", title);
        this.addValueParam(initParams, "badge-description", "Badge description");
        this.addValueParam(initParams, "badge-icon", "notExisting");
        this.addValueParam(initParams, "badge-neededScore", "20");
        this.addValueParam(initParams, "badge-enable", "true");
        this.badgeRegistry.addPlugin(new BadgeConfigPlugin(initParams));
        this.badgeRegistry.start();
        this.restartTransaction();
        BadgeDTO badge = this.badgeService.findBadgeByTitle(title);
        BadgeRegistryTest.assertNotNull((Object)badge);
        BadgeRegistryTest.assertEquals((long)0L, (long)badge.getIconFileId());
    }

    @Test
    public void testRemovePlugin() throws Exception {
        InitParams initParams = new InitParams();
        String title = "Test Bagde1";
        this.addValueParam(initParams, "badge-title", title);
        this.addValueParam(initParams, "badge-description", "Badge description");
        this.addValueParam(initParams, "badge-icon", "notExisting");
        this.addValueParam(initParams, "badge-neededScore", "20");
        this.addValueParam(initParams, "badge-enable", "true");
        BadgeConfigPlugin badgeConfig = new BadgeConfigPlugin(initParams);
        this.badgeRegistry.addPlugin(badgeConfig);
        this.badgeRegistry.remove(badgeConfig);
        this.badgeRegistry.start();
        this.restartTransaction();
        BadgeDTO badge = this.badgeService.findBadgeByTitle(title);
        BadgeRegistryTest.assertNull((Object)badge);
    }

    private void addValueParam(InitParams initParams, String name, String value) {
        ValueParam valueParam = new ValueParam();
        valueParam.setName(name);
        valueParam.setValue(value);
        initParams.addParameter((Parameter)valueParam);
    }
}

