/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.dao;

import io.meeds.gamification.constant.EntityFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.model.filter.ProgramFilter;
import io.meeds.gamification.test.AbstractServiceTest;
import org.junit.Test;

public class ProgramDAOTest
extends AbstractServiceTest {
    @Test
    public void testGetProgramsByFilter() {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        filter.setAllSpaces(true);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        this.newDomain(EntityType.MANUAL, "domain1", true, null);
        this.newDomain(EntityType.MANUAL, "domain2", true, null);
        this.newDomain(EntityType.AUTOMATIC, "domain3", true, null);
        this.newDomain(EntityType.AUTOMATIC, "domain4", true, null);
        ProgramDAOTest.assertEquals((int)4, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        this.newDomain(EntityType.AUTOMATIC, "domain5", false, null);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        this.newDomain(EntityType.MANUAL, "domain6", false, null);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setStatus(EntityStatusType.ALL);
        filter.setType(EntityFilterType.ALL);
        ProgramDAOTest.assertEquals((int)6, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setStatus(EntityStatusType.DISABLED);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramDAOTest.assertEquals((int)1, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramDAOTest.assertEquals((int)1, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
    }

    @Test
    public void testGetOpenProgramsByFilter() {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        filter.setAllSpaces(false);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        this.newDomain(EntityType.MANUAL, "domain1", true, null, null);
        this.newDomain(EntityType.MANUAL, "domain2", true, null, null);
        this.newDomain(EntityType.AUTOMATIC, "domain3", true, null, null);
        this.newDomain(EntityType.AUTOMATIC, "domain4", true, null, null);
        ProgramDAOTest.assertEquals((int)4, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        this.newDomain(EntityType.AUTOMATIC, "domain5", false, null, null);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        this.newDomain(EntityType.MANUAL, "domain6", false, null, null);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setStatus(EntityStatusType.ALL);
        filter.setType(EntityFilterType.ALL);
        ProgramDAOTest.assertEquals((int)6, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setStatus(EntityStatusType.DISABLED);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramDAOTest.assertEquals((int)1, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramDAOTest.assertEquals((int)1, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
    }

    @Test
    public void testGetProgramsByTextualFilter() {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        filter.setAllSpaces(true);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        this.newDomain(EntityType.MANUAL, "domain1", true, null);
        this.newDomain(EntityType.MANUAL, "domain2", true, null);
        this.newDomain(EntityType.AUTOMATIC, "domain3", true, null);
        this.newDomain(EntityType.AUTOMATIC, "domain4", true, null, null);
        filter.setProgramTitle("domain1");
        ProgramDAOTest.assertEquals((int)1, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        this.newDomain(EntityType.AUTOMATIC, "domain5", false, null);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramDAOTest.assertEquals((int)1, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        this.newDomain(EntityType.AUTOMATIC, "domain1", true, null);
        ProgramDAOTest.assertEquals((int)1, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setStatus(EntityStatusType.ALL);
        filter.setType(EntityFilterType.ALL);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setStatus(EntityStatusType.DISABLED);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
    }

    @Test
    public void testGetOpenProgramsByTextualFilter() {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        filter.setAllSpaces(false);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        this.newDomain(EntityType.MANUAL, "domain1", true, null, null);
        this.newDomain(EntityType.MANUAL, "domain2", true, null, null);
        this.newDomain(EntityType.AUTOMATIC, "domain3", true, null, null);
        this.newDomain(EntityType.AUTOMATIC, "domain4", true, null, null);
        this.newDomain(EntityType.AUTOMATIC, "adminDomain", true, null, 1L);
        filter.setProgramTitle("domain1");
        ProgramDAOTest.assertEquals((int)1, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        this.newDomain(EntityType.AUTOMATIC, "domain5", false, null, null);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramDAOTest.assertEquals((int)1, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        this.newDomain(EntityType.AUTOMATIC, "domain1", true, null, null);
        ProgramDAOTest.assertEquals((int)1, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setStatus(EntityStatusType.ALL);
        filter.setType(EntityFilterType.ALL);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setStatus(EntityStatusType.DISABLED);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.getProgramIdsByFilter(0, 10, filter).size());
    }

    @Test
    public void testCountPrograms() {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        filter.setAllSpaces(true);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.countPrograms(filter));
        this.newDomain(EntityType.MANUAL, "domain1", true, null);
        this.newDomain(EntityType.MANUAL, "domain2", true, null);
        this.newDomain(EntityType.AUTOMATIC, "domain3", true, null);
        this.newDomain(EntityType.AUTOMATIC, "domain4", true, null);
        ProgramDAOTest.assertEquals((int)4, (int)this.programDAO.countPrograms(filter));
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.countPrograms(filter));
        this.newDomain(EntityType.AUTOMATIC, "domain5", false, null);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.countPrograms(filter));
        filter.setType(EntityFilterType.MANUAL);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.countPrograms(filter));
        this.newDomain(EntityType.MANUAL, "domain6", false, null);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.countPrograms(filter));
        filter.setStatus(EntityStatusType.ALL);
        filter.setType(EntityFilterType.ALL);
        ProgramDAOTest.assertEquals((int)6, (int)this.programDAO.countPrograms(filter));
        filter.setStatus(EntityStatusType.DISABLED);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.countPrograms(filter));
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramDAOTest.assertEquals((int)1, (int)this.programDAO.countPrograms(filter));
        filter.setType(EntityFilterType.MANUAL);
        ProgramDAOTest.assertEquals((int)1, (int)this.programDAO.countPrograms(filter));
    }

    @Test
    public void testCountOpenPrograms() {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        filter.setAllSpaces(false);
        ProgramDAOTest.assertEquals((int)0, (int)this.programDAO.countPrograms(filter));
        this.newDomain(EntityType.MANUAL, "domain1", true, null, null);
        this.newDomain(EntityType.MANUAL, "domain2", true, null, null);
        this.newDomain(EntityType.AUTOMATIC, "domain3", true, null, null);
        this.newDomain(EntityType.AUTOMATIC, "domain4", true, null, null);
        ProgramDAOTest.assertEquals((int)4, (int)this.programDAO.countPrograms(filter));
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.countPrograms(filter));
        this.newDomain(EntityType.AUTOMATIC, "domain5", false, null, null);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.countPrograms(filter));
        filter.setType(EntityFilterType.MANUAL);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.countPrograms(filter));
        this.newDomain(EntityType.MANUAL, "domain6", false, null, null);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.countPrograms(filter));
        filter.setStatus(EntityStatusType.ALL);
        filter.setType(EntityFilterType.ALL);
        ProgramDAOTest.assertEquals((int)6, (int)this.programDAO.countPrograms(filter));
        filter.setStatus(EntityStatusType.DISABLED);
        ProgramDAOTest.assertEquals((int)2, (int)this.programDAO.countPrograms(filter));
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramDAOTest.assertEquals((int)1, (int)this.programDAO.countPrograms(filter));
        filter.setType(EntityFilterType.MANUAL);
        ProgramDAOTest.assertEquals((int)1, (int)this.programDAO.countPrograms(filter));
    }
}

