/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.glpi.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.InputStream;
import java.util.Date;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.glpi.model.GLPISettings;
import org.exoplatform.glpi.rest.model.GLPISettingsEntity;
import org.exoplatform.glpi.rest.utils.EntityBuilder;
import org.exoplatform.glpi.service.GLPIService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

@Path(value="/v1/glpi-integration")
@Tag(name="/v1/glpi-integration", description="Manages GLPI Integration")
public class GLPIRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(GLPIRestService.class);
    private final GLPIService glpiService;
    private static final int CACHE_DURATION_SECONDS = 31536000;
    private static final long CACHE_DURATION_MILLISECONDS = 31536000000L;
    private static final CacheControl ILLUSTRATION_CACHE_CONTROL = new CacheControl();

    public GLPIRestService(GLPIService glpiService) {
        this.glpiService = glpiService;
    }

    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/settings")
    @Operation(summary="Save GLPI Settings", description="Saves GLPI Settings", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Object saved"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveGLPISettings(@RequestBody(description="GLPISettings settings object", required=true) GLPISettingsEntity glpiSettingsEntity) {
        if (glpiSettingsEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"GLPISettings object is mandatory").build();
        }
        try {
            GLPISettings glpiSettings = this.glpiService.saveGLPISettings(glpiSettingsEntity.getServerApiUrl(), glpiSettingsEntity.getAppToken(), glpiSettingsEntity.getMaxTicketsToDisplay());
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)EntityBuilder.toGLPISettingsEntity(glpiSettings, true)).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while saving GLPI Settings", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/settings")
    @Operation(summary="Retrieves GLPI Settings", description="Retrieves saved GLPI Settings", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getGLPISettings() {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            GLPISettings glpiSettings = this.glpiService.getGLPISettings();
            if (glpiSettings == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)EntityBuilder.toGLPISettingsResponseEntity(null, identity, this.glpiService)).build();
            }
            return Response.ok((Object)EntityBuilder.toGLPISettingsResponseEntity(glpiSettings, identity, this.glpiService)).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting GLPI Settings", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/token")
    @Operation(summary="Save GLPI user token", description="Save GLPI user token", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="not authorized"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveGLPIUserToken(@Parameter(description="GLPI user token", required=true) String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"GLPI user token is mandatory").build();
        }
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            if (!this.glpiService.isUserTokenValid(token)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"token is not valid").build();
            }
            this.glpiService.saveUserToken(token, identity.getUserId());
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while saving GLPI user token", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/tickets")
    @Operation(summary="Retrieves GLPI ticket list", description="Retrieves GLPI ticket list", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getGLPITickets(@Parameter(description="Ticket list result limit") @DefaultValue(value="0") @QueryParam(value="offset") int offset, @Parameter(description="Ticket list result offset") @DefaultValue(value="9") @QueryParam(value="limit") int limit) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            return Response.ok(EntityBuilder.toGLPITicketListEntity(this.glpiService.getGLPITickets(offset, limit, identity.getUserId()))).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting GLPI tickets", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/image/{docId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets a GLPI ticket document image by its id", description="Gets a GLPI ticket document image by its id", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getImageIllustration(@Context Request request, @Parameter(description="workflow id", required=true) @PathParam(value="docId") Long docId, @Parameter(description="Last modified parameter") @QueryParam(value="v") long lastModified) {
        if (docId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Image doc id is mandatory").build();
        }
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            EntityTag eTag = new EntityTag(String.valueOf(lastModified), true);
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                InputStream inputStream = this.glpiService.readTicketImageDocument(docId.longValue(), identity.getUserId());
                builder = Response.ok((Object)inputStream, (String)"image/png");
                builder.tag(eTag);
                if (lastModified > 0L) {
                    builder.lastModified(new Date(lastModified));
                    builder.expires(new Date(System.currentTimeMillis() + 31536000000L));
                    builder.cacheControl(ILLUSTRATION_CACHE_CONTROL);
                }
            }
            return builder.build();
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while getting GLPI ticket document image", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/token")
    @Operation(summary="Remove GLPI user token", description="Remove GLPI user token", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response removeGLPIUserToken() {
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            this.glpiService.removeUserToken(identity.getUserId());
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while removing GLPI user token", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

