/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.glpi.rest;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.exoplatform.glpi.model.GLPISettings;
import org.exoplatform.glpi.model.GlpiTicket;
import org.exoplatform.glpi.model.GlpiUser;
import org.exoplatform.glpi.model.TicketStatus;
import org.exoplatform.glpi.rest.GLPIRestService;
import org.exoplatform.glpi.rest.model.GLPISettingsEntity;
import org.exoplatform.glpi.service.GLPIService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class GLPIRestServiceTest {
    @Mock
    private GLPIService glpiService;
    private GLPIRestService glpiRestService;
    private static final MockedStatic<ConversationState> CONVERSATION_STATE = Mockito.mockStatic(ConversationState.class);
    @Mock
    private Identity identity;

    @Before
    public void setUp() {
        this.glpiRestService = new GLPIRestService(this.glpiService);
        ConversationState conversationState = (ConversationState)Mockito.mock(ConversationState.class);
        CONVERSATION_STATE.when(ConversationState::getCurrent).thenReturn((Object)conversationState);
        CONVERSATION_STATE.when(() -> ((ConversationState)conversationState).getIdentity()).thenReturn((Object)this.identity);
    }

    @AfterClass
    public static void afterRunBare() {
        CONVERSATION_STATE.close();
    }

    @Test
    public void saveGLPISettings() {
        GLPISettingsEntity glpiSettingsEntity = new GLPISettingsEntity("url", "token", 10);
        Response response = this.glpiRestService.saveGLPISettings(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        response = this.glpiRestService.saveGLPISettings(glpiSettingsEntity);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        ((GLPIService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.glpiService)).saveGLPISettings("url", "token", 10);
        response = this.glpiRestService.saveGLPISettings(glpiSettingsEntity);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void getGLPISettings() {
        Mockito.when((Object)this.identity.isMemberOf(Mockito.anyString())).thenReturn((Object)true);
        GLPISettings glpiSettings = new GLPISettings("url", "token", 10);
        Mockito.when((Object)this.glpiService.getGLPISettings()).thenReturn(null);
        Response response = this.glpiRestService.getGLPISettings();
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.glpiService.getGLPISettings()).thenReturn((Object)glpiSettings);
        response = this.glpiRestService.getGLPISettings();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.glpiService.getGLPISettings()).thenThrow(RuntimeException.class);
        response = this.glpiRestService.getGLPISettings();
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void saveGLPIUserToken() {
        Response response = this.glpiRestService.saveGLPIUserToken(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)"1");
        Mockito.when((Object)this.glpiService.isUserTokenValid("token")).thenReturn((Object)false, (Object[])new Boolean[]{true});
        response = this.glpiRestService.saveGLPIUserToken("token");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        response = this.glpiRestService.saveGLPIUserToken("token");
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.getStatus());
        ((GLPIService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.glpiService)).saveUserToken("token", "1");
        response = this.glpiRestService.saveGLPIUserToken("token");
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void getGLPITickets() {
        ArrayList<GlpiUser> glpiUsers = new ArrayList<GlpiUser>();
        glpiUsers.add(new GlpiUser(1L, "user", "first", "last"));
        GlpiTicket glpiTicket = new GlpiTicket(1L, "title", "content", TicketStatus.NEW, glpiUsers, new ArrayList(), "solveDate", "lastUpdate");
        ArrayList<GlpiTicket> ticketList = new ArrayList<GlpiTicket>();
        ticketList.add(glpiTicket);
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)"user");
        Mockito.when((Object)this.glpiService.getGLPITickets(0, 10, "user")).thenReturn(ticketList);
        Response response = this.glpiRestService.getGLPITickets(0, 10);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        ((GLPIService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.glpiService)).getGLPITickets(0, 10, "user");
        response = this.glpiRestService.getGLPITickets(0, 10);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void getImageIllustration() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)"user");
        Response response = this.glpiRestService.getImageIllustration(request, null, 12345679L);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)request.evaluatePreconditions((EntityTag)Mockito.any(EntityTag.class))).thenReturn(null);
        Mockito.when((Object)this.glpiService.readTicketImageDocument(1L, "user")).thenReturn((Object)new ByteArrayInputStream("test".getBytes()));
        response = this.glpiRestService.getImageIllustration(request, Long.valueOf(1L), 12345679L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        ((GLPIService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.glpiService)).readTicketImageDocument(1L, "user");
        response = this.glpiRestService.getImageIllustration(request, Long.valueOf(1L), 12345679L);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void removeGLPIUserToken() {
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)"user");
        Response response = this.glpiRestService.removeGLPIUserToken();
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.getStatus());
        ((GLPIService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.glpiService)).removeUserToken("user");
        response = this.glpiRestService.removeGLPIUserToken();
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }
}

