/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.jitsi.rest;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.webconferencing.ContextInfo;
import org.exoplatform.webconferencing.IdentityStateException;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.Utils;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.jitsi.JitsiProvider;
import org.gatein.portal.controller.resource.ResourceRequestHandler;

@Path(value="/jitsi")
public class JitsiContextResource
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(JitsiContextResource.class);
    private final WebConferencingService webconferencing;

    public JitsiContextResource(WebConferencingService webconferencing) {
        this.webconferencing = webconferencing;
    }

    @GET
    @Path(value="/context/{userId}")
    @Produces(value={"application/json"})
    public ContextInfo context(@Context HttpServletRequest request, @PathParam(value="userId") String userId) {
        return Utils.getCurrentContext((String)userId, (Locale)request.getLocale());
    }

    @GET
    @Path(value="/settings")
    public Response settings() {
        try {
            JitsiProvider provider = (JitsiProvider)this.webconferencing.getProvider("jitsi");
            if (provider != null) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)provider.getSettings()).type("application/json").build();
            }
        }
        catch (ClassCastException e) {
            LOG.error((Object)("Provider jitsi isn't an instance of " + JitsiProvider.class.getName()), (Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{\"error\":\"Cannot find valid Jitsi provider \"}").type("application/json").build();
    }

    @GET
    @Path(value="/userinfo")
    public Response userInfo(@Context HttpServletRequest request) {
        ConversationState state = ConversationState.getCurrent();
        if (state != null && !state.getIdentity().getUserId().equals(IdentityConstants.ANONIM)) {
            String userId = state.getIdentity().getUserId();
            try {
                UserInfo userInfo = this.webconferencing.getUserInfo(userId);
                String authToken = String.valueOf(request.getServletContext().getAttribute("token"));
                return Response.status((Response.Status)Response.Status.OK).entity((Object)new UserInfoResponse(userInfo, authToken)).type("application/json").build();
            }
            catch (IdentityStateException e) {
                LOG.warn("Cannot find identity with id: {}", new Object[]{userId});
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"error\":\"Cannot find identity with id: " + userId + "\"}")).type("application/json").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"{\"error\":\"Current user is not authorized\"}").type("application/json").build();
    }

    @GET
    @Path(value="/resources/version")
    public Response resourcesVersion() {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ResourceRequestHandler.VERSION).build();
    }

    public class UserInfoResponse {
        private final UserInfo userInfo;
        private final String authToken;

        public UserInfoResponse(UserInfo userInfo, String authToken) {
            this.userInfo = userInfo;
            this.authToken = authToken;
        }

        public UserInfo getUserInfo() {
            return this.userInfo;
        }

        public String getAuthToken() {
            return this.authToken;
        }
    }

    public class InitContext {
        private final String username;
        private final UserInfo userInfo;
        private final ContextInfo context;

        public InitContext(String username, UserInfo userInfo, ContextInfo context) {
            this.username = username;
            this.userInfo = userInfo;
            this.context = context;
        }

        public String getUsername() {
            return this.username;
        }

        public UserInfo getUserInfo() {
            return this.userInfo;
        }

        public ContextInfo getContext() {
            return this.context;
        }
    }
}

