/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.jitsi.rest.filter;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SignatureException;
import java.io.IOException;
import java.security.Key;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.web.filter.Filter;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.jitsi.JitsiProvider;

public class WebconferencingSessionFilter
extends AbstractFilter
implements Filter {
    private static final Log LOG = ExoLogger.getLogger(WebconferencingSessionFilter.class);
    private static final String AUTH_TOKEN_ATTRIBUTE = "X-Exoplatform-Auth";
    private static final String INTERNAL_AUTH = "internal_auth";
    private static final String EXTERNAL_AUTH = "external_auth";
    private static final String USERNAME = "username";
    private WebConferencingService webconferencing;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block11: {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            if (this.checkAuthToken(req)) {
                String webconfToken = this.getCookie(req, WebConferencingService.SESSION_TOKEN_COOKIE);
                Claims claims = this.getClaims(webconfToken, this.getWebconferencing().getSecretKey());
                if (claims != null && claims.containsKey((Object)USERNAME)) {
                    try {
                        String username = String.valueOf(claims.get((Object)USERNAME));
                        if (this.isActiveUser(username)) {
                            ExoContainer container = this.getContainer();
                            ExoContainerContext.setCurrentContainer((ExoContainer)container);
                            ConversationState state = this.createState(username);
                            ConversationState.setCurrent((ConversationState)state);
                            SessionProviderService sessionProviders = (SessionProviderService)this.getContainer().getComponentInstanceOfType(SessionProviderService.class);
                            SessionProvider userProvider = new SessionProvider(state);
                            sessionProviders.setSessionProvider(null, userProvider);
                            chain.doFilter(request, response);
                            try {
                                ConversationState.setCurrent(null);
                            }
                            catch (Exception e) {
                                LOG.warn((Object)"An error occured while cleaning the ConversationState", (Throwable)e);
                            }
                            try {
                                ExoContainerContext.setCurrentContainer(null);
                            }
                            catch (Exception e) {
                                LOG.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
                            }
                            break block11;
                        }
                        LOG.warn("The user {} is not active", new Object[]{username});
                        this.writeError(resp, 403, "The user is not active");
                    }
                    catch (Exception e) {
                        LOG.warn("Cannot set ConversationState based on provided token", new Object[]{e.getMessage()});
                        chain.doFilter(request, response);
                    }
                } else {
                    chain.doFilter(request, response);
                }
            } else {
                LOG.warn((Object)"The request doesn't contain valid access token for internal auth");
                this.writeError(resp, 401, "The request is not authorized");
            }
        }
    }

    private void writeError(HttpServletResponse response, int status, String message) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(status);
        response.getWriter().write("{\"error\":\"" + message + "\"}");
    }

    public void destroy() {
    }

    private String getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    private Claims getClaims(String token, String secret) {
        if (token == null || token.trim().isEmpty()) {
            return null;
        }
        try {
            Jws jws = Jwts.parser().setSigningKey((Key)Keys.hmacShaKeyFor((byte[])secret.getBytes())).parseClaimsJws(token);
            return (Claims)jws.getBody();
        }
        catch (ExpiredJwtException | SignatureException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The token is not valid: {} : {}", new Object[]{token, e.getMessage()});
            }
        }
        catch (Exception e) {
            LOG.warn("Couldn't validate the token: {} : {}", new Object[]{token, e.getMessage()});
        }
        return null;
    }

    private ConversationState createState(String userId) {
        Identity userIdentity = this.userIdentity(userId);
        if (userIdentity != null) {
            ConversationState state = new ConversationState(userIdentity);
            state.setAttribute("subject", (Object)userIdentity.getSubject());
            return state;
        }
        LOG.warn((Object)("User identity not found " + userId + " for setting conversation state"));
        return null;
    }

    protected Identity userIdentity(String userId) {
        IdentityRegistry identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
        Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
        Identity userIdentity = identityRegistry.getIdentity(userId);
        if (userIdentity == null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User identity not registered, trying to create it for: " + userId));
                }
                userIdentity = authenticator.createIdentity(userId);
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to create user identity: " + userId), (Throwable)e);
            }
        }
        return userIdentity;
    }

    protected boolean isActiveUser(String userId) {
        IdentityManager identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        org.exoplatform.social.core.identity.model.Identity identity = identityManager.getOrCreateIdentity("organization", userId);
        return !identity.isDeleted() && identity.isEnable();
    }

    protected boolean checkAuthToken(HttpServletRequest request) {
        JitsiProvider provider = (JitsiProvider)this.getWebconferencing().getProvider("jitsi");
        if (request.getHeader(AUTH_TOKEN_ATTRIBUTE) != null) {
            String action;
            String token = request.getHeader(AUTH_TOKEN_ATTRIBUTE);
            Claims claims = this.getClaims(token, provider.getInternalAuthSecret());
            if (claims == null) {
                claims = this.getClaims(token, provider.getExternalAuthSecret());
            }
            if (claims != null && claims.containsKey("action") && (INTERNAL_AUTH.equals(action = String.valueOf(claims.get("action"))) || EXTERNAL_AUTH.equals(action))) {
                request.getServletContext().setAttribute("auth_type", (Object)action);
                request.getServletContext().setAttribute("token", (Object)token);
                return true;
            }
            return false;
        }
        LOG.warn((Object)"The request doesn't contain auth token header");
        return false;
    }

    private WebConferencingService getWebconferencing() {
        if (this.webconferencing == null) {
            this.webconferencing = (WebConferencingService)this.getContainer().getComponentInstanceOfType(WebConferencingService.class);
        }
        return this.webconferencing;
    }
}

