/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.jitsi;

import java.util.Locale;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.profile.settings.IMType;
import org.exoplatform.social.core.profile.settings.UserProfileSettingsService;
import org.exoplatform.webconferencing.CallProvider;
import org.exoplatform.webconferencing.UserInfo;

public class JitsiProvider
extends CallProvider {
    protected static final Log LOG = ExoLogger.getLogger(JitsiProvider.class);
    public static final String TYPE = "jitsi";
    public static final String CONFIG_CLIENT_SECRET = "client-secret";
    public static final String CONFIG_INTERNAL_AUTH_SECRET = "internal-auth-secret";
    public static final String CONFIG_EXTERNAL_AUTH_SECRET = "external-auth-secret";
    public static final String CONFIG_SERVICE_URL = "service-url";
    public static final String TITLE = "Jitsi";
    public static final String VERSION = "1.0.0";
    protected final String internalAuthSecret;
    protected final String externalAuthSecret;
    protected final String url;

    public JitsiProvider(UserProfileSettingsService profileSettings, InitParams params) throws ConfigurationException {
        super(params);
        String internalAuthSecret = (String)this.config.get(CONFIG_INTERNAL_AUTH_SECRET);
        if (internalAuthSecret == null || (internalAuthSecret = internalAuthSecret.trim()).length() == 0) {
            throw new ConfigurationException("internal-auth-secret required and should be non empty.");
        }
        this.internalAuthSecret = internalAuthSecret;
        String externalAuthSecret = (String)this.config.get(CONFIG_EXTERNAL_AUTH_SECRET);
        if (externalAuthSecret == null || (externalAuthSecret = externalAuthSecret.trim()).length() == 0) {
            throw new ConfigurationException("external-auth-secret required and should be non empty.");
        }
        this.externalAuthSecret = externalAuthSecret;
        String serviceUrl = (String)this.config.get(CONFIG_SERVICE_URL);
        if (serviceUrl == null || (serviceUrl = serviceUrl.trim()).length() == 0) {
            throw new ConfigurationException("service-url required and should be non empty.");
        }
        this.url = serviceUrl;
        if (profileSettings != null) {
            profileSettings.addIMType(new IMType(TYPE, TITLE));
        }
    }

    public JitsiProvider(InitParams params) throws ConfigurationException {
        this(null, params);
    }

    public String getInternalAuthSecret() {
        return this.internalAuthSecret;
    }

    public String getExternalAuthSecret() {
        return this.externalAuthSecret;
    }

    public JitsiSettings getSettings() {
        return new JitsiSettings();
    }

    public String getUrl() {
        return this.url;
    }

    public UserInfo.IMInfo getIMInfo(String imId) {
        return new JitsiIMInfo(imId);
    }

    public String getType() {
        return TYPE;
    }

    public String[] getSupportedTypes() {
        return new String[]{this.getType()};
    }

    public String getTitle() {
        return TITLE;
    }

    public String getDescription(Locale locale) {
        return super.getDescription(locale);
    }

    public String getVersion() {
        return VERSION;
    }

    public class JitsiIMInfo
    extends UserInfo.IMInfo {
        protected JitsiIMInfo(String id) {
            super(JitsiProvider.TYPE, id);
        }
    }

    public class JitsiSettings
    extends CallProvider.Settings {
        public JitsiSettings() {
            super((CallProvider)JitsiProvider.this);
        }

        public String getUrl() {
            return JitsiProvider.this.getUrl();
        }
    }
}

