/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.jitsi.rest;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.webconferencing.ContextInfo;
import org.exoplatform.webconferencing.IdentityStateException;
import org.exoplatform.webconferencing.UploadFileException;
import org.exoplatform.webconferencing.UploadFileInfo;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.Utils;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.jitsi.JitsiProvider;
import org.gatein.portal.controller.resource.ResourceRequestHandler;

@Path(value="/jitsi")
public class JitsiContextResource
implements ResourceContainer {
    private static final String INTERNAL_AUTH = "internal_auth";
    private static final Log LOG = ExoLogger.getLogger(JitsiContextResource.class);
    private final WebConferencingService webconferencing;
    private final JitsiProvider provider;

    public JitsiContextResource(WebConferencingService webconferencing, RepositoryService repositoryService, SessionProviderService sessionProviders) {
        this.webconferencing = webconferencing;
        this.provider = (JitsiProvider)webconferencing.getProvider("jitsi");
    }

    @GET
    @Path(value="/context/{userId}")
    @Produces(value={"application/json"})
    public ContextInfo context(@Context HttpServletRequest request, @PathParam(value="userId") String userId) {
        return Utils.getCurrentContext((String)userId, (Locale)request.getLocale());
    }

    @GET
    @Path(value="/settings")
    public Response settings() {
        if (this.provider != null) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.provider.getSettings()).type("application/json").build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{\"error\":\"Jitsi Provider is not registered in webconferencing \"}").type("application/json").build();
    }

    @POST
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    public Response upload(@Context HttpServletRequest request, @QueryParam(value="token") String token) {
        String callId = null;
        String owner = null;
        String type = null;
        String moderator = null;
        List participants = null;
        try {
            Claims body = (Claims)Jwts.parser().setSigningKey((Key)Keys.hmacShaKeyFor((byte[])this.provider.getExternalAuthSecret().getBytes())).parseClaimsJws(token).getBody();
            owner = (String)body.get("owner", String.class);
            type = (String)body.get("type", String.class);
            moderator = (String)body.get("moderator", String.class);
            callId = (String)body.get("callId", String.class);
            participants = (List)body.get("participants", List.class);
        }
        catch (Exception e) {
            LOG.error("Cannot parse JWT token for uploading recording", new Object[]{e.getMessage()});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\":\"JWT token is invalid\"}").build();
        }
        if (callId == null || owner == null || type == null || moderator == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\":\"JWT token should contain owner, type, moderator\"}").build();
        }
        try {
            UploadFileInfo uploadFileInfo = new UploadFileInfo(callId, owner, type, moderator, participants);
            this.webconferencing.uploadFile(uploadFileInfo, request);
            return Response.ok().build();
        }
        catch (RepositoryException | UploadFileException e) {
            LOG.error((Object)("Cannot upload recording for " + owner), e);
            return Response.serverError().entity((Object)("{\"error\":\"Cannot upload recording for " + owner + "\"}")).build();
        }
    }

    @GET
    @Path(value="/userinfo")
    @Produces(value={"application/json"})
    public Response userInfo(@Context HttpServletRequest request) {
        ConversationState state = ConversationState.getCurrent();
        if (state != null && !state.getIdentity().getUserId().equals(IdentityConstants.ANONIM)) {
            String userId = state.getIdentity().getUserId();
            try {
                UserInfo userInfo = this.webconferencing.getUserInfo(userId);
                String authToken = String.valueOf(request.getServletContext().getAttribute("token"));
                return Response.ok().entity((Object)new UserInfoResponse(userInfo, authToken)).build();
            }
            catch (IdentityStateException e) {
                LOG.warn("Cannot find identity with id: {}", new Object[]{userId});
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"error\":\"Cannot find identity with id: " + userId + "\"}")).type("application/json").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"{\"error\":\"Current user is not authorized\"}").type("application/json").build();
    }

    @GET
    @Path(value="/token")
    @Produces(value={"application/json"})
    public Response token(@Context HttpServletRequest request) {
        String token = Jwts.builder().setSubject("exo-webconf").claim("action", (Object)INTERNAL_AUTH.toString().toLowerCase()).setExpiration(new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(10L))).signWith((Key)Keys.hmacShaKeyFor((byte[])this.provider.getInternalAuthSecret().getBytes())).compact();
        return Response.ok().entity((Object)("{\"token\": \" " + token + "\"}")).build();
    }

    @GET
    @Path(value="/resources/version")
    public Response resourcesVersion() {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ResourceRequestHandler.VERSION).build();
    }

    public class UserInfoResponse {
        private final UserInfo userInfo;
        private final String authToken;

        public UserInfoResponse(UserInfo userInfo, String authToken) {
            this.userInfo = userInfo;
            this.authToken = authToken;
        }

        public UserInfo getUserInfo() {
            return this.userInfo;
        }

        public String getAuthToken() {
            return this.authToken;
        }
    }

    public class InitContext {
        private final String username;
        private final UserInfo userInfo;
        private final ContextInfo context;

        public InitContext(String username, UserInfo userInfo, ContextInfo context) {
            this.username = username;
            this.userInfo = userInfo;
            this.context = context;
        }

        public String getUsername() {
            return this.username;
        }

        public UserInfo getUserInfo() {
            return this.userInfo;
        }

        public ContextInfo getContext() {
            return this.context;
        }
    }
}

