/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.jitsi.server;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.jitsi.JitsiProvider;
import org.exoplatform.webconferencing.jitsi.server.JitsiGateway;

public class JitsiGateway
extends AbstractHttpServlet {
    private static final long serialVersionUID = -6075521943684342671L;
    protected static final Log LOG = ExoLogger.getLogger(JitsiGateway.class);
    private static final String EXTERNAL_AUTH_TOKEN_HEADER = "X-Exoplatform-External-Auth";
    private static final String AUTH_TOKEN_HEADER = "X-Exoplatform-Auth";
    private static final String TRANSFER_ENCODING_HEADER = "Transfer-Encoding";
    private static final String APPLICATION_JSON = "application/json";
    private static final String UTF_8 = "utf-8";

    protected void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        WebConferencingService webconferencing = (WebConferencingService)this.getContainer().getComponentInstanceOfType(WebConferencingService.class);
        JitsiProvider jitsiProvider = (JitsiProvider)webconferencing.getProvider("jitsi");
        AsyncContext ctx = httpRequest.startAsync();
        ctx.start((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void forward(String requestUrl, Action action, String secret, HttpServletRequest req, HttpServletResponse resp) {
        String authHeader;
        HttpGet request = null;
        if (req.getMethod().equals("GET")) {
            request = new HttpGet(requestUrl);
        } else {
            HttpPost post = new HttpPost(requestUrl);
            try {
                post.setEntity((HttpEntity)new InputStreamEntity((InputStream)req.getInputStream(), ContentType.parse((String)req.getContentType())));
            }
            catch (IOException e) {
                LOG.warn("Cannot set entity for post request  {} : {} ", new Object[]{requestUrl, e.getMessage()});
            }
            request = post;
        }
        if (action == Action.INTERNAL_AUTH) {
            String cookies = this.getCookiesAsString(req);
            if (cookies != null) {
                request.setHeader("Cookie", cookies);
            }
            authHeader = AUTH_TOKEN_HEADER;
        } else {
            authHeader = EXTERNAL_AUTH_TOKEN_HEADER;
        }
        String token = Jwts.builder().setSubject("exo-webconf").claim("action", (Object)action.toString().toLowerCase()).signWith((Key)Keys.hmacShaKeyFor((byte[])secret.getBytes())).compact();
        request.setHeader(authHeader, token);
        SSLContextBuilder builder = new SSLContextBuilder();
        try {
            builder.loadTrustMaterial(null, (TrustStrategy)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            LOG.warn("Cannot load trust material for SSL", new Object[]{e.getMessage()});
        }
        SSLConnectionSocketFactory sslSF = null;
        try {
            sslSF = new SSLConnectionSocketFactory(builder.build(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            LOG.warn("Cannot create SSLConnectionSockerFactory: {}", new Object[]{e.getMessage()});
        }
        try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSF).build();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            for (Header header : response.getAllHeaders()) {
                if (header.getName().equals(TRANSFER_ENCODING_HEADER)) continue;
                resp.setHeader(header.getName(), header.getValue());
                if (!header.getName().equals("Content-Type")) continue;
                resp.setContentType(header.getValue());
            }
            resp.setStatus(response.getStatusLine().getStatusCode());
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                if (resp.getContentType() != null && resp.getContentType().startsWith(APPLICATION_JSON)) {
                    resp.setCharacterEncoding(UTF_8);
                    resp.getWriter().write(EntityUtils.toString((HttpEntity)entity, (String)UTF_8));
                } else {
                    resp.getWriter().write(EntityUtils.toString((HttpEntity)entity));
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Error occured while requesting remote resource [{}]", new Object[]{requestUrl, e.getMessage()});
            try {
                if (req.getRequestURI().startsWith("/jitsi/meet/")) {
                    resp.sendRedirect("/jitsi/resources/pages/error.html");
                } else {
                    resp.sendError(403, "Cannot connect to " + requestUrl);
                }
            }
            catch (IOException ex) {
                LOG.error("Cannot write response", new Object[]{ex.getMessage()});
            }
        }
    }

    private void handleResourceRequest(String uri, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            uri = uri.substring(uri.indexOf("/resources") + 10);
            InputStream is = httpRequest.getServletContext().getResourceAsStream(uri);
            if (is != null) {
                httpResponse.setContentLength(is.available());
                this.stream(is, (OutputStream)httpResponse.getOutputStream());
            } else {
                httpResponse.sendError(404, "Resource " + uri + " is not found");
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot load local resource {}, {}", new Object[]{uri, e.getMessage()});
            try {
                httpResponse.sendError(500, "Error while loading " + uri + " resource");
            }
            catch (IOException ex) {
                LOG.warn("Cannot send error response: {}", new Object[]{e.getMessage()});
            }
        }
    }

    private String getCookiesAsString(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            StringBuilder builder = new StringBuilder();
            for (Cookie cookie : cookies) {
                builder.append(cookie.getName()).append("=").append(cookie.getValue()).append(";");
            }
            return builder.toString();
        }
        return null;
    }

    private String getPlatformUrl(HttpServletRequest req) {
        return req.getScheme() + "://" + req.getServerName() + (String)("http".equals(req.getScheme()) && req.getServerPort() == 80 || "https".equals(req.getScheme()) && req.getServerPort() == 443 ? "" : ":" + req.getServerPort());
    }

    private long stream(InputStream input, OutputStream output) throws IOException {
        try (ReadableByteChannel inputChannel = Channels.newChannel(input);){
            long l;
            block13: {
                WritableByteChannel outputChannel = Channels.newChannel(output);
                try {
                    ByteBuffer buffer = ByteBuffer.allocateDirect(10240);
                    long size = 0L;
                    while (inputChannel.read(buffer) != -1) {
                        buffer.flip();
                        size += (long)outputChannel.write(buffer);
                        buffer.clear();
                    }
                    l = size;
                    if (outputChannel == null) break block13;
                }
                catch (Throwable throwable) {
                    if (outputChannel != null) {
                        try {
                            outputChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outputChannel.close();
            }
            return l;
        }
    }
}

