/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.addon.kudos.model.GlobalSettings;
import org.exoplatform.addon.kudos.service.KudosService;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/kudos/api/settings")
@RolesAllowed(value={"administrators"})
public class KudosSettingsREST
implements ResourceContainer {
    private KudosService kudosService;

    public KudosSettingsREST(KudosService kudosService) {
        this.kudosService = kudosService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response getSettings() {
        return Response.ok((Object)this.kudosService.getGlobalSettings()).build();
    }

    @Path(value="save")
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response saveSettings(GlobalSettings settings) {
        this.kudosService.saveGlobalSettings(settings);
        return Response.ok().build();
    }
}

