/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.service;

import java.time.YearMonth;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.addon.kudos.dao.KudosDAO;
import org.exoplatform.addon.kudos.entity.KudosEntity;
import org.exoplatform.addon.kudos.model.Kudos;
import org.exoplatform.addon.kudos.model.KudosEntityType;
import org.exoplatform.addon.kudos.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class KudosStorage {
    private static final Log LOG = ExoLogger.getLogger(KudosStorage.class);
    private KudosDAO kudosDAO;
    private IdentityManager identityManager;

    public KudosStorage(KudosDAO kudosDAO, IdentityManager identityManager) {
        this.kudosDAO = kudosDAO;
        this.identityManager = identityManager;
    }

    public Kudos getKudoById(long id) {
        KudosEntity kudosEntity = (KudosEntity)this.kudosDAO.find(Long.valueOf(id));
        if (kudosEntity == null) {
            LOG.warn("Can't find Kudos with id {}", new Object[]{id});
            return null;
        }
        return Utils.fromEntity(kudosEntity);
    }

    public Kudos createKudos(Kudos kudos) {
        KudosEntity kudosEntity = Utils.toNewEntity(kudos);
        kudosEntity = (KudosEntity)this.kudosDAO.create(kudosEntity);
        return Utils.fromEntity(kudosEntity);
    }

    public List<Kudos> getAllKudosByMonth(YearMonth yearMonth) {
        ArrayList<Kudos> kudosList = new ArrayList<Kudos>();
        List<KudosEntity> kudosEntities = this.kudosDAO.getAllKudosByMonth(yearMonth);
        if (kudosEntities != null) {
            for (KudosEntity kudosEntity : kudosEntities) {
                if (kudosEntity == null) continue;
                kudosList.add(Utils.fromEntity(kudosEntity));
            }
        }
        return kudosList;
    }

    public List<Kudos> getAllKudosByMonthAndEntityType(YearMonth yearMonth, String entityType) {
        ArrayList<Kudos> kudosList = new ArrayList<Kudos>();
        List<KudosEntity> kudosEntities = this.kudosDAO.getAllKudosByMonthAndEntityType(yearMonth, KudosEntityType.valueOf(entityType).ordinal());
        if (kudosEntities != null) {
            for (KudosEntity kudosEntity : kudosEntities) {
                if (kudosEntity == null) continue;
                kudosList.add(Utils.fromEntity(kudosEntity));
            }
        }
        return kudosList;
    }

    public List<Kudos> getAllKudosByEntity(String entityType, String entityId) {
        ArrayList<Kudos> kudosList = new ArrayList<Kudos>();
        List<KudosEntity> kudosEntities = this.kudosDAO.getAllKudosByEntity(KudosEntityType.valueOf(entityType).ordinal(), Long.parseLong(entityId));
        if (kudosEntities != null) {
            for (KudosEntity kudosEntity : kudosEntities) {
                if (kudosEntity == null) continue;
                kudosList.add(Utils.fromEntity(kudosEntity));
            }
        }
        return kudosList;
    }

    public List<Kudos> getKudosByMonthAndReceiver(YearMonth yearMonth, String receiverType, String receiverId) {
        ArrayList<Kudos> kudosList = new ArrayList<Kudos>();
        boolean isReceiverUser = "user".equals(receiverType) || "organization".equals(receiverType);
        Identity identity = this.identityManager.getOrCreateIdentity(isReceiverUser ? "organization" : "space", receiverId, true);
        List<KudosEntity> kudosEntities = this.kudosDAO.getKudosByMonthAndReceiver(yearMonth, Long.parseLong(identity.getId()), isReceiverUser);
        if (kudosEntities != null) {
            for (KudosEntity kudosEntity : kudosEntities) {
                if (kudosEntity == null) continue;
                kudosList.add(Utils.fromEntity(kudosEntity));
            }
        }
        return kudosList;
    }

    public List<Kudos> getKudosByMonthAndSender(YearMonth yearMonth, String senderId) {
        ArrayList<Kudos> kudosList = new ArrayList<Kudos>();
        Identity identity = this.identityManager.getOrCreateIdentity("organization", senderId, true);
        List<KudosEntity> kudosEntities = this.kudosDAO.getKudosByMonthAndSender(yearMonth, Long.parseLong(identity.getId()));
        if (kudosEntities != null) {
            for (KudosEntity kudosEntity : kudosEntities) {
                if (kudosEntity == null) continue;
                kudosList.add(Utils.fromEntity(kudosEntity));
            }
        }
        return kudosList;
    }

    public long countKudosByMonthAndSender(YearMonth yearMonth, String senderId) {
        Identity identity = this.identityManager.getOrCreateIdentity("organization", senderId, true);
        return this.kudosDAO.countKudosByMonthAndSender(yearMonth, Long.parseLong(identity.getId()));
    }
}

