/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.model;

import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.kudos.model.KudosPeriodType;
import org.json.JSONException;
import org.json.JSONObject;

public class GlobalSettings {
    String accessPermission;
    long kudosPerPeriod;
    KudosPeriodType kudosPeriodType = KudosPeriodType.DEFAULT;

    public JSONObject toJSONObject(boolean includeTransient) {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.accessPermission != null) {
                jsonObject.put("accessPermission", (Object)this.accessPermission);
            }
            jsonObject.put("kudosPerPeriod", this.kudosPerPeriod);
            jsonObject.put("kudosPeriodType", (Object)this.kudosPeriodType.name());
            if (includeTransient) {
                jsonObject.put("startPeriodDateInSeconds", this.kudosPeriodType.getPeriodOfTime(LocalDateTime.now()).getStartDateInSeconds());
                jsonObject.put("endPeriodDateInSeconds", this.kudosPeriodType.getPeriodOfTime(LocalDateTime.now()).getEndDateInSeconds());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Error while converting Object to JSON", e);
        }
        return jsonObject;
    }

    public String toString() {
        return this.toJSONObject(true).toString();
    }

    public String toStringToPersist() {
        return this.toJSONObject(false).toString();
    }

    public static final GlobalSettings parseStringToObject(String jsonString) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            GlobalSettings globalSettings = new GlobalSettings();
            globalSettings.setAccessPermission(jsonObject.has("accessPermission") ? jsonObject.getString("accessPermission") : null);
            globalSettings.setKudosPerPeriod(jsonObject.has("kudosPerPeriod") ? jsonObject.getLong("kudosPerPeriod") : 0L);
            globalSettings.setKudosPeriodType(jsonObject.has("kudosPeriodType") ? KudosPeriodType.valueOf(jsonObject.getString("kudosPeriodType").toUpperCase()) : KudosPeriodType.DEFAULT);
            return globalSettings;
        }
        catch (JSONException e) {
            throw new RuntimeException("Error while converting JSON String to Object", e);
        }
    }

    public String getAccessPermission() {
        return this.accessPermission;
    }

    public long getKudosPerPeriod() {
        return this.kudosPerPeriod;
    }

    public KudosPeriodType getKudosPeriodType() {
        return this.kudosPeriodType;
    }

    public void setAccessPermission(String accessPermission) {
        this.accessPermission = accessPermission;
    }

    public void setKudosPerPeriod(long kudosPerPeriod) {
        this.kudosPerPeriod = kudosPerPeriod;
    }

    public void setKudosPeriodType(KudosPeriodType kudosPeriodType) {
        this.kudosPeriodType = kudosPeriodType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalSettings)) {
            return false;
        }
        GlobalSettings other = (GlobalSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$accessPermission = this.getAccessPermission();
        String other$accessPermission = other.getAccessPermission();
        if (this$accessPermission == null ? other$accessPermission != null : !this$accessPermission.equals(other$accessPermission)) {
            return false;
        }
        if (this.getKudosPerPeriod() != other.getKudosPerPeriod()) {
            return false;
        }
        KudosPeriodType this$kudosPeriodType = this.getKudosPeriodType();
        KudosPeriodType other$kudosPeriodType = other.getKudosPeriodType();
        return !(this$kudosPeriodType == null ? other$kudosPeriodType != null : !((Object)((Object)this$kudosPeriodType)).equals((Object)other$kudosPeriodType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accessPermission = this.getAccessPermission();
        result = result * 59 + ($accessPermission == null ? 43 : $accessPermission.hashCode());
        long $kudosPerPeriod = this.getKudosPerPeriod();
        result = result * 59 + (int)($kudosPerPeriod >>> 32 ^ $kudosPerPeriod);
        KudosPeriodType $kudosPeriodType = this.getKudosPeriodType();
        result = result * 59 + ($kudosPeriodType == null ? 43 : ((Object)((Object)$kudosPeriodType)).hashCode());
        return result;
    }
}

