/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.notification.builder;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.kudos.model.KudosEntityType;
import org.exoplatform.addon.kudos.service.utils.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.processor.I18NActivityProcessor;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

public class KudosActivityTemplateBuilder
extends AbstractTemplateBuilder {
    private TemplateProvider templateProvider;
    private boolean pushNotification;

    public KudosActivityTemplateBuilder(TemplateProvider templateProvider, boolean pushNotification) {
        this.templateProvider = templateProvider;
        this.pushNotification = pushNotification;
    }

    protected MessageInfo makeMessage(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        String entityType = notification.getValueOwnerParameter("ENTITY_TYPE");
        ExoSocialActivity activity = null;
        if (entityType == null || KudosEntityType.ACTIVITY == KudosEntityType.valueOf(entityType)) {
            activity = org.exoplatform.social.notification.Utils.getActivityManager().getActivity(activityId);
        } else if (KudosEntityType.COMMENT == KudosEntityType.valueOf(entityType)) {
            activity = org.exoplatform.social.notification.Utils.getActivityManager().getActivity("comment" + activityId);
        }
        if (activity == null) {
            return null;
        }
        String pluginId = notification.getKey().getId();
        String language = this.getLanguage(notification);
        TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)this.templateProvider.getChannelKey(), (String)pluginId, (String)language);
        SocialNotificationUtils.addFooterAndFirstName((String)notification.getTo(), (TemplateContext)templateContext);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(notification.getLastModifiedDate());
        templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
        templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
        templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
        Identity senderIdentity = org.exoplatform.social.notification.Utils.getIdentityManager().getOrCreateIdentity("organization", notification.getValueOwnerParameter("SENDER_ID"), true);
        String receiverType = notification.getValueOwnerParameter("RECEIVER_TYPE");
        if ("space".equals(receiverType) || "space".equals(receiverType)) {
            String receiverId = notification.getValueOwnerParameter("RECEIVER_ID");
            Space space = Utils.getSpace(receiverId);
            if (space != null) {
                templateContext.put((Object)"SPACE", (Object)space.getDisplayName());
                templateContext.put((Object)"SPACE_URL", (Object)(CommonsUtils.getCurrentDomain() + LinkProvider.getSpaceUri((String)space.getPrettyName())));
            }
            templateContext.put((Object)"IS_SPACE_RECEIVER", (Object)"true");
        } else {
            templateContext.put((Object)"IS_SPACE_RECEIVER", (Object)"false");
        }
        templateContext.put((Object)"USER", (Object)senderIdentity.getProfile().getFullName());
        templateContext.put((Object)"AVATAR", (Object)(senderIdentity.getProfile().getAvatarUrl() != null ? senderIdentity.getProfile().getAvatarUrl() : "/eXoSkin/skin/images/system/UserAvtDefault.png"));
        templateContext.put((Object)"KUDOS_ID", (Object)notification.getValueOwnerParameter("KUDOS_ID"));
        String message = notification.getValueOwnerParameter("KUDOS_MESSAGE");
        if (StringUtils.isBlank((CharSequence)message)) {
            message = "";
        }
        templateContext.put((Object)"KUDOS_MESSAGE", (Object)StringEscapeUtils.escapeHtml((String)message));
        String imagePlaceHolder = SocialNotificationUtils.getImagePlaceHolder((String)language);
        String title = SocialNotificationUtils.processImageTitle((String)activity.getTitle(), (String)imagePlaceHolder);
        templateContext.put((Object)"SUBJECT", (Object)title);
        templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)senderIdentity.getRemoteId()));
        String activityURL = null;
        activityURL = activity.isComment() && StringUtils.isNotBlank((CharSequence)activity.getParentCommentId()) ? LinkProviderUtils.getRedirectUrl((String)"view_full_activity_highlight_comment_reply", (String)(activity.getParentId() + "-" + activity.getParentCommentId() + "-" + activity.getId())) : (activity.isComment() ? LinkProviderUtils.getRedirectUrl((String)"view_full_activity_highlight_comment", (String)(activity.getParentId() + "-" + activity.getId())) : LinkProviderUtils.getRedirectUrl((String)"view_full_activity", (String)activity.getId()));
        templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)activityURL);
        MessageInfo messageInfo = new MessageInfo();
        if (this.pushNotification) {
            messageInfo.subject(activityURL);
        } else {
            messageInfo.subject(TemplateUtils.processSubject((TemplateContext)templateContext));
        }
        String body = SocialNotificationUtils.getBody((NotificationContext)ctx, (TemplateContext)templateContext, (ExoSocialActivity)activity);
        ctx.setException(templateContext.getException());
        messageInfo.body(body);
        return messageInfo.end();
    }

    protected boolean makeDigest(NotificationContext ctx, Writer writer) {
        return false;
    }

    protected ExoSocialActivity getI18N(ExoSocialActivity activity, Locale locale) {
        I18NActivityProcessor i18NActivityProcessor = (I18NActivityProcessor)PortalContainer.getInstance().getComponentInstanceOfType(I18NActivityProcessor.class);
        if (activity.getTitleId() != null) {
            activity = i18NActivityProcessor.process(activity, locale);
        }
        return activity;
    }
}

