/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.service;

import java.time.LocalDateTime;
import java.time.YearMonth;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.kudos.model.AccountSettings;
import org.exoplatform.addon.kudos.model.GlobalSettings;
import org.exoplatform.addon.kudos.model.Kudos;
import org.exoplatform.addon.kudos.service.KudosStorage;
import org.exoplatform.addon.kudos.service.utils.Utils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.picocontainer.Startable;

public class KudosService
implements Startable {
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private ListenerService listenerService;
    private KudosStorage kudosStorage;
    private SettingService settingService;
    private GlobalSettings globalSettings = new GlobalSettings();

    public KudosService(KudosStorage kudosStorage, SettingService settingService, SpaceService spaceService, IdentityManager identityManager, ListenerService listenerService, InitParams params) {
        this.kudosStorage = kudosStorage;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.settingService = settingService;
        this.listenerService = listenerService;
        if (params != null) {
            if (params.containsKey((Object)"defaultAccessPermission")) {
                String defaultAccessPermission = params.getValueParam("defaultAccessPermission").getValue();
                this.globalSettings.setAccessPermission(defaultAccessPermission);
            }
            if (params.containsKey((Object)"defaultKudosPerMonth")) {
                String defaultKudosPerMonth = params.getValueParam("defaultKudosPerMonth").getValue();
                this.globalSettings.setKudosPerMonth(Long.parseLong(defaultKudosPerMonth));
            }
        }
    }

    public void start() {
        GlobalSettings loadedGlobalSettings = this.loadGlobalSettings();
        if (loadedGlobalSettings != null) {
            this.globalSettings = loadedGlobalSettings;
        }
    }

    public void stop() {
    }

    public AccountSettings getAccountSettings(String username) {
        AccountSettings accountSettings = new AccountSettings();
        if (!this.isUserAuthorized(username)) {
            accountSettings.setDisabled(true);
            return accountSettings;
        }
        long sentKudos = this.countKudosByMonthAndSender(YearMonth.now(), Utils.getCurrentUserId());
        accountSettings.setRemainingKudos(this.globalSettings.getKudosPerMonth() - sentKudos);
        return accountSettings;
    }

    public void sendKudos(String senderId, Kudos kudos) throws Exception {
        if (!StringUtils.equals((String)senderId, (String)kudos.getSenderId())) {
            throw new IllegalAccessException("User '" + senderId + "' is not authorized to send kudos on behalf of " + kudos.getSenderId());
        }
        if (StringUtils.equals((String)senderId, (String)kudos.getReceiverId())) {
            throw new IllegalAccessException("User '" + senderId + "' is not authorized to send kudos to himseld!");
        }
        if (this.kudosStorage.countKudosByMonthAndSender(YearMonth.now(), senderId) >= this.globalSettings.getKudosPerMonth()) {
            throw new IllegalAccessException("User '" + senderId + "' is not authorized to send more kudos");
        }
        this.checkStatus("organization", senderId);
        this.checkStatus(kudos.getReceiverType(), kudos.getReceiverId());
        kudos.setTime(LocalDateTime.now());
        kudos = this.kudosStorage.createKudos(kudos);
        this.listenerService.broadcast("exo.addons.kudos.sent", (Object)this, (Object)kudos);
    }

    public List<Kudos> getAllKudosByMonth(YearMonth yearMonth) {
        return this.kudosStorage.getAllKudosByMonth(yearMonth);
    }

    public List<Kudos> getAllKudosByMonthAndEntityType(YearMonth yearMonth, String entityType) {
        return this.kudosStorage.getAllKudosByMonthAndEntityType(yearMonth, entityType);
    }

    public List<Kudos> getAllKudosByEntity(String entityType, String entityId) {
        return this.kudosStorage.getAllKudosByEntity(entityType, entityId);
    }

    public List<Kudos> getAllKudosByMonthAndSender(YearMonth yearMonth, String identityId) {
        List<Kudos> kudosBySender = this.kudosStorage.getKudosByMonthAndSender(yearMonth, identityId);
        if (kudosBySender != null) {
            Collections.sort(kudosBySender);
        }
        return kudosBySender;
    }

    public List<Kudos> getKudosByMonthAndReceiver(YearMonth yearMonth, String receiverType, String receiverId) {
        List<Kudos> kudosList = this.kudosStorage.getKudosByMonthAndReceiver(yearMonth, receiverType, receiverId);
        if (kudosList != null) {
            Collections.sort(kudosList);
        }
        return kudosList;
    }

    public long countKudosByMonthAndSender(YearMonth yearMonth, String senderId) {
        return this.kudosStorage.countKudosByMonthAndSender(yearMonth, senderId);
    }

    private void checkStatus(String type, String id) {
        if ("user".equals(type) || "organization".equals(type)) {
            Identity identity = this.identityManager.getOrCreateIdentity("organization", id, true);
            if (identity == null || !identity.isEnable() || identity.isDeleted()) {
                throw new IllegalStateException("User '" + id + "' doesn't have a valid and enabled social identity");
            }
            if (!this.isUserAuthorized(id)) {
                throw new IllegalStateException("User '" + id + "' isn't member of authorized group to send/receive kudos: " + this.globalSettings.getAccessPermission());
            }
        } else {
            Space space = Utils.getSpace(id);
            if (space == null) {
                throw new IllegalStateException("Space '" + id + "' wasn't found, thus it can't receive/send kudos");
            }
        }
    }

    private boolean isUserAuthorized(String username) {
        if (StringUtils.isBlank((String)username)) {
            return false;
        }
        if (this.globalSettings == null || StringUtils.isBlank((String)this.globalSettings.getAccessPermission())) {
            return true;
        }
        Space space = Utils.getSpace(this.globalSettings.getAccessPermission());
        return this.spaceService.isSuperManager(username) || space != null && this.spaceService.isMember(space, username);
    }

    public GlobalSettings getGlobalSettings() {
        if (this.globalSettings == null) {
            this.globalSettings = this.loadGlobalSettings();
        }
        return this.globalSettings;
    }

    public void saveGlobalSettings(GlobalSettings settings) {
        this.settingService.set(Utils.KUDOS_CONTEXT, Utils.KUDOS_SCOPE, "ADDONS_KUDOS_SETTINGS", SettingValue.create((String)settings.toString()));
        this.globalSettings = null;
    }

    private GlobalSettings loadGlobalSettings() {
        SettingValue globalSettingsValue = this.settingService.get(Utils.KUDOS_CONTEXT, Utils.KUDOS_SCOPE, "ADDONS_KUDOS_SETTINGS");
        if (globalSettingsValue == null || StringUtils.isBlank((String)globalSettingsValue.getValue().toString())) {
            return null;
        }
        return GlobalSettings.parseStringToObject(globalSettingsValue.getValue().toString());
    }
}

