// Generated by delombok at Mon Dec 03 11:06:27 UTC 2018
package org.exoplatform.addon.kudos.model;

import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class GlobalSettings {
  String accessPermission;
  long kudosPerPeriod;
  KudosPeriodType kudosPeriodType = KudosPeriodType.DEFAULT;

  public JSONObject toJSONObject(boolean includeTransient) {
    JSONObject jsonObject = new JSONObject();
    try {
      if (accessPermission != null) {
        jsonObject.put("accessPermission", accessPermission);
      }
      jsonObject.put("kudosPerPeriod", kudosPerPeriod);
      jsonObject.put("kudosPeriodType", kudosPeriodType.name());
      if (includeTransient) {
        jsonObject.put("startPeriodDateInSeconds", kudosPeriodType.getPeriodOfTime(LocalDateTime.now()).getStartDateInSeconds());
        jsonObject.put("endPeriodDateInSeconds", kudosPeriodType.getPeriodOfTime(LocalDateTime.now()).getEndDateInSeconds());
      }
    } catch (JSONException e) {
      throw new RuntimeException("Error while converting Object to JSON", e);
    }
    return jsonObject;
  }

  @Override
  public String toString() {
    return toJSONObject(true).toString();
  }

  public String toStringToPersist() {
    return toJSONObject(false).toString();
  }

  public static final GlobalSettings parseStringToObject(String jsonString) {
    if (StringUtils.isBlank(jsonString)) {
      return null;
    }
    try {
      JSONObject jsonObject = new JSONObject(jsonString);
      GlobalSettings globalSettings = new GlobalSettings();
      globalSettings.setAccessPermission(jsonObject.has("accessPermission") ? jsonObject.getString("accessPermission") : null);
      globalSettings.setKudosPerPeriod(jsonObject.has("kudosPerPeriod") ? jsonObject.getLong("kudosPerPeriod") : 0);
      globalSettings.setKudosPeriodType(jsonObject.has("kudosPeriodType") ? KudosPeriodType.valueOf(jsonObject.getString("kudosPeriodType").toUpperCase()) : KudosPeriodType.DEFAULT);
      return globalSettings;
    } catch (JSONException e) {
      throw new RuntimeException("Error while converting JSON String to Object", e);
    }
  }

  @java.lang.SuppressWarnings("all")
  public GlobalSettings() {
  }

  @java.lang.SuppressWarnings("all")
  public String getAccessPermission() {
    return this.accessPermission;
  }

  @java.lang.SuppressWarnings("all")
  public long getKudosPerPeriod() {
    return this.kudosPerPeriod;
  }

  @java.lang.SuppressWarnings("all")
  public KudosPeriodType getKudosPeriodType() {
    return this.kudosPeriodType;
  }

  @java.lang.SuppressWarnings("all")
  public void setAccessPermission(final String accessPermission) {
    this.accessPermission = accessPermission;
  }

  @java.lang.SuppressWarnings("all")
  public void setKudosPerPeriod(final long kudosPerPeriod) {
    this.kudosPerPeriod = kudosPerPeriod;
  }

  @java.lang.SuppressWarnings("all")
  public void setKudosPeriodType(final KudosPeriodType kudosPeriodType) {
    this.kudosPeriodType = kudosPeriodType;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof GlobalSettings)) return false;
    final GlobalSettings other = (GlobalSettings) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$accessPermission = this.getAccessPermission();
    final java.lang.Object other$accessPermission = other.getAccessPermission();
    if (this$accessPermission == null ? other$accessPermission != null : !this$accessPermission.equals(other$accessPermission)) return false;
    if (this.getKudosPerPeriod() != other.getKudosPerPeriod()) return false;
    final java.lang.Object this$kudosPeriodType = this.getKudosPeriodType();
    final java.lang.Object other$kudosPeriodType = other.getKudosPeriodType();
    if (this$kudosPeriodType == null ? other$kudosPeriodType != null : !this$kudosPeriodType.equals(other$kudosPeriodType)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof GlobalSettings;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $accessPermission = this.getAccessPermission();
    result = result * PRIME + ($accessPermission == null ? 43 : $accessPermission.hashCode());
    final long $kudosPerPeriod = this.getKudosPerPeriod();
    result = result * PRIME + (int) ($kudosPerPeriod >>> 32 ^ $kudosPerPeriod);
    final java.lang.Object $kudosPeriodType = this.getKudosPeriodType();
    result = result * PRIME + ($kudosPeriodType == null ? 43 : $kudosPeriodType.hashCode());
    return result;
  }
}
