/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.exoplatform.addon.kudos.entity.KudosEntity;
import org.exoplatform.addon.kudos.model.KudosPeriod;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class KudosDAO
extends GenericDAOJPAImpl<KudosEntity, Long> {
    public void deleteAll() {
        throw new IllegalStateException("Kudos removal is disabled");
    }

    public void delete(KudosEntity entity) {
        throw new IllegalStateException("Kudos removal is disabled");
    }

    public void deleteAll(List<KudosEntity> entities) {
        throw new IllegalStateException("Kudos removal is disabled");
    }

    public List<KudosEntity> getAllKudosByPeriod(KudosPeriod kudosPeriod) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.getAllKudosByPeriod", KudosEntity.class);
        this.setPeriodParameters(query, kudosPeriod);
        return query.getResultList();
    }

    public List<KudosEntity> getAllKudosByPeriodAndEntityType(KudosPeriod kudosPeriod, int entityType) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.getAllKudosByPeriodAndEntityType", KudosEntity.class);
        this.setPeriodParameters(query, kudosPeriod);
        query.setParameter("entityType", (Object)entityType);
        return query.getResultList();
    }

    public List<KudosEntity> getAllKudosByEntity(int entityType, long entityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.getAllKudosByEntity", KudosEntity.class);
        query.setParameter("entityId", (Object)entityId);
        query.setParameter("entityType", (Object)entityType);
        return query.getResultList();
    }

    public List<KudosEntity> getKudosByPeriodAndReceiver(KudosPeriod kudosPeriod, long receiverId, boolean isReceiverUser) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.getKudosByPeriodAndReceiver", KudosEntity.class);
        this.setPeriodParameters(query, kudosPeriod);
        query.setParameter("receiverId", (Object)receiverId);
        query.setParameter("isReceiverUser", (Object)isReceiverUser);
        return query.getResultList();
    }

    public List<KudosEntity> getKudosByPeriodAndSender(KudosPeriod kudosPeriod, long senderId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.getKudosByPeriodAndSender", KudosEntity.class);
        this.setPeriodParameters(query, kudosPeriod);
        query.setParameter("senderId", (Object)senderId);
        return query.getResultList();
    }

    public long countKudosByPeriodAndSender(KudosPeriod kudosPeriod, long senderId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.countKudosByPeriodAndSender", Long.class);
        this.setPeriodParameters(query, kudosPeriod);
        query.setParameter("senderId", (Object)senderId);
        return (Long)query.getSingleResult();
    }

    private void setPeriodParameters(TypedQuery<?> query, KudosPeriod kudosPeriod) {
        query.setParameter("startDate", (Object)kudosPeriod.getStartDateInSeconds());
        query.setParameter("endDate", (Object)kudosPeriod.getEndDateInSeconds());
    }
}

