/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.notification.plugin;

import java.util.List;
import org.exoplatform.addon.kudos.model.Kudos;
import org.exoplatform.addon.kudos.service.utils.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class KudosReceiverNotificationPlugin
extends BaseNotificationPlugin {
    public KudosReceiverNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return "KudosActivityReceiverNotificationPlugin";
    }

    public boolean isValid(NotificationContext ctx) {
        Kudos kudos = (Kudos)ctx.value(Utils.KUDOS_DETAILS_PARAMETER);
        return kudos != null && kudos.getEntityType() != null;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        Kudos kudos = (Kudos)ctx.value(Utils.KUDOS_DETAILS_PARAMETER);
        String senderId = kudos.getSenderId();
        String receiverId = kudos.getReceiverId();
        String receiverType = kudos.getReceiverType();
        List<String> toList = Utils.getNotificationReceiversUsers(receiverType, receiverId, senderId);
        if (toList == null || toList.isEmpty()) {
            return null;
        }
        return NotificationInfo.instance().to(toList).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), String.valueOf(kudos.getActivityId())).with("ENTITY_ID", kudos.getEntityId()).with("ENTITY_TYPE", kudos.getEntityType()).with("SENDER_ID", senderId).with("RECEIVER_ID", receiverId).with("RECEIVER_TYPE", receiverType).with("KUDOS_ID", String.valueOf(kudos.getTechnicalId())).with("KUDOS_MESSAGE", kudos.getMessage() == null ? "" : kudos.getMessage()).key(this.getId()).end();
    }
}

