/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.kudos.entity.KudosEntity;
import org.exoplatform.kudos.model.KudosPeriod;

public class KudosDAO
extends GenericDAOJPAImpl<KudosEntity, Long> {
    public List<KudosEntity> getKudosByPeriod(KudosPeriod kudosPeriod, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.getKudosByPeriod", KudosEntity.class);
        this.setPeriodParameters(query, kudosPeriod);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public List<KudosEntity> getKudosByPeriodAndEntityType(KudosPeriod kudosPeriod, int entityType, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.getKudosByPeriodAndEntityType", KudosEntity.class);
        this.setPeriodParameters(query, kudosPeriod);
        query.setParameter("entityType", (Object)entityType);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public List<KudosEntity> getKudosByEntity(int entityType, long entityId, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.getKudosByEntity", KudosEntity.class);
        query.setParameter("entityId", (Object)entityId);
        query.setParameter("entityType", (Object)entityType);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public List<KudosEntity> getKudosByPeriodAndReceiver(KudosPeriod kudosPeriod, long receiverId, boolean isReceiverUser, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.getKudosByPeriodAndReceiver", KudosEntity.class);
        this.setPeriodParameters(query, kudosPeriod);
        query.setParameter("receiverId", (Object)receiverId);
        query.setParameter("isReceiverUser", (Object)isReceiverUser);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public long countKudosByEntity(int entityType, long entityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.countKudosByEntity", Long.class);
        query.setParameter("entityId", (Object)entityId);
        query.setParameter("entityType", (Object)entityType);
        Long count = (Long)query.getSingleResult();
        return count == null ? 0L : count;
    }

    public long countKudosByPeriodAndReceiver(KudosPeriod kudosPeriod, long receiverId, boolean isReceiverUser) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.countKudosByPeriodAndReceiver", Long.class);
        this.setPeriodParameters(query, kudosPeriod);
        query.setParameter("receiverId", (Object)receiverId);
        query.setParameter("isReceiverUser", (Object)isReceiverUser);
        Long count = (Long)query.getSingleResult();
        return count == null ? 0L : count;
    }

    public List<KudosEntity> getKudosByPeriodAndSender(KudosPeriod kudosPeriod, long senderId, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.getKudosByPeriodAndSender", KudosEntity.class);
        this.setPeriodParameters(query, kudosPeriod);
        query.setParameter("senderId", (Object)senderId);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public long countKudosByPeriodAndSender(KudosPeriod kudosPeriod, long senderId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Kudos.countKudosByPeriodAndSender", Long.class);
        this.setPeriodParameters(query, kudosPeriod);
        query.setParameter("senderId", (Object)senderId);
        return (Long)query.getSingleResult();
    }

    private void setPeriodParameters(TypedQuery<?> query, KudosPeriod kudosPeriod) {
        query.setParameter("startDate", (Object)kudosPeriod.getStartDateInSeconds());
        query.setParameter("endDate", (Object)kudosPeriod.getEndDateInSeconds());
    }
}

