/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.notification.builder;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.common.xmlprocessor.XMLProcessor;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.processor.I18NActivityProcessor;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.utils.MentionUtils;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

public class KudosTemplateBuilder
extends AbstractTemplateBuilder {
    private static final String ACTIVITY_PARAM = "ACTIVITY";
    private TemplateProvider templateProvider;
    private boolean pushNotification;
    private XMLProcessor xmlProcessor;

    public KudosTemplateBuilder(TemplateProvider templateProvider, boolean pushNotification, XMLProcessor xmlProcessor) {
        this.templateProvider = templateProvider;
        this.pushNotification = pushNotification;
        this.xmlProcessor = xmlProcessor;
    }

    protected MessageInfo makeMessage(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        ExoSocialActivity activity = null;
        if (StringUtils.isNotBlank((CharSequence)activityId) && !StringUtils.equals((CharSequence)activityId, (CharSequence)"0") && (activity = Utils.getActivityManager().getActivity("comment" + activityId)) == null) {
            activity = Utils.getActivityManager().getActivity(activityId);
        }
        String pluginId = notification.getKey().getId();
        String language = this.getLanguage(notification);
        TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)this.templateProvider.getChannelKey(), (String)pluginId, (String)language);
        SocialNotificationUtils.addFooterAndFirstName((String)notification.getTo(), (TemplateContext)templateContext);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(notification.getLastModifiedDate());
        templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
        templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)Locale.of(language), (int)TimeConvertUtils.YEAR));
        Identity senderIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", notification.getValueOwnerParameter("SENDER_ID"));
        String receiverType = notification.getValueOwnerParameter("RECEIVER_TYPE");
        if ("space".equals(receiverType)) {
            String receiverId = notification.getValueOwnerParameter("RECEIVER_ID");
            Space space = org.exoplatform.kudos.service.utils.Utils.getSpace(receiverId);
            if (space != null) {
                templateContext.put((Object)"SPACE", (Object)space.getDisplayName());
                templateContext.put((Object)"SPACE_URL", (Object)(CommonsUtils.getCurrentDomain() + LinkProvider.getSpaceUri((String)space.getPrettyName())));
            }
            templateContext.put((Object)"IS_SPACE_RECEIVER", (Object)"true");
        } else {
            templateContext.put((Object)"IS_SPACE_RECEIVER", (Object)"false");
        }
        templateContext.put((Object)"USER", (Object)senderIdentity.getProfile().getFullName());
        templateContext.put((Object)"AVATAR", (Object)(senderIdentity.getProfile().getAvatarUrl() != null ? senderIdentity.getProfile().getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultUserAvatar.png"));
        templateContext.put((Object)"KUDOS_ID", (Object)notification.getValueOwnerParameter("KUDOS_ID"));
        String message = notification.getValueOwnerParameter("KUDOS_MESSAGE");
        message = (String)this.xmlProcessor.process((Object)message);
        if (StringUtils.isBlank((CharSequence)message)) {
            message = "";
        }
        templateContext.put((Object)"KUDOS_MESSAGE", (Object)message);
        Object title = "";
        String notificationURL = CommonsUtils.getCurrentDomain();
        String imagePlaceHolder = SocialNotificationUtils.getImagePlaceHolder((String)language);
        if (activity != null) {
            title = " : " + SocialNotificationUtils.processImageTitle((String)activity.getTitle(), (String)imagePlaceHolder);
            notificationURL = activity.isComment() && StringUtils.isNotBlank((CharSequence)activity.getParentCommentId()) ? LinkProviderUtils.getRedirectUrl((String)"view_full_activity_highlight_comment_reply", (String)(activity.getParentId() + "-" + activity.getParentCommentId() + "-" + activity.getId())) : (activity.isComment() ? LinkProviderUtils.getRedirectUrl((String)"view_full_activity_highlight_comment", (String)(activity.getParentId() + "-" + activity.getId())) : LinkProviderUtils.getRedirectUrl((String)"view_full_activity", (String)activity.getId()));
        }
        templateContext.put((Object)"SUBJECT", title);
        templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)senderIdentity.getRemoteId()));
        templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)notificationURL);
        MessageInfo messageInfo = new MessageInfo();
        if (this.pushNotification) {
            messageInfo.subject(notificationURL);
        } else {
            messageInfo.subject(TemplateUtils.processSubject((TemplateContext)templateContext));
        }
        if (activity != null) {
            if (StringUtils.isNotBlank((CharSequence)activity.getParentCommentId())) {
                String parentCommentTitle = this.getActivityTitle(activity.getParentCommentId(), language);
                templateContext.put((Object)ACTIVITY_PARAM, (Object)parentCommentTitle);
            } else if (StringUtils.isNotBlank((CharSequence)activity.getParentId())) {
                String parentActivityTitle = this.getActivityTitle(activity.getParentId(), language);
                templateContext.put((Object)ACTIVITY_PARAM, (Object)parentActivityTitle);
            } else {
                templateContext.put((Object)ACTIVITY_PARAM, (Object)"");
            }
            messageInfo.body(TemplateUtils.processGroovy((TemplateContext)templateContext));
        } else {
            templateContext.put((Object)ACTIVITY_PARAM, (Object)"");
            messageInfo.body(TemplateUtils.processGroovy((TemplateContext)templateContext));
        }
        ctx.setException(templateContext.getException());
        return messageInfo.end();
    }

    protected boolean makeDigest(NotificationContext ctx, Writer writer) {
        return false;
    }

    protected ExoSocialActivity getI18N(ExoSocialActivity activity, Locale locale) {
        I18NActivityProcessor i18NActivityProcessor = (I18NActivityProcessor)PortalContainer.getInstance().getComponentInstanceOfType(I18NActivityProcessor.class);
        if (activity.getTitleId() != null) {
            activity = i18NActivityProcessor.process(activity, locale);
        }
        return activity;
    }

    private String getActivityTitle(String activityId, String language) {
        return MentionUtils.substituteRoleWithLocale((String)Utils.getActivityManager().getActivityTitle(activityId), (Locale)Locale.forLanguageTag(language));
    }
}

