/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.statistic;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.exoplatform.addon.kudos.statistic.ExoKudosStatistic;
import org.exoplatform.addon.kudos.statistic.ExoKudosStatisticService;
import org.exoplatform.addon.kudos.statistic.StatisticUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Aspect
public class ExoKudosStatisticAspect {
    private static final Log LOG = ExoLogger.getLogger(ExoKudosStatisticAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ ExoKudosStatisticAspect ajc$perSingletonInstance;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Around(value="execution(* *(..)) && @annotation(org.exoplatform.addon.kudos.statistic.ExoKudosStatistic)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object object;
        ExoKudosStatisticService statisticService = (ExoKudosStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoKudosStatistic annotation = method.getAnnotation(ExoKudosStatistic.class);
        boolean local = annotation.local();
        String service = annotation.service();
        String operation = annotation.operation();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        Object result = null;
        try {
            object = result = point.proceed();
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map<String, Object> parameters = statisticService.getStatisticParameters(operation, result, point.getArgs());
                    if (parameters == null) throw throwable;
                    if (local) {
                        parameters.put("local_service", service);
                    } else {
                        parameters.put("remote_service", service);
                    }
                    if (!parameters.containsKey("operation")) {
                        parameters.put("operation", operation);
                    }
                    if (!parameters.containsKey("duration_ms")) {
                        parameters.put("duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            parameters.put("error_msg", errorMessage);
                        }
                        parameters.put("status", "ko");
                        parameters.put("status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            parameters.put("status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            parameters.put("status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry(parameters);
                    throw throwable;
                }
                catch (Throwable e2) {
                    ExoKudosStatisticAspect.LOG.warn("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), operation, e2});
                }
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map<String, Object> parameters = statisticService.getStatisticParameters(operation, result, point.getArgs());
            if (parameters == null) return object;
            if (local) {
                parameters.put("local_service", service);
            } else {
                parameters.put("remote_service", service);
            }
            if (!parameters.containsKey("operation")) {
                parameters.put("operation", operation);
            }
            if (!parameters.containsKey("duration_ms")) {
                parameters.put("duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    parameters.put("error_msg", errorMessage);
                }
                parameters.put("status", "ko");
                parameters.put("status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    parameters.put("status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    parameters.put("status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry(parameters);
            return object;
        }
        catch (Throwable e) {
            ExoKudosStatisticAspect.LOG.warn("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), operation, e});
        }
        return object;
    }

    static {
        try {
            ExoKudosStatisticAspect.ajc$perSingletonInstance = new ExoKudosStatisticAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static ExoKudosStatisticAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.exoplatform.addon.kudos.statistic.ExoKudosStatisticAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

