/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.kudos.model.AccountSettings;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.kudos.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/kudos/api/account")
@Api(value="/kudos/api/account", description="Retrieve Kudos settings for users and spaces")
@RolesAllowed(value={"users"})
public class KudosAccountREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(KudosAccountREST.class);
    private KudosService kudosService;

    public KudosAccountREST(KudosService kudosService) {
        this.kudosService = kudosService;
    }

    @Path(value="settings")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves user/space settings for kudos", httpMethod="GET", response=Response.class, produces="application/json", notes="returns account settings object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSettings() {
        try {
            AccountSettings accountDetail = this.kudosService.getAccountSettings(Utils.getCurrentUserId());
            if (accountDetail == null) {
                accountDetail = new AccountSettings();
            }
            return Response.ok((Object)accountDetail).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting kudos settings", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Path(value="isAuthorized")
    @GET
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Checks if username is authorized to use Kudos", httpMethod="GET", response=Response.class, notes="returns empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response isAuthorized(@ApiParam(value="User login", required=true) @QueryParam(value="username") String username) {
        if (StringUtils.isBlank((String)username)) {
            LOG.warn((Object)"Bad request sent to server with empty 'username'");
            return Response.status((int)400).build();
        }
        try {
            if (this.kudosService.isAuthorized(username)) {
                return Response.ok().build();
            }
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            LOG.warn("Error getting kudos authorization for user {}", new Object[]{username, e});
            return Response.serverError().build();
        }
    }
}

