// Generated by delombok at Mon Oct 10 16:30:10 UTC 2022
package org.exoplatform.kudos.model;

import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import lombok.*;

public class GlobalSettings implements Cloneable {
  private static final String END_PERIOD_DATE_IN_SECONDS_PARAM = "endPeriodDateInSeconds";
  private static final String START_PERIOD_DATE_IN_SECONDS_PARAM = "startPeriodDateInSeconds";
  private static final String KUDOS_PERIOD_TYPE_PARAM = "kudosPeriodType";
  private static final String KUDOS_PER_PERIOD_PARAM = "kudosPerPeriod";
  private static final String ACCESS_PERMISSION_PARAM = "accessPermission";
  String accessPermission;
  long kudosPerPeriod;
  KudosPeriodType kudosPeriodType = KudosPeriodType.DEFAULT;

  public JSONObject toJSONObject(boolean includeTransient) {
    JSONObject jsonObject = new JSONObject();
    try {
      if (accessPermission != null) {
        jsonObject.put(ACCESS_PERMISSION_PARAM, accessPermission);
      }
      jsonObject.put(KUDOS_PER_PERIOD_PARAM, kudosPerPeriod);
      jsonObject.put(KUDOS_PERIOD_TYPE_PARAM, kudosPeriodType.name());
      if (includeTransient) {
        jsonObject.put(START_PERIOD_DATE_IN_SECONDS_PARAM, kudosPeriodType.getPeriodOfTime(LocalDateTime.now()).getStartDateInSeconds());
        jsonObject.put(END_PERIOD_DATE_IN_SECONDS_PARAM, kudosPeriodType.getPeriodOfTime(LocalDateTime.now()).getEndDateInSeconds());
      }
    } catch (JSONException e) {
      throw new IllegalStateException("Error while converting Object to JSON", e);
    }
    return jsonObject;
  }

  @Override
  public String toString() {
    return toJSONObject(true).toString();
  }

  public String toStringToPersist() {
    return toJSONObject(false).toString();
  }

  public static final GlobalSettings parseStringToObject(String jsonString) {
    if (StringUtils.isBlank(jsonString)) {
      return null;
    }
    try {
      JSONObject jsonObject = new JSONObject(jsonString);
      GlobalSettings globalSettings = new GlobalSettings();
      globalSettings.setAccessPermission(jsonObject.has(ACCESS_PERMISSION_PARAM) ? jsonObject.getString(ACCESS_PERMISSION_PARAM) : null);
      globalSettings.setKudosPerPeriod(jsonObject.has(KUDOS_PER_PERIOD_PARAM) ? jsonObject.getLong(KUDOS_PER_PERIOD_PARAM) : 0);
      globalSettings.setKudosPeriodType(jsonObject.has(KUDOS_PERIOD_TYPE_PARAM) ? KudosPeriodType.valueOf(jsonObject.getString(KUDOS_PERIOD_TYPE_PARAM).toUpperCase()) : KudosPeriodType.DEFAULT);
      return globalSettings;
    } catch (JSONException e) {
      throw new IllegalStateException("Error while converting JSON String to Object", e);
    }
  }

  @Override
  public GlobalSettings clone() {
    // NOSONAR
    try {
      return (GlobalSettings) super.clone();
    } catch (CloneNotSupportedException e) {
      return new GlobalSettings(accessPermission, kudosPerPeriod, kudosPeriodType);
    }
  }

  @java.lang.SuppressWarnings("all")
  public String getAccessPermission() {
    return this.accessPermission;
  }

  @java.lang.SuppressWarnings("all")
  public long getKudosPerPeriod() {
    return this.kudosPerPeriod;
  }

  @java.lang.SuppressWarnings("all")
  public KudosPeriodType getKudosPeriodType() {
    return this.kudosPeriodType;
  }

  @java.lang.SuppressWarnings("all")
  public void setAccessPermission(final String accessPermission) {
    this.accessPermission = accessPermission;
  }

  @java.lang.SuppressWarnings("all")
  public void setKudosPerPeriod(final long kudosPerPeriod) {
    this.kudosPerPeriod = kudosPerPeriod;
  }

  @java.lang.SuppressWarnings("all")
  public void setKudosPeriodType(final KudosPeriodType kudosPeriodType) {
    this.kudosPeriodType = kudosPeriodType;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof GlobalSettings)) return false;
    final GlobalSettings other = (GlobalSettings) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$accessPermission = this.getAccessPermission();
    final java.lang.Object other$accessPermission = other.getAccessPermission();
    if (this$accessPermission == null ? other$accessPermission != null : !this$accessPermission.equals(other$accessPermission)) return false;
    if (this.getKudosPerPeriod() != other.getKudosPerPeriod()) return false;
    final java.lang.Object this$kudosPeriodType = this.getKudosPeriodType();
    final java.lang.Object other$kudosPeriodType = other.getKudosPeriodType();
    if (this$kudosPeriodType == null ? other$kudosPeriodType != null : !this$kudosPeriodType.equals(other$kudosPeriodType)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof GlobalSettings;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $accessPermission = this.getAccessPermission();
    result = result * PRIME + ($accessPermission == null ? 43 : $accessPermission.hashCode());
    final long $kudosPerPeriod = this.getKudosPerPeriod();
    result = result * PRIME + (int) ($kudosPerPeriod >>> 32 ^ $kudosPerPeriod);
    final java.lang.Object $kudosPeriodType = this.getKudosPeriodType();
    result = result * PRIME + ($kudosPeriodType == null ? 43 : $kudosPeriodType.hashCode());
    return result;
  }

  @java.lang.SuppressWarnings("all")
  public GlobalSettings() {
  }

  @java.lang.SuppressWarnings("all")
  public GlobalSettings(final String accessPermission, final long kudosPerPeriod, final KudosPeriodType kudosPeriodType) {
    this.accessPermission = accessPermission;
    this.kudosPerPeriod = kudosPerPeriod;
    this.kudosPeriodType = kudosPeriodType;
  }
}
