/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.test;

import java.time.LocalDate;
import java.time.ZoneId;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.kudos.dao.KudosDAO;
import org.exoplatform.kudos.entity.KudosEntity;
import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.model.KudosEntityType;
import org.exoplatform.kudos.service.utils.Utils;
import org.junit.After;
import org.junit.Before;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/kudos-test-configuration.xml")})
public abstract class BaseKudosTest
extends AbstractKernelTest {
    protected static final String DEFAULT_PORTAL = "meeds";
    protected KudosEntityType kudosEntityType = KudosEntityType.USER_TIPTIP;
    protected int entityType = this.kudosEntityType.ordinal();
    protected long entityId = 1L;
    protected long parentEntityId = 2L;
    protected long receiverId = 3L;
    protected long senderId = 4L;
    protected long createdTimestamp = System.currentTimeMillis() / 1000L;
    protected String message = "message";
    protected PortalContainer container;

    @Before
    public void setUp() throws Exception {
        this.container = this.getContainer();
        BaseKudosTest.assertNotNull((String)"Container shouldn't be null", (Object)this.container);
        BaseKudosTest.assertTrue((String)"Container should have been started", (boolean)this.container.isStarted());
        this.begin();
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        KudosDAO kudosDAO = this.getService(KudosDAO.class);
        this.restartTransaction();
        kudosDAO.deleteAll();
        int kudosCount = kudosDAO.findAll().size();
        BaseKudosTest.assertEquals((String)"The previous test didn't cleaned kudos entities correctly, should add entities to clean into 'entitiesToClean' list.", (int)0, (int)kudosCount);
        this.end();
        super.tearDown();
    }

    protected <T> T getService(Class<T> componentType) {
        return (T)this.container.getComponentInstanceOfType(componentType);
    }

    protected Kudos newKudosDTO() {
        KudosEntity entity = this.newKudosInstance(this.parentEntityId, this.entityId, this.entityType, this.receiverId, this.senderId, this.createdTimestamp, this.message);
        return Utils.fromEntity((KudosEntity)entity);
    }

    protected KudosEntity newKudos() {
        return this.newKudos(this.parentEntityId, this.entityId, this.entityType, this.receiverId, this.senderId, this.createdTimestamp, this.message);
    }

    protected KudosEntity newKudosInstance() {
        return this.newKudosInstance(this.parentEntityId, this.entityId, this.entityType, this.receiverId, this.senderId, this.createdTimestamp, this.message);
    }

    protected KudosEntity newKudos(long parentEntityId, long entityId, int entityType, long receiverId, long senderId, long createdTimestamp, String message) {
        KudosDAO kudosDAO = this.getService(KudosDAO.class);
        KudosEntity kudosEntity = this.newKudosInstance(parentEntityId, entityId, entityType, receiverId, senderId, createdTimestamp, message);
        return (KudosEntity)kudosDAO.create((Object)kudosEntity);
    }

    private KudosEntity newKudosInstance(long parentEntityId, long entityId, int entityType, long receiverId, long senderId, long createdTimestamp, String message) {
        KudosEntity kudosEntity = new KudosEntity();
        kudosEntity.setEntityId(entityId);
        kudosEntity.setEntityType(entityType);
        kudosEntity.setMessage(message);
        kudosEntity.setParentEntityId(Long.valueOf(parentEntityId));
        kudosEntity.setReceiverId(receiverId);
        kudosEntity.setReceiverUser(true);
        kudosEntity.setSenderId(senderId);
        kudosEntity.setCreatedDate(createdTimestamp);
        return kudosEntity;
    }

    protected void compareResults(KudosEntity kudosEntity, Kudos kudos) {
        BaseKudosTest.assertEquals((long)kudosEntity.getActivityId(), (long)kudos.getActivityId());
        BaseKudosTest.assertEquals((long)kudosEntity.getCreatedDate(), (long)kudos.getTimeInSeconds());
        BaseKudosTest.assertEquals((String)String.valueOf(kudosEntity.getEntityId()), (String)kudos.getEntityId());
        BaseKudosTest.assertEquals((int)kudosEntity.getEntityType(), (int)KudosEntityType.valueOf((String)kudos.getEntityType()).ordinal());
        BaseKudosTest.assertEquals((Object)kudosEntity.getId(), (Object)kudos.getTechnicalId());
        BaseKudosTest.assertEquals((String)kudosEntity.getMessage(), (String)kudos.getMessage());
        BaseKudosTest.assertEquals((String)String.valueOf(kudosEntity.getParentEntityId()), (String)kudos.getParentEntityId());
        BaseKudosTest.assertEquals((String)String.valueOf(kudosEntity.getReceiverId()), (String)kudos.getReceiverIdentityId());
        BaseKudosTest.assertEquals((String)String.valueOf(kudosEntity.getSenderId()), (String)kudos.getSenderIdentityId());
    }

    protected long getTime(int year, int month, int day) {
        return LocalDate.of(year, month, day).atStartOfDay(ZoneId.systemDefault()).toEpochSecond();
    }

    protected long getCurrentTimeInSeconds() {
        return System.currentTimeMillis() / 1000L + 10L;
    }
}

