/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.test;

import java.time.LocalDate;
import java.time.ZoneId;
import org.exoplatform.kudos.model.KudosPeriod;
import org.exoplatform.kudos.model.KudosPeriodType;
import org.exoplatform.kudos.test.BaseKudosTest;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Test;

public class KudosPeriodTypeTest
extends BaseKudosTest {
    @Test
    public void testGetWeekPeriod() {
        KudosPeriod periodOfTime = KudosPeriodType.WEEK.getPeriodOfTime(LocalDate.of(2019, 7, 12).atStartOfDay());
        KudosPeriodTypeTest.assertNotNull((Object)periodOfTime);
        long startTimeInSeconds = LocalDate.of(2019, 7, 8).atStartOfDay().atZone(ZoneId.systemDefault()).toEpochSecond();
        long endTimeInSeconds = LocalDate.of(2019, 7, 15).atStartOfDay().atZone(ZoneId.systemDefault()).toEpochSecond();
        KudosPeriod expectedPeriod = new KudosPeriod(startTimeInSeconds, endTimeInSeconds);
        KudosPeriodTypeTest.assertEquals((Object)expectedPeriod, (Object)periodOfTime);
        KudosPeriodTypeTest.assertEquals((long)startTimeInSeconds, (long)periodOfTime.getStartDateInSeconds());
        KudosPeriodTypeTest.assertEquals((long)endTimeInSeconds, (long)periodOfTime.getEndDateInSeconds());
    }

    @Test
    public void testGetMonthPeriod() {
        KudosPeriod periodOfTime = KudosPeriodType.MONTH.getPeriodOfTime(LocalDate.of(2019, 7, 12).atStartOfDay());
        KudosPeriodTypeTest.assertNotNull((Object)periodOfTime);
        long startTimeInSeconds = LocalDate.of(2019, 7, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toEpochSecond();
        long endTimeInSeconds = LocalDate.of(2019, 8, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toEpochSecond();
        KudosPeriod expectedPeriod = new KudosPeriod(startTimeInSeconds, endTimeInSeconds);
        KudosPeriodTypeTest.assertEquals((Object)expectedPeriod, (Object)periodOfTime);
        KudosPeriodTypeTest.assertEquals((long)startTimeInSeconds, (long)periodOfTime.getStartDateInSeconds());
        KudosPeriodTypeTest.assertEquals((long)endTimeInSeconds, (long)periodOfTime.getEndDateInSeconds());
    }

    @Test
    public void testGetQuarterPeriod() {
        KudosPeriod periodOfTime = KudosPeriodType.QUARTER.getPeriodOfTime(LocalDate.of(2019, 7, 12).atStartOfDay());
        KudosPeriodTypeTest.assertNotNull((Object)periodOfTime);
        long startTimeInSeconds = LocalDate.of(2019, 7, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toEpochSecond();
        long endTimeInSeconds = LocalDate.of(2019, 10, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toEpochSecond();
        KudosPeriod expectedPeriod = new KudosPeriod(startTimeInSeconds, endTimeInSeconds);
        KudosPeriodTypeTest.assertEquals((Object)expectedPeriod, (Object)periodOfTime);
        KudosPeriodTypeTest.assertEquals((long)startTimeInSeconds, (long)periodOfTime.getStartDateInSeconds());
        KudosPeriodTypeTest.assertEquals((long)endTimeInSeconds, (long)periodOfTime.getEndDateInSeconds());
    }

    @Test
    public void testGetSemesterPeriod() {
        KudosPeriod periodOfTime = KudosPeriodType.SEMESTER.getPeriodOfTime(LocalDate.of(2019, 7, 12).atStartOfDay());
        KudosPeriodTypeTest.assertNotNull((Object)periodOfTime);
        long startTimeInSeconds = LocalDate.of(2019, 7, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toEpochSecond();
        long endTimeInSeconds = LocalDate.of(2020, 1, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toEpochSecond();
        KudosPeriod expectedPeriod = new KudosPeriod(startTimeInSeconds, endTimeInSeconds);
        KudosPeriodTypeTest.assertEquals((Object)expectedPeriod, (Object)periodOfTime);
        KudosPeriodTypeTest.assertEquals((long)startTimeInSeconds, (long)periodOfTime.getStartDateInSeconds());
        KudosPeriodTypeTest.assertEquals((long)endTimeInSeconds, (long)periodOfTime.getEndDateInSeconds());
    }

    @Test
    public void testGetYearPeriod() {
        KudosPeriod periodOfTime = KudosPeriodType.YEAR.getPeriodOfTime(LocalDate.of(2019, 7, 12).atStartOfDay());
        KudosPeriodTypeTest.assertNotNull((Object)periodOfTime);
        long startTimeInSeconds = LocalDate.of(2019, 1, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toEpochSecond();
        long endTimeInSeconds = LocalDate.of(2020, 1, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toEpochSecond();
        KudosPeriod expectedPeriod = new KudosPeriod(startTimeInSeconds, endTimeInSeconds);
        KudosPeriodTypeTest.assertEquals((Object)expectedPeriod, (Object)periodOfTime);
        KudosPeriodTypeTest.assertEquals((int)expectedPeriod.hashCode(), (int)periodOfTime.hashCode());
        KudosPeriodTypeTest.assertEquals((long)startTimeInSeconds, (long)periodOfTime.getStartDateInSeconds());
        KudosPeriodTypeTest.assertEquals((long)endTimeInSeconds, (long)periodOfTime.getEndDateInSeconds());
    }

    @Test
    public void testKudosPeriod() throws JSONException {
        long startTimeInSeconds = LocalDate.of(2019, 7, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toEpochSecond();
        long endTimeInSeconds = LocalDate.of(2020, 1, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toEpochSecond();
        KudosPeriod periodOfTime = new KudosPeriod(startTimeInSeconds, endTimeInSeconds);
        KudosPeriodTypeTest.assertTrue((boolean)periodOfTime.toString().contains(String.valueOf(startTimeInSeconds)));
        KudosPeriodTypeTest.assertTrue((boolean)periodOfTime.toString().contains(String.valueOf(endTimeInSeconds)));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("startDateInSeconds", startTimeInSeconds);
        jsonObject.put("endDateInSeconds", endTimeInSeconds);
        KudosPeriodTypeTest.assertEquals((String)jsonObject.toString(), (String)periodOfTime.toJSONObject().toString());
    }
}

