/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.test.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.exoplatform.kudos.dao.KudosDAO;
import org.exoplatform.kudos.entity.KudosEntity;
import org.exoplatform.kudos.model.KudosEntityType;
import org.exoplatform.kudos.model.KudosPeriod;
import org.exoplatform.kudos.service.utils.Utils;
import org.exoplatform.kudos.test.BaseKudosTest;
import org.junit.Test;

public class KudosDAOTest
extends BaseKudosTest {
    @Test
    public void testServiceInstantiated() {
        KudosDAO kudosDAO = this.getService(KudosDAO.class);
        KudosDAOTest.assertNotNull((Object)kudosDAO);
    }

    @Test
    public void testGetKudosByEntity() {
        KudosDAO kudosDAO = this.getService(KudosDAO.class);
        List list = kudosDAO.getKudosByEntity(this.entityType, this.entityId, 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)0, (int)list.size());
        this.newKudos();
        list = kudosDAO.getKudosByEntity(this.entityType, this.entityId, 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)1, (int)list.size());
        list = kudosDAO.getKudosByEntity(KudosEntityType.COMMENT.ordinal(), this.entityId, 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)0, (int)list.size());
        list = kudosDAO.getKudosByEntity(this.entityType, 20L, 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testGetKudosByPeriodAndReceiver() {
        KudosDAO kudosDAO = this.getService(KudosDAO.class);
        KudosPeriod kudosPeriod = new KudosPeriod(this.getTime(2019, 1, 1), this.getCurrentTimeInSeconds());
        List list = kudosDAO.getKudosByPeriodAndReceiver(kudosPeriod, this.receiverId, true, 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)0, (int)list.size());
        this.newKudos();
        list = kudosDAO.getKudosByPeriodAndReceiver(kudosPeriod, this.receiverId, true, 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)1, (int)list.size());
        list = kudosDAO.getKudosByPeriodAndReceiver(kudosPeriod, this.receiverId, false, 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)0, (int)list.size());
        list = kudosDAO.getKudosByPeriodAndReceiver(kudosPeriod, 30L, true, 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testcountKudosByEntity() {
        KudosDAO kudosDAO = this.getService(KudosDAO.class);
        long count = kudosDAO.countKudosByEntity(this.entityType, this.entityId);
        KudosDAOTest.assertEquals((long)0L, (long)count);
        this.newKudos();
        count = kudosDAO.countKudosByEntity(this.entityType, this.entityId);
        KudosDAOTest.assertEquals((long)1L, (long)count);
        count = kudosDAO.countKudosByEntity(this.entityType, 25L);
        KudosDAOTest.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testCountKudosByEntityAndSender() {
        KudosDAO kudosDAO = this.getService(KudosDAO.class);
        long count = kudosDAO.countKudosByEntityAndSender(this.entityType, this.entityId, this.senderId);
        KudosDAOTest.assertEquals((long)0L, (long)count);
        this.newKudos();
        count = kudosDAO.countKudosByEntityAndSender(this.entityType, this.entityId, this.senderId);
        KudosDAOTest.assertEquals((long)1L, (long)count);
        count = kudosDAO.countKudosByEntityAndSender(this.entityType, 25L, this.senderId);
        KudosDAOTest.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testCountKudosByPeriodAndReceiver() {
        KudosDAO kudosDAO = this.getService(KudosDAO.class);
        KudosPeriod kudosPeriod = new KudosPeriod(this.getTime(2019, 1, 1), this.getCurrentTimeInSeconds());
        long count = kudosDAO.countKudosByPeriodAndReceiver(kudosPeriod, this.receiverId, true);
        KudosDAOTest.assertEquals((long)0L, (long)count);
        this.newKudos();
        count = kudosDAO.countKudosByPeriodAndReceiver(kudosPeriod, this.receiverId, true);
        KudosDAOTest.assertEquals((long)1L, (long)count);
        count = kudosDAO.countKudosByPeriodAndReceiver(kudosPeriod, this.receiverId, false);
        KudosDAOTest.assertEquals((long)0L, (long)count);
        count = kudosDAO.countKudosByPeriodAndReceiver(kudosPeriod, 30L, true);
        KudosDAOTest.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testCountKudosByPeriodAndReceivers() {
        KudosDAO kudosDAO = this.getService(KudosDAO.class);
        KudosPeriod kudosPeriod = new KudosPeriod(this.getTime(2019, 1, 1), this.getCurrentTimeInSeconds());
        ArrayList<Long> receiversId = new ArrayList<Long>();
        receiversId.add(this.receiverId);
        Map counts = kudosDAO.countKudosByPeriodAndReceivers(kudosPeriod, receiversId);
        KudosDAOTest.assertEquals((Object)0L, (Object)Optional.ofNullable((Long)counts.get(this.receiverId)).orElse(0L));
        this.newKudos();
        receiversId.add(30L);
        counts = kudosDAO.countKudosByPeriodAndReceivers(kudosPeriod, receiversId);
        KudosDAOTest.assertEquals((Object)1L, (Object)Optional.ofNullable((Long)counts.get(this.receiverId)).orElse(0L));
        KudosDAOTest.assertEquals((Object)0L, (Object)Optional.ofNullable((Long)counts.get(30L)).orElse(0L));
    }

    @Test
    public void testGetKudosByPeriod() {
        KudosDAO kudosDAO = this.getService(KudosDAO.class);
        KudosPeriod kudosPeriod = new KudosPeriod(this.getTime(2019, 1, 1), this.getCurrentTimeInSeconds());
        List list = kudosDAO.getKudosByPeriod(kudosPeriod, 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)0, (int)list.size());
        this.newKudos();
        list = kudosDAO.getKudosByPeriod(kudosPeriod, 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)1, (int)list.size());
        list = kudosDAO.getKudosByPeriod(new KudosPeriod(this.getTime(2019, 1, 1), this.getTime(2019, 7, 1)), 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testGetKudosByPeriodAndEntityType() {
        KudosDAO kudosDAO = this.getService(KudosDAO.class);
        KudosPeriod kudosPeriod = new KudosPeriod(this.getTime(2019, 1, 1), this.getCurrentTimeInSeconds());
        List list = kudosDAO.getKudosByPeriodAndEntityType(kudosPeriod, this.entityType, 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)0, (int)list.size());
        this.newKudos();
        list = kudosDAO.getKudosByPeriodAndEntityType(kudosPeriod, this.entityType, 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)1, (int)list.size());
        list = kudosDAO.getKudosByPeriodAndEntityType(kudosPeriod, KudosEntityType.COMMENT.ordinal(), 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testGetKudosByPeriodAndSender() {
        KudosDAO kudosDAO = this.getService(KudosDAO.class);
        KudosPeriod kudosPeriod = new KudosPeriod(this.getTime(2019, 1, 1), this.getCurrentTimeInSeconds());
        List list = kudosDAO.getKudosByPeriodAndSender(kudosPeriod, this.senderId, 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)0, (int)list.size());
        this.newKudos();
        list = kudosDAO.getKudosByPeriodAndSender(kudosPeriod, this.senderId, 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)1, (int)list.size());
        list = kudosDAO.getKudosByPeriodAndSender(kudosPeriod, 30L, 10);
        KudosDAOTest.assertNotNull((Object)list);
        KudosDAOTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testCountKudosByPeriodAndSender() {
        KudosDAO kudosDAO = this.getService(KudosDAO.class);
        KudosPeriod kudosPeriod = new KudosPeriod(this.getTime(2019, 1, 1), this.getCurrentTimeInSeconds());
        long count = kudosDAO.countKudosByPeriodAndSender(kudosPeriod, this.senderId);
        KudosDAOTest.assertEquals((long)0L, (long)count);
        this.newKudos();
        count = kudosDAO.countKudosByPeriodAndSender(kudosPeriod, this.senderId);
        KudosDAOTest.assertEquals((long)1L, (long)count);
        count = kudosDAO.countKudosByPeriodAndSender(kudosPeriod, 30L);
        KudosDAOTest.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testGetKudosByActivityId() {
        KudosDAO kudosDAO = this.getService(KudosDAO.class);
        KudosEntity kudos = this.newKudos();
        Long activityId = 1L;
        kudos.setActivityId(activityId.longValue());
        kudosDAO.create((Object)kudos);
        KudosEntity newKudos = kudosDAO.getKudosByActivityId(activityId);
        this.compareResults(newKudos, Utils.fromEntity((KudosEntity)kudos));
    }
}

