/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.test.listener;

import java.util.Collections;
import org.exoplatform.kudos.listener.ProfileUpdateListener;
import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.kudos.test.BaseKudosTest;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ProfileUpdateListenerTest
extends BaseKudosTest {
    private IdentityManager identityManager;
    private KudosService kudosService;
    private ActivityStorage activityStorage;

    @Test
    public void testUpdateProfileAndDetectChanges() {
        this.identityManager = this.getService(IdentityManager.class);
        this.kudosService = (KudosService)Mockito.mock(KudosService.class);
        this.activityStorage = (ActivityStorage)Mockito.mock(CachedActivityStorage.class);
        Identity rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root1");
        Profile profile = rootIdentity.getProfile();
        ProfileUpdateListener profileUpdateListener = new ProfileUpdateListener(this.kudosService, this.activityStorage);
        this.identityManager.registerProfileListener((ProfileListenerPlugin)profileUpdateListener);
        Kudos kudos = new Kudos();
        kudos.setActivityId(1L);
        Mockito.when((Object)this.kudosService.countKudosByPeriodAndReceiver(Mockito.anyLong(), Mockito.anyLong(), Mockito.anyLong())).thenReturn((Object)1L);
        Mockito.when((Object)this.kudosService.getKudosByPeriodAndReceiver(Mockito.anyLong(), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt())).thenReturn(Collections.singletonList(kudos));
        ((CachedActivityStorage)Mockito.doNothing().when((Object)((CachedActivityStorage)this.activityStorage))).clearActivityCached(ArgumentMatchers.anyString());
        profile.setProperty("firstName", (Object)"Changed Firstname");
        this.identityManager.updateProfile(profile);
        ((CachedActivityStorage)Mockito.verify((Object)((CachedActivityStorage)this.activityStorage), (VerificationMode)Mockito.times((int)1))).clearActivityCached(ArgumentMatchers.anyString());
        ((KudosService)Mockito.verify((Object)this.kudosService, (VerificationMode)Mockito.times((int)1))).countKudosByPeriodAndReceiver(Mockito.anyLong(), Mockito.anyLong(), Mockito.anyLong());
        ((KudosService)Mockito.verify((Object)this.kudosService, (VerificationMode)Mockito.times((int)1))).getKudosByPeriodAndReceiver(Mockito.anyLong(), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt());
        profile.setProperty("aboutMe", (Object)"Changed ABOUT_ME");
        profile.removeProperty("firstName");
        this.identityManager.updateProfile(profile);
        ((CachedActivityStorage)Mockito.verify((Object)((CachedActivityStorage)this.activityStorage), (VerificationMode)Mockito.times((int)1))).clearActivityCached(ArgumentMatchers.anyString());
        ((KudosService)Mockito.verify((Object)this.kudosService, (VerificationMode)Mockito.times((int)1))).countKudosByPeriodAndReceiver(Mockito.anyLong(), Mockito.anyLong(), Mockito.anyLong());
        ((KudosService)Mockito.verify((Object)this.kudosService, (VerificationMode)Mockito.times((int)1))).getKudosByPeriodAndReceiver(Mockito.anyLong(), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt());
        profile.setProperty("avatar", (Object)"new/avatar");
        this.identityManager.updateProfile(profile);
        ((CachedActivityStorage)Mockito.verify((Object)((CachedActivityStorage)this.activityStorage), (VerificationMode)Mockito.times((int)2))).clearActivityCached(ArgumentMatchers.anyString());
        ((KudosService)Mockito.verify((Object)this.kudosService, (VerificationMode)Mockito.times((int)2))).countKudosByPeriodAndReceiver(Mockito.anyLong(), Mockito.anyLong(), Mockito.anyLong());
        ((KudosService)Mockito.verify((Object)this.kudosService, (VerificationMode)Mockito.times((int)2))).getKudosByPeriodAndReceiver(Mockito.anyLong(), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt());
    }
}

