/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.test.rest;

import java.util.List;
import org.exoplatform.kudos.entity.KudosEntity;
import org.exoplatform.kudos.listener.KudosSentActivityGeneratorListener;
import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.model.KudosEntityType;
import org.exoplatform.kudos.model.KudosList;
import org.exoplatform.kudos.rest.KudosREST;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.kudos.service.utils.Utils;
import org.exoplatform.kudos.test.BaseKudosRestTest;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.ActivityManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class KudosRestTest
extends BaseKudosRestTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.addResource(KudosREST.class, null);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(KudosREST.class);
    }

    public String getURLResource(String resourceURL) {
        return "/kudos/api/kudos/" + resourceURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAllKudos() throws Exception {
        this.startSessionAs("root4");
        this.begin();
        try {
            ContainerResponse response = this.service("GET", this.getURLResource(""), "", null, null);
            KudosRestTest.assertNotNull((Object)response);
            KudosRestTest.assertEquals((int)200, (int)response.getStatus());
            List kudosList = (List)response.getEntity();
            KudosRestTest.assertEquals((int)0, (int)kudosList.size());
            this.newKudos();
            response = this.service("GET", this.getURLResource(""), "", null, null);
            KudosRestTest.assertNotNull((Object)response);
            KudosRestTest.assertEquals((int)200, (int)response.getStatus());
            kudosList = (List)response.getEntity();
            KudosRestTest.assertEquals((int)1, (int)kudosList.size());
            Kudos retrievedKudos = (Kudos)kudosList.get(0);
            KudosRestTest.assertNotNull((Object)retrievedKudos);
        }
        finally {
            this.end();
        }
    }

    @Test
    public void testGetReceivedKudos() throws Exception {
        String url = this.getURLResource(this.receiverId + "/received?returnSize=true&limit=10");
        this.startSessionAs("root4");
        ContainerResponse response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)200, (int)response.getStatus());
        KudosList kudosList = (KudosList)response.getEntity();
        KudosRestTest.assertEquals((long)0L, (long)kudosList.getSize());
        this.newKudos();
        response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)200, (int)response.getStatus());
        kudosList = (KudosList)response.getEntity();
        KudosRestTest.assertEquals((long)1L, (long)kudosList.getSize());
        Kudos retrievedKudos = (Kudos)kudosList.getKudos().get(0);
        KudosRestTest.assertNotNull((Object)retrievedKudos);
    }

    @Test
    public void testGetSentKudos() throws Exception {
        String url = this.getURLResource(this.senderId + "/sent?returnSize=true&limit=10");
        this.startSessionAs("root4");
        ContainerResponse response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)200, (int)response.getStatus());
        KudosList kudosList = (KudosList)response.getEntity();
        KudosRestTest.assertEquals((long)0L, (long)kudosList.getSize());
        this.newKudos();
        response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)200, (int)response.getStatus());
        kudosList = (KudosList)response.getEntity();
        KudosRestTest.assertEquals((long)1L, (long)kudosList.getSize());
        Kudos retrievedKudos = (Kudos)kudosList.getKudos().get(0);
        KudosRestTest.assertNotNull((Object)retrievedKudos);
    }

    @Test
    public void testGetKudosByActivityId() throws Exception {
        this.startSessionAs("root4");
        KudosService kudosService = this.getService(KudosService.class);
        KudosEntity kudosEntity = this.newKudosInstance();
        Kudos kudos = kudosService.createKudos(Utils.fromEntity((KudosEntity)kudosEntity), "root4");
        long activityId = 5L;
        kudosService.updateKudosGeneratedActivityId(kudos.getTechnicalId().longValue(), activityId);
        kudos = kudosService.getKudosByActivityId(Long.valueOf(activityId));
        KudosRestTest.assertEquals((long)activityId, (long)kudos.getActivityId());
        String url = this.getURLResource("byActivity/" + activityId);
        ContainerResponse response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)200, (int)response.getStatus());
        Kudos kudosByActivity = (Kudos)response.getEntity();
        KudosRestTest.assertNotNull((Object)kudosByActivity);
        KudosRestTest.assertTrue((kudosByActivity.getActivityId() > 0L ? 1 : 0) != 0);
        KudosRestTest.assertEquals((Object)kudos.getTechnicalId(), (Object)kudosByActivity.getTechnicalId());
        url = this.getURLResource("byActivity/200");
        response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)200, (int)response.getStatus());
        kudosByActivity = (Kudos)response.getEntity();
        KudosRestTest.assertNull((Object)kudosByActivity);
        this.startSessionAs("root3");
        url = this.getURLResource("byActivity/" + activityId);
        response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)200, (int)response.getStatus());
        kudosByActivity = (Kudos)response.getEntity();
        KudosRestTest.assertNotNull((Object)kudosByActivity);
        KudosRestTest.assertTrue((kudosByActivity.getActivityId() > 0L ? 1 : 0) != 0);
        KudosRestTest.assertEquals((Object)kudos.getTechnicalId(), (Object)kudosByActivity.getTechnicalId());
        this.startSessionAs("root2");
        url = this.getURLResource("byActivity/" + activityId);
        response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)200, (int)response.getStatus());
        kudosByActivity = (Kudos)response.getEntity();
        KudosRestTest.assertNull((Object)kudosByActivity);
        ActivityManager activityManager = this.getService(ActivityManager.class);
        new KudosSentActivityGeneratorListener(activityManager, null).onEvent(new Event(null, (Object)kudosService, (Object)kudos));
        List kudosList = kudosService.getKudosByEntity(kudos.getEntityType(), kudos.getEntityId(), 1);
        KudosRestTest.assertEquals((int)1, (int)kudosList.size());
        kudos = (Kudos)kudosList.get(0);
        activityId = kudos.getActivityId();
        url = this.getURLResource("byActivity/" + activityId);
        response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)404, (int)response.getStatus());
        this.startSessionAs("root4");
        url = this.getURLResource("byActivity/" + activityId);
        response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)200, (int)response.getStatus());
        this.startSessionAs("root3");
        url = this.getURLResource("byActivity/" + activityId);
        response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testGetKudosListOfActivity() throws Exception {
        String senderUsername = "root4";
        this.startSessionAs(senderUsername);
        KudosService kudosService = this.getService(KudosService.class);
        KudosEntity kudosEntity = this.newKudosInstance();
        kudosEntity.setEntityType(KudosEntityType.SPACE_PROFILE.ordinal());
        Kudos parentKudos = kudosService.createKudos(Utils.fromEntity((KudosEntity)kudosEntity), senderUsername);
        ActivityManager activityManager = this.getService(ActivityManager.class);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setUserId(senderUsername);
        activityManager.saveActivityNoReturn((ExoSocialActivity)activity);
        String activityId = activity.getId();
        parentKudos.setActivityId(Long.parseLong(activityId));
        kudosService.updateKudosGeneratedActivityId(parentKudos.getTechnicalId().longValue(), Long.parseLong(activityId));
        KudosEntity childKudosEntity = this.newKudosInstance();
        childKudosEntity.setEntityType(KudosEntityType.ACTIVITY.ordinal());
        childKudosEntity.setEntityId(250L);
        childKudosEntity.setParentEntityId(Long.valueOf(parentKudos.getActivityId()));
        Kudos childKudos = kudosService.createKudos(Utils.fromEntity((KudosEntity)childKudosEntity), senderUsername);
        this.getKudosListOfActivity("%20", senderUsername, 400);
        this.getKudosListOfActivity(activityId, "root3", 404);
        List<Kudos> kudosList = this.getKudosListOfActivity("66699963", senderUsername, 200);
        KudosRestTest.assertNotNull(kudosList);
        KudosRestTest.assertTrue((boolean)kudosList.isEmpty());
        kudosList = this.getKudosListOfActivity(activityId, senderUsername, 200);
        KudosRestTest.assertNotNull(kudosList);
        KudosRestTest.assertEquals((int)2, (int)kudosList.size());
        KudosRestTest.assertTrue((boolean)kudosList.stream().anyMatch(kudos -> kudos.getTechnicalId() == parentKudos.getTechnicalId()));
        KudosRestTest.assertTrue((boolean)kudosList.stream().anyMatch(kudos -> kudos.getTechnicalId() == childKudos.getTechnicalId()));
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setUserId("root,root4");
        activityManager.saveActivityNoReturn((ExoSocialActivity)comment);
        childKudos.setActivityId(Long.parseLong(comment.getId()));
        kudosService.updateKudosGeneratedActivityId(childKudos.getTechnicalId().longValue(), Long.parseLong(comment.getId()));
        KudosEntity subCommentKudosEntity = this.newKudosInstance();
        subCommentKudosEntity.setEntityType(KudosEntityType.COMMENT.ordinal());
        subCommentKudosEntity.setEntityId(255L);
        subCommentKudosEntity.setParentEntityId(Long.valueOf(parentKudos.getActivityId()));
        Kudos subCommentKudos = kudosService.createKudos(Utils.fromEntity((KudosEntity)subCommentKudosEntity), senderUsername);
        kudosList = this.getKudosListOfActivity(activityId, senderUsername, 200);
        KudosRestTest.assertNotNull(kudosList);
        KudosRestTest.assertEquals((int)3, (int)kudosList.size());
        KudosRestTest.assertTrue((boolean)kudosList.stream().anyMatch(kudos -> kudos.getTechnicalId() == parentKudos.getTechnicalId()));
        KudosRestTest.assertTrue((boolean)kudosList.stream().anyMatch(kudos -> kudos.getTechnicalId() == childKudos.getTechnicalId()));
        KudosRestTest.assertTrue((boolean)kudosList.stream().anyMatch(kudos -> kudos.getTechnicalId() == subCommentKudos.getTechnicalId()));
    }

    @Test
    public void testCountSentKudosByEntityAndUser() throws Exception {
        this.startSessionAs("root4");
        String url = this.getURLResource("byEntity/sent/count?entityType=" + this.kudosEntityType + "&entityId=" + this.entityId);
        ContainerResponse response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)200, (int)response.getStatus());
        String count = (String)response.getEntity();
        KudosRestTest.assertNotNull((Object)count);
        KudosRestTest.assertEquals((String)"0", (String)count);
        this.newKudos();
        response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)200, (int)response.getStatus());
        count = (String)response.getEntity();
        KudosRestTest.assertNotNull((Object)count);
        KudosRestTest.assertEquals((String)"1", (String)count);
        this.startSessionAs("root3");
        response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)200, (int)response.getStatus());
        count = (String)response.getEntity();
        KudosRestTest.assertNotNull((Object)count);
        KudosRestTest.assertEquals((String)"0", (String)count);
    }

    @Test
    public void testSendKudos() throws Exception {
        this.startSessionAs("root4");
        String url = this.getURLResource("");
        String input = "{\"entityId\":\"" + this.entityId + "\", \"entityType\":\"" + this.kudosEntityType.name() + "\", \"receiverId\":\"root" + this.receiverId + "\", \"receiverType\":\"organization\", \"parentEntityId\":\"" + this.parentEntityId + "\", \"message\":\"" + this.message + "\"}";
        ContainerResponse response = this.getResponse("POST", url, input);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((String)String.valueOf(response.getEntity()), (int)200, (int)response.getStatus());
        Kudos kudos = (Kudos)response.getEntity();
        KudosRestTest.assertEquals((String)String.valueOf(this.entityId), (String)kudos.getEntityId());
        KudosRestTest.assertEquals((String)String.valueOf(this.receiverId), (String)kudos.getReceiverIdentityId());
        KudosRestTest.assertEquals((String)String.valueOf(this.parentEntityId), (String)kudos.getParentEntityId());
        KudosRestTest.assertEquals((String)this.kudosEntityType.name(), (String)kudos.getEntityType());
        KudosRestTest.assertEquals((String)this.message, (String)kudos.getMessage());
        url = this.getURLResource("byEntity/sent/count?entityType=" + this.kudosEntityType + "&entityId=" + this.entityId);
        response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)200, (int)response.getStatus());
        String count = (String)response.getEntity();
        KudosRestTest.assertNotNull((Object)count);
        KudosRestTest.assertEquals((String)"1", (String)count);
    }

    @Test
    public void testDeleteKudos() throws Exception {
        this.startSessionAs("root4");
        String url = this.getURLResource("" + this.entityId);
        ContainerResponse response = this.service("DELETE", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)404, (int)response.getStatus());
        KudosEntity kudos = this.newKudos();
        this.startSessionAs("root3");
        url = this.getURLResource("" + kudos.getId());
        response = this.service("DELETE", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("root4");
        response = this.service("DELETE", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)204, (int)response.getStatus());
        response = this.service("DELETE", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((int)404, (int)response.getStatus());
    }

    private List<Kudos> getKudosListOfActivity(String activityId, String username, int expectedStatus) throws Exception {
        this.startSessionAs(username);
        String url = this.getURLResource("byActivity/" + activityId + "/all");
        ContainerResponse response = this.service("GET", url, "", null, null);
        KudosRestTest.assertNotNull((Object)response);
        KudosRestTest.assertEquals((String)(response.getEntity() == null ? "Unexpected status: " + response.getStatus() : response.getEntity().toString()), (int)expectedStatus, (int)response.getStatus());
        List kudosList = null;
        if (expectedStatus == 200) {
            kudosList = (List)response.getEntity();
        }
        return kudosList;
    }
}

