/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.test.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.kudos.entity.KudosEntity;
import org.exoplatform.kudos.model.AccountSettings;
import org.exoplatform.kudos.model.GlobalSettings;
import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.model.KudosEntityType;
import org.exoplatform.kudos.model.KudosPeriod;
import org.exoplatform.kudos.model.KudosPeriodType;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.kudos.service.utils.Utils;
import org.exoplatform.kudos.storage.KudosStorage;
import org.exoplatform.kudos.test.BaseKudosTest;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.Assert;
import org.junit.Test;

public class KudosServiceTest
extends BaseKudosTest {
    private static final String DEFAULT_PORTAL = "meeds";
    private static final String ENTITY_TYPE = KudosEntityType.USER_TIPTIP.name();
    private static final String ENTITY_ID = "1";
    private static final long RECEIVER_ID = 3L;
    private static final String RECEIVER_REMOTE_ID = "root3";
    private static final String SENDER_REMOTE_ID = "root4";

    @Test
    public void testServiceInstantiated() {
        KudosService kudosService = this.getService(KudosService.class);
        KudosServiceTest.assertNotNull((Object)kudosService);
    }

    @Test
    public void testGetKudosByEntity() {
        KudosService kudosService = this.getService(KudosService.class);
        List list = kudosService.getKudosByEntity(ENTITY_TYPE, ENTITY_ID, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)0, (int)list.size());
        KudosEntity kudosEntity = this.newKudos();
        list = kudosService.getKudosByEntity(ENTITY_TYPE, ENTITY_ID, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)1, (int)list.size());
        Kudos kudos = (Kudos)list.get(0);
        this.compareResults(kudosEntity, kudos);
        list = kudosService.getKudosByEntity(KudosEntityType.SPACE_TIPTIP.name(), ENTITY_ID, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)0, (int)list.size());
        list = kudosService.getKudosByEntity(ENTITY_TYPE, "20", 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testCountKudosByEntity() {
        KudosService kudosService = this.getService(KudosService.class);
        long count = kudosService.countKudosByEntity(ENTITY_TYPE, ENTITY_ID);
        KudosServiceTest.assertEquals((long)0L, (long)count);
        this.newKudos();
        count = kudosService.countKudosByEntity(ENTITY_TYPE, ENTITY_ID);
        KudosServiceTest.assertEquals((long)1L, (long)count);
        count = kudosService.countKudosByEntity(ENTITY_TYPE, "25");
        KudosServiceTest.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testCountKudosByEntityAndSender() {
        KudosService kudosService = this.getService(KudosService.class);
        long count = kudosService.countKudosByEntityAndSender(ENTITY_TYPE, ENTITY_ID, String.valueOf(this.senderId));
        KudosServiceTest.assertEquals((long)0L, (long)count);
        this.newKudos();
        count = kudosService.countKudosByEntityAndSender(ENTITY_TYPE, ENTITY_ID, String.valueOf(this.senderId));
        KudosServiceTest.assertEquals((long)1L, (long)count);
        count = kudosService.countKudosByEntityAndSender(ENTITY_TYPE, "25", String.valueOf(this.senderId));
        KudosServiceTest.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testGetKudosByPeriodAndReceiver() {
        KudosService kudosService = this.getService(KudosService.class);
        long startTime = this.getTime(2019, 1, 1);
        long endTime = this.getCurrentTimeInSeconds();
        List list = kudosService.getKudosByPeriodAndReceiver(3L, startTime, endTime, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)0, (int)list.size());
        KudosEntity kudosEntity = this.newKudos();
        list = kudosService.getKudosByPeriodAndReceiver(3L, startTime, endTime, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)1, (int)list.size());
        Kudos kudos = (Kudos)list.get(0);
        this.compareResults(kudosEntity, kudos);
        list = kudosService.getKudosByPeriodAndReceiver(30L, startTime, endTime, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)0, (int)list.size());
        list = kudosService.getKudosByPeriodAndReceiver(30000L, startTime, endTime, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testCountKudosByPeriodAndReceiver() {
        KudosService kudosService = this.getService(KudosService.class);
        long startTime = this.getTime(2019, 1, 1);
        long endTime = this.getCurrentTimeInSeconds();
        long count = kudosService.countKudosByPeriodAndReceiver(3L, startTime, endTime);
        KudosServiceTest.assertEquals((long)0L, (long)count);
        this.newKudos();
        count = kudosService.countKudosByPeriodAndReceiver(3L, startTime, endTime);
        KudosServiceTest.assertEquals((long)1L, (long)count);
        count = kudosService.countKudosByPeriodAndReceiver(30L, startTime, endTime);
        KudosServiceTest.assertEquals((long)0L, (long)count);
        count = kudosService.countKudosByPeriodAndReceiver(30000L, startTime, endTime);
        KudosServiceTest.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testCountKudosByPeriodAndReceivers() {
        KudosService kudosService = this.getService(KudosService.class);
        long startTime = this.getTime(2019, 1, 1);
        long endTime = this.getCurrentTimeInSeconds();
        ArrayList<Long> receivers = new ArrayList<Long>();
        receivers.add(3L);
        Map counts = kudosService.countKudosByPeriodAndReceivers(receivers, startTime, endTime);
        KudosServiceTest.assertEquals((Object)0L, (Object)Optional.ofNullable((Long)counts.get(3L)).orElse(0L));
        this.newKudos();
        receivers.add(30L);
        receivers.add(30000L);
        counts = kudosService.countKudosByPeriodAndReceivers(receivers, startTime, endTime);
        KudosServiceTest.assertEquals((Object)1L, (Object)Optional.ofNullable((Long)counts.get(3L)).orElse(0L));
        KudosServiceTest.assertEquals((Object)0L, (Object)Optional.ofNullable((Long)counts.get(30L)).orElse(0L));
        KudosServiceTest.assertEquals((Object)0L, (Object)Optional.ofNullable((Long)counts.get(30000L)).orElse(0L));
    }

    @Test
    public void testGetKudosByPeriodAndSender() {
        KudosService kudosService = this.getService(KudosService.class);
        long startTime = this.getTime(2019, 1, 1);
        long endTime = this.getCurrentTimeInSeconds();
        List list = kudosService.getKudosByPeriodAndSender(this.senderId, startTime, endTime, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)0, (int)list.size());
        KudosEntity kudosEntity = this.newKudos();
        list = kudosService.getKudosByPeriodAndSender(this.senderId, startTime, endTime, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)1, (int)list.size());
        Kudos kudos = (Kudos)list.get(0);
        this.compareResults(kudosEntity, kudos);
        list = kudosService.getKudosByPeriodAndSender(30L, startTime, endTime, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)0, (int)list.size());
        list = kudosService.getKudosByPeriodAndSender(30000L, startTime, endTime, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testCountKudosByPeriodAndSender() {
        KudosService kudosService = this.getService(KudosService.class);
        long startTime = this.getTime(2019, 1, 1);
        long endTime = this.getCurrentTimeInSeconds();
        long count = kudosService.countKudosByPeriodAndSender(this.senderId, startTime, endTime);
        KudosServiceTest.assertEquals((long)0L, (long)count);
        this.newKudos();
        count = kudosService.countKudosByPeriodAndSender(this.senderId, startTime, endTime);
        KudosServiceTest.assertEquals((long)1L, (long)count);
        count = kudosService.countKudosByPeriodAndSender(30L, startTime, endTime);
        KudosServiceTest.assertEquals((long)0L, (long)count);
        count = kudosService.countKudosByPeriodAndSender(30000L, startTime, endTime);
        KudosServiceTest.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testGetKudosByPeriod() {
        KudosService kudosService = this.getService(KudosService.class);
        long startTime = this.getTime(2019, 1, 1);
        long endTime = this.getCurrentTimeInSeconds();
        List list = kudosService.getKudosByPeriod(startTime, endTime, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)0, (int)list.size());
        KudosEntity kudosEntity = this.newKudos();
        list = kudosService.getKudosByPeriod(startTime, endTime, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)1, (int)list.size());
        Kudos kudos = (Kudos)list.get(0);
        this.compareResults(kudosEntity, kudos);
        list = kudosService.getKudosByPeriod(this.getTime(2019, 1, 1), this.getTime(2019, 7, 1), 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testGetKudosByPeriodOfDate() {
        KudosService kudosService = this.getService(KudosService.class);
        long startTime = this.getCurrentTimeInSeconds();
        List list = kudosService.getKudosByPeriodOfDate(startTime, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)0, (int)list.size());
        KudosEntity kudosEntity = this.newKudos();
        list = kudosService.getKudosByPeriodOfDate(startTime, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)1, (int)list.size());
        Kudos kudos = (Kudos)list.get(0);
        this.compareResults(kudosEntity, kudos);
        list = kudosService.getKudosByPeriodOfDate(this.getTime(2019, 6, 1), 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testSendKudos() throws Exception {
        KudosService kudosService = this.getService(KudosService.class);
        Kudos kudos = this.newKudosDTO();
        try {
            kudosService.createKudos(kudos, RECEIVER_REMOTE_ID);
            KudosServiceTest.fail((String)"Sender shouldn't be able to send kudos to himself");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Kudos fakeKudos = this.newKudosDTO();
            fakeKudos.setReceiverId(SENDER_REMOTE_ID);
            kudosService.createKudos(fakeKudos, SENDER_REMOTE_ID);
            KudosServiceTest.fail((String)"Sender shouldn't be the same as sender in DTO");
        }
        catch (Exception fakeKudos) {
            // empty catch block
        }
        kudos = kudosService.createKudos(kudos, SENDER_REMOTE_ID);
        KudosPeriod currentKudosPeriod = kudosService.getCurrentKudosPeriod();
        IdentityManager identityManager = this.getService(IdentityManager.class);
        org.exoplatform.social.core.identity.model.Identity identity = identityManager.getOrCreateIdentity("organization", RECEIVER_REMOTE_ID);
        List list = kudosService.getKudosByPeriodAndReceiver(Long.parseLong(identity.getId()), currentKudosPeriod.getStartDateInSeconds(), currentKudosPeriod.getEndDateInSeconds(), 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)1, (int)list.size());
        Kudos retrievedKudos = (Kudos)list.get(0);
        KudosServiceTest.assertEquals((Object)kudos, (Object)retrievedKudos);
        KudosServiceTest.assertEquals((Object)kudos.getTechnicalId(), (Object)retrievedKudos.getTechnicalId());
        KudosServiceTest.assertEquals((long)kudos.getTimeInSeconds(), (long)retrievedKudos.getTimeInSeconds());
        KudosServiceTest.assertEquals((int)kudos.hashCode(), (int)retrievedKudos.hashCode());
        KudosServiceTest.assertNotNull((Object)kudos.toString());
        KudosServiceTest.assertTrue((boolean)kudos.toString().contains(SENDER_REMOTE_ID));
        KudosServiceTest.assertTrue((boolean)kudos.toString().contains(RECEIVER_REMOTE_ID));
    }

    @Test
    public void testSendKudosToSpace() throws Exception {
        KudosService kudosService = this.getService(KudosService.class);
        String spaceRemoteId = "space3";
        Kudos kudos = this.newKudosDTO();
        kudos.setReceiverType("space");
        kudos.setReceiverId(spaceRemoteId);
        kudos.setReceiverIdentityId(null);
        this.restartTransaction();
        kudos = kudosService.createKudos(kudos, SENDER_REMOTE_ID);
        KudosPeriod currentKudosPeriod = kudosService.getCurrentKudosPeriod();
        IdentityManager identityManager = this.getService(IdentityManager.class);
        org.exoplatform.social.core.identity.model.Identity identity = identityManager.getOrCreateIdentity("space", spaceRemoteId);
        List list = kudosService.getKudosByPeriodAndReceiver(Long.parseLong(identity.getId()), currentKudosPeriod.getStartDateInSeconds(), currentKudosPeriod.getEndDateInSeconds(), 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)1, (int)list.size());
        Kudos retrievedKudos = (Kudos)list.get(0);
        KudosServiceTest.assertEquals((Object)kudos, (Object)retrievedKudos);
        KudosServiceTest.assertEquals((Object)kudos.getTechnicalId(), (Object)retrievedKudos.getTechnicalId());
        KudosServiceTest.assertEquals((long)kudos.getTimeInSeconds(), (long)retrievedKudos.getTimeInSeconds());
        KudosServiceTest.assertEquals((int)kudos.hashCode(), (int)retrievedKudos.hashCode());
    }

    @Test
    public void testGetKudosByPeriodType() {
        KudosService kudosService = this.getService(KudosService.class);
        long startTime = this.getCurrentTimeInSeconds();
        try {
            kudosService.getKudosByPeriod(startTime, null, 10);
            KudosServiceTest.fail((String)"Shouldn't be able to get kudos list by null period type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        List list = kudosService.getKudosByPeriod(startTime, KudosPeriodType.WEEK, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)0, (int)list.size());
        KudosEntity kudosEntity = this.newKudos();
        list = kudosService.getKudosByPeriod(startTime, KudosPeriodType.WEEK, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)1, (int)list.size());
        Kudos kudos = (Kudos)list.get(0);
        this.compareResults(kudosEntity, kudos);
        list = kudosService.getKudosByPeriod(this.getTime(2019, 6, 1), KudosPeriodType.WEEK, 10);
        KudosServiceTest.assertNotNull((Object)list);
        KudosServiceTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testGlobalSettings() {
        KudosService kudosService = this.getService(KudosService.class);
        GlobalSettings globalSettings = kudosService.getGlobalSettings();
        KudosServiceTest.assertNotNull((Object)globalSettings);
        KudosServiceTest.assertNotNull((Object)globalSettings.getKudosPeriodType());
        KudosServiceTest.assertTrue((boolean)StringUtils.isBlank((CharSequence)globalSettings.getAccessPermission()));
        KudosServiceTest.assertTrue((globalSettings.getKudosPerPeriod() > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveSettings() {
        KudosService kudosService = this.getService(KudosService.class);
        GlobalSettings globalSettings = kudosService.getGlobalSettings();
        GlobalSettings defaultSettings = globalSettings.clone();
        try {
            globalSettings.setAccessPermission("/platform");
            globalSettings.setKudosPeriodType(KudosPeriodType.WEEK);
            globalSettings.setKudosPerPeriod(1L);
            kudosService.saveGlobalSettings(globalSettings);
            GlobalSettings savedGlobalSettings = kudosService.getGlobalSettings();
            KudosServiceTest.assertEquals((Object)globalSettings, (Object)savedGlobalSettings);
            KudosServiceTest.assertEquals((int)globalSettings.hashCode(), (int)savedGlobalSettings.hashCode());
        }
        finally {
            kudosService.saveGlobalSettings(defaultSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendKudosAfterLimitReached() throws Exception {
        KudosService kudosService = this.getService(KudosService.class);
        GlobalSettings globalSettings = kudosService.getGlobalSettings();
        GlobalSettings defaultSettings = globalSettings.clone();
        try {
            globalSettings.setKudosPerPeriod(1L);
            kudosService.saveGlobalSettings(globalSettings);
            Kudos kudos = this.newKudosDTO();
            kudos = kudosService.createKudos(kudos, SENDER_REMOTE_ID);
            Thread.sleep(1000L);
            try {
                kudos = kudosService.createKudos(kudos, SENDER_REMOTE_ID);
                KudosServiceTest.fail((String)"Shouldn't be able to send another Kudos");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            kudosService.saveGlobalSettings(defaultSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAccountSettings() throws Exception {
        KudosService kudosService = this.getService(KudosService.class);
        GlobalSettings globalSettings = kudosService.getGlobalSettings();
        GlobalSettings defaultSettings = globalSettings.clone();
        try {
            AccountSettings accountSettings = kudosService.getAccountSettings(SENDER_REMOTE_ID);
            KudosServiceTest.assertNotNull((Object)accountSettings);
            KudosServiceTest.assertFalse((boolean)accountSettings.isDisabled());
            KudosServiceTest.assertEquals((long)globalSettings.getKudosPerPeriod(), (long)accountSettings.getRemainingKudos());
            globalSettings.setKudosPerPeriod(1L);
            kudosService.saveGlobalSettings(globalSettings);
            Kudos kudos = this.newKudosDTO();
            kudos = kudosService.createKudos(kudos, SENDER_REMOTE_ID);
            Thread.sleep(1000L);
            accountSettings = kudosService.getAccountSettings(SENDER_REMOTE_ID);
            KudosServiceTest.assertNotNull((Object)accountSettings);
            KudosServiceTest.assertFalse((boolean)accountSettings.isDisabled());
            KudosServiceTest.assertEquals((long)0L, (long)accountSettings.getRemainingKudos());
        }
        finally {
            kudosService.saveGlobalSettings(defaultSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAccountSettingsDisabled() {
        KudosService kudosService = this.getService(KudosService.class);
        GlobalSettings globalSettings = kudosService.getGlobalSettings();
        GlobalSettings defaultSettings = globalSettings.clone();
        try {
            AccountSettings accountSettings = kudosService.getAccountSettings(SENDER_REMOTE_ID);
            KudosServiceTest.assertNotNull((Object)accountSettings);
            KudosServiceTest.assertFalse((boolean)accountSettings.isDisabled());
            globalSettings.setAccessPermission("/platform");
            kudosService.saveGlobalSettings(globalSettings);
            AccountSettings savedAccountSettings = kudosService.getAccountSettings(SENDER_REMOTE_ID);
            KudosServiceTest.assertNotNull((Object)savedAccountSettings);
            KudosServiceTest.assertTrue((boolean)savedAccountSettings.isDisabled());
            Assert.assertNotEquals((Object)accountSettings, (Object)savedAccountSettings);
            Assert.assertNotEquals((long)accountSettings.hashCode(), (long)savedAccountSettings.hashCode());
        }
        finally {
            kudosService.saveGlobalSettings(defaultSettings);
        }
    }

    @Test
    public void testSaveKudosActivity() throws Exception {
        KudosService kudosService = this.getService(KudosService.class);
        ListenerService listenerService = this.getService(ListenerService.class);
        Kudos kudos = this.newKudosDTO();
        kudos = kudosService.createKudos(kudos, SENDER_REMOTE_ID);
        final AtomicBoolean listenerInvoked = new AtomicBoolean(false);
        listenerService.addListener("exo.kudos.activity", (Listener)new Listener<KudosService, Kudos>(this){

            public void onEvent(Event<KudosService, Kudos> event) throws Exception {
                listenerInvoked.set(true);
            }
        });
        kudosService.updateKudosGeneratedActivityId(kudos.getTechnicalId().longValue(), kudos.getActivityId());
        KudosServiceTest.assertTrue((boolean)listenerInvoked.get());
    }

    @Test
    public void testActivityCreation() throws Exception {
        KudosService kudosService = this.getService(KudosService.class);
        KudosStorage kudosStorage = this.getService(KudosStorage.class);
        ListenerService listenerService = this.getService(ListenerService.class);
        final AtomicBoolean listenerInvoked = new AtomicBoolean(false);
        listenerService.addListener("exo.gamification.generic.action", (Listener)new Listener<KudosService, Kudos>(this){

            public void onEvent(Event<KudosService, Kudos> event) throws Exception {
                listenerInvoked.set(true);
            }
        });
        Kudos kudos = this.newKudosDTO();
        kudos.setEntityType(KudosEntityType.USER_PROFILE.name());
        kudos = kudosService.createKudos(kudos, SENDER_REMOTE_ID);
        kudos = kudosStorage.getKudoById(kudos.getTechnicalId().longValue());
        KudosServiceTest.assertTrue((kudos.getActivityId() > 0L ? 1 : 0) != 0);
        for (int i = 0; i < 10 && !listenerInvoked.get(); ++i) {
            Thread.sleep(500L);
        }
        KudosServiceTest.assertTrue((boolean)listenerInvoked.get());
    }

    @Test
    public void testGetKudosByActivityId() throws Exception {
        KudosService kudosService = this.getService(KudosService.class);
        KudosStorage kudosStorage = this.getService(KudosStorage.class);
        KudosEntity kudosEntity = this.newKudos();
        kudosEntity.setEntityType(KudosEntityType.USER_PROFILE.ordinal());
        Kudos kudos = kudosService.createKudos(Utils.fromEntity((KudosEntity)kudosEntity), SENDER_REMOTE_ID);
        Kudos storedKudos = kudosStorage.getKudoById(kudos.getTechnicalId().longValue());
        Kudos newKudos = kudosService.getKudosByActivityId(Long.valueOf(storedKudos.getActivityId()));
        this.compareResults(Utils.toEntity((Kudos)storedKudos), newKudos);
    }

    @Test
    public void testGetKudosListOfActivity() throws Exception {
        this.resetGlobalSettings();
        KudosService kudosService = this.getService(KudosService.class);
        KudosEntity kudosEntity = this.newKudosInstance();
        kudosEntity.setEntityType(KudosEntityType.SPACE_PROFILE.ordinal());
        Kudos parentKudos = kudosService.createKudos(Utils.fromEntity((KudosEntity)kudosEntity), SENDER_REMOTE_ID);
        ActivityManager activityManager = this.getService(ActivityManager.class);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setUserId("root");
        activityManager.saveActivityNoReturn((ExoSocialActivity)activity);
        parentKudos.setActivityId(Long.parseLong(activity.getId()));
        kudosService.updateKudosGeneratedActivityId(parentKudos.getTechnicalId().longValue(), Long.parseLong(activity.getId()));
        KudosEntity childKudosEntity = this.newKudosInstance();
        childKudosEntity.setEntityType(KudosEntityType.ACTIVITY.ordinal());
        childKudosEntity.setEntityId(250L);
        childKudosEntity.setParentEntityId(Long.valueOf(parentKudos.getActivityId()));
        Kudos childKudos = kudosService.createKudos(Utils.fromEntity((KudosEntity)childKudosEntity), SENDER_REMOTE_ID);
        try {
            kudosService.getKudosListOfActivity(activity.getId(), null);
            KudosServiceTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        List kudosList = kudosService.getKudosListOfActivity("2556", new Identity("root"));
        KudosServiceTest.assertNotNull((Object)kudosList);
        KudosServiceTest.assertTrue((boolean)kudosList.isEmpty());
        try {
            kudosService.getKudosListOfActivity(activity.getId(), new Identity(SENDER_REMOTE_ID));
            KudosServiceTest.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        kudosList = kudosService.getKudosListOfActivity(activity.getId(), new Identity("root"));
        KudosServiceTest.assertNotNull((Object)kudosList);
        KudosServiceTest.assertEquals((int)2, (int)kudosList.size());
        KudosServiceTest.assertTrue((boolean)kudosList.stream().anyMatch(kudos -> kudos.getTechnicalId() == parentKudos.getTechnicalId()));
        KudosServiceTest.assertTrue((boolean)kudosList.stream().anyMatch(kudos -> kudos.getTechnicalId() == childKudos.getTechnicalId()));
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setUserId("root,root4");
        activityManager.saveActivityNoReturn((ExoSocialActivity)comment);
        childKudos.setActivityId(Long.parseLong(comment.getId()));
        kudosService.updateKudosGeneratedActivityId(childKudos.getTechnicalId().longValue(), Long.parseLong(comment.getId()));
        KudosEntity subCommentKudosEntity = this.newKudosInstance();
        subCommentKudosEntity.setEntityType(KudosEntityType.COMMENT.ordinal());
        subCommentKudosEntity.setEntityId(255L);
        subCommentKudosEntity.setParentEntityId(Long.valueOf(parentKudos.getActivityId()));
        Kudos subCommentKudos = kudosService.createKudos(Utils.fromEntity((KudosEntity)subCommentKudosEntity), SENDER_REMOTE_ID);
        kudosList = kudosService.getKudosListOfActivity(activity.getId(), new Identity("root"));
        KudosServiceTest.assertNotNull((Object)kudosList);
        KudosServiceTest.assertEquals((int)3, (int)kudosList.size());
        KudosServiceTest.assertTrue((boolean)kudosList.stream().anyMatch(kudos -> kudos.getTechnicalId() == parentKudos.getTechnicalId()));
        KudosServiceTest.assertTrue((boolean)kudosList.stream().anyMatch(kudos -> kudos.getTechnicalId() == childKudos.getTechnicalId()));
        KudosServiceTest.assertTrue((boolean)kudosList.stream().anyMatch(kudos -> kudos.getTechnicalId() == subCommentKudos.getTechnicalId()));
    }

    @Test
    public void testUpdateKudos() throws Exception {
        KudosService kudosService = this.getService(KudosService.class);
        KudosStorage kudosStorage = this.getService(KudosStorage.class);
        Kudos kudos = this.newKudosDTO();
        kudos.setEntityType(KudosEntityType.USER_PROFILE.name());
        kudos = kudosService.createKudos(kudos, SENDER_REMOTE_ID);
        Kudos storedKudos = kudosStorage.getKudoById(kudos.getTechnicalId().longValue());
        storedKudos.setMessage("updated message");
        Kudos newKudos = kudosService.updateKudos(storedKudos);
        KudosServiceTest.assertEquals((String)newKudos.getMessage(), (String)storedKudos.getMessage());
        this.compareResults(Utils.toEntity((Kudos)newKudos), storedKudos);
    }

    @Test
    public void testDeleteKudosById() throws Exception {
        KudosService kudosService = this.getService(KudosService.class);
        KudosStorage kudosStorage = this.getService(KudosStorage.class);
        Kudos kudos = this.newKudosDTO();
        kudos.setEntityType(KudosEntityType.USER_PROFILE.name());
        kudos = kudosService.createKudos(kudos, SENDER_REMOTE_ID);
        long kudosId = kudos.getTechnicalId();
        Assert.assertThrows(IllegalArgumentException.class, () -> kudosService.deleteKudosById(0L, SENDER_REMOTE_ID));
        Assert.assertThrows(ObjectNotFoundException.class, () -> kudosService.deleteKudosById(100L, SENDER_REMOTE_ID));
        Assert.assertThrows(IllegalAccessException.class, () -> kudosService.deleteKudosById(kudosId, RECEIVER_REMOTE_ID));
        kudosService.deleteKudosById(kudosId, SENDER_REMOTE_ID);
        Kudos kudos1 = kudosStorage.getKudoById(kudos.getTechnicalId().longValue());
        KudosServiceTest.assertNull((Object)kudos1);
    }

    @Test
    public void testCancelKudosById() throws Exception {
        KudosService kudosService = this.getService(KudosService.class);
        KudosStorage kudosStorage = this.getService(KudosStorage.class);
        Kudos kudos = this.newKudosDTO();
        kudos.setEntityType(KudosEntityType.USER_PROFILE.name());
        kudos = kudosService.createKudos(kudos, SENDER_REMOTE_ID);
        long kudosId = kudos.getTechnicalId();
        Assert.assertThrows(IllegalArgumentException.class, () -> kudosService.deleteKudosById(0L, SENDER_REMOTE_ID));
        Assert.assertThrows(ObjectNotFoundException.class, () -> kudosService.deleteKudosById(100L, SENDER_REMOTE_ID));
        Assert.assertThrows(IllegalAccessException.class, () -> kudosService.deleteKudosById(kudosId, RECEIVER_REMOTE_ID));
        kudosService.deleteKudosById(kudosId, SENDER_REMOTE_ID);
        Kudos kudos1 = kudosStorage.getKudoById(kudos.getTechnicalId().longValue());
        KudosServiceTest.assertNull((Object)kudos1);
    }

    private void resetGlobalSettings() {
        KudosService kudosService = this.getService(KudosService.class);
        GlobalSettings globalSettings = kudosService.getGlobalSettings();
        globalSettings.setAccessPermission(null);
        globalSettings.setKudosPeriodType(KudosPeriodType.WEEK);
        globalSettings.setKudosPerPeriod(100L);
        kudosService.saveGlobalSettings(globalSettings);
    }
}

