/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.layoutmanagement.rest;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.layoutmanagement.rest.model.NodeLabelRestEntity;
import org.exoplatform.layoutmanagement.rest.model.PageTemplateRestEntity;
import org.exoplatform.layoutmanagement.utils.SiteNavigationUtils;
import org.exoplatform.portal.mop.State;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.webui.core.model.SelectItemOption;

public class EntityBuilder {
    private EntityBuilder() {
    }

    public static List<PageTemplateRestEntity> toPageTemplateRestEntities(List<SelectItemOption<String>> pageTemplates, Locale userLocal) {
        return pageTemplates.stream().map(pageTemplate -> EntityBuilder.toPageTemplateRestEntity((SelectItemOption<String>)pageTemplate, userLocal)).toList();
    }

    public static NodeLabelRestEntity toNodeLabelRestEntity(Map<Locale, State> nodeLabels) {
        LocaleConfigService localeConfigService = (LocaleConfigService)CommonsUtils.getService(LocaleConfigService.class);
        Locale defaultLocale = localeConfigService.getDefaultLocaleConfig() == null ? Locale.ENGLISH : localeConfigService.getDefaultLocaleConfig().getLocale();
        String defaultLanguage = defaultLocale.getLanguage();
        Map<String, String> supportedLanguages = localeConfigService.getLocalConfigs() == null ? Collections.singletonMap(defaultLocale.getLanguage(), defaultLocale.getDisplayName()) : localeConfigService.getLocalConfigs().stream().filter(localeConfig -> !StringUtils.equals((CharSequence)localeConfig.getLocaleName(), (CharSequence)"ma")).collect(Collectors.toMap(localeConfig -> I18N.toTagIdentifier((Locale)localeConfig.getLocale()), localeConfig -> localeConfig.getLocale().getDisplayName()));
        HashMap<String, String> localized = new HashMap<String, String>();
        NodeLabelRestEntity nodeLabelRestEntity = new NodeLabelRestEntity();
        if (nodeLabels != null && nodeLabels.size() != 0) {
            for (Map.Entry<Locale, State> entry : nodeLabels.entrySet()) {
                Locale locale = entry.getKey();
                if ("ma".equals(locale.getLanguage())) continue;
                State state = entry.getValue();
                localized.put(I18N.toTagIdentifier((Locale)locale), state.getName());
            }
            if (!nodeLabels.containsKey(defaultLocale)) {
                localized.put(I18N.toTagIdentifier((Locale)defaultLocale), null);
            }
            nodeLabelRestEntity.setLabels(localized);
        }
        nodeLabelRestEntity.setDefaultLanguage(defaultLanguage);
        nodeLabelRestEntity.setSupportedLanguages(supportedLanguages);
        return nodeLabelRestEntity;
    }

    private static PageTemplateRestEntity toPageTemplateRestEntity(SelectItemOption<String> pageTemplate, Locale userLocal) {
        if (pageTemplate == null) {
            return null;
        }
        return new PageTemplateRestEntity(SiteNavigationUtils.getI18NLabel(userLocal, pageTemplate.getLabel()), (String)pageTemplate.getValue());
    }
}

