/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.navigation.webui.component;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.navigation.webui.TreeNode;
import org.exoplatform.navigation.webui.component.UIPageNodeForm;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.webui.page.UIPageSelector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputIconSelector;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.validator.DateTimeValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;
import org.exoplatform.webui.form.validator.UserConfigurableValidator;

public class UIPageNodeForm
extends UIFormTabPane {
    private static final Log LOG = ExoLogger.getLogger(UIPageNodeForm.class);
    private TreeNode pageNode_;
    private Object selectedParent;
    private UserNavigation contextPageNavigation;
    private static final String SHOW_PUBLICATION_DATE = "showPublicationDate";
    private static final String START_PUBLICATION_DATE = "startPublicationDate";
    private static final String END_PUBLICATION_DATE = "endPublicationDate";
    private static final String VISIBLE = "visible";
    private Map<String, State> cachedLabels;
    private String selectedLocale;
    private static final String I18N_LABEL = "i18nizedLabel";
    private static final String LANGUAGES = "languages";
    private static final String LANGUAGES_ONCHANGE = "ChangeLanguage";
    private static final String SWITCH_MODE = "switchmode";
    private static final String SWITCH_MODE_ONCHANGE = "SwitchLabelMode";
    private static final String LABEL = "label";

    public UIPageNodeForm() throws Exception {
        super("UIPageNodeForm");
        UIFormInputSet uiSettingSet = new UIFormInputSet("PageNodeSetting");
        UIFormCheckBoxInput uiDateInputCheck = new UIFormCheckBoxInput(SHOW_PUBLICATION_DATE, null, (Object)false);
        UIFormCheckBoxInput uiVisibleCheck = new UIFormCheckBoxInput(VISIBLE, null, (Object)true);
        UIFormCheckBoxInput uiSwitchLabelMode = new UIFormCheckBoxInput(SWITCH_MODE, null, (Object)true);
        uiDateInputCheck.setOnChange("SwitchPublicationDate");
        uiVisibleCheck.setOnChange("SwitchVisible");
        uiSwitchLabelMode.setOnChange(SWITCH_MODE_ONCHANGE);
        UIFormSelectBox uiFormLanguagesSelectBox = new UIFormSelectBox(LANGUAGES, null, null);
        this.initLanguageSelectBox(uiFormLanguagesSelectBox);
        uiFormLanguagesSelectBox.setOnChange(LANGUAGES_ONCHANGE);
        uiSettingSet.addUIFormInput((UIFormInput)new UIFormStringInput("URI", "URI", null).setEditable(false)).addUIFormInput((UIFormInput)new UIFormStringInput("name", "name", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(UserConfigurableValidator.class, new Object[]{"pagename"})).addUIFormInput((UIFormInput)uiSwitchLabelMode).addUIFormInput((UIFormInput)new UIFormStringInput(LABEL, LABEL, null).addValidator(StringLengthValidator.class, new Object[]{3, 120})).addUIFormInput((UIFormInput)uiFormLanguagesSelectBox).addUIFormInput((UIFormInput)new UIFormStringInput(I18N_LABEL, null, null).setMaxLength(255).addValidator(StringLengthValidator.class, new Object[]{3, 120})).addUIFormInput((UIFormInput)uiVisibleCheck.setChecked(true)).addUIFormInput((UIFormInput)uiDateInputCheck).addUIFormInput((UIFormInput)new UIFormDateTimeInput(START_PUBLICATION_DATE, null, null).addValidator(DateTimeValidator.class, new Object[0])).addUIFormInput((UIFormInput)new UIFormDateTimeInput(END_PUBLICATION_DATE, null, null).addValidator(DateTimeValidator.class, new Object[0]));
        this.addUIFormInput(uiSettingSet);
        this.setSelectedTab(uiSettingSet.getId());
        UIPageSelector uiPageSelector = (UIPageSelector)this.createUIComponent(UIPageSelector.class, null, null);
        uiPageSelector.configure("UIPageSelector", "pageRef");
        this.addUIFormInput((UIFormInput)uiPageSelector);
        UIFormInputIconSelector uiIconSelector = new UIFormInputIconSelector("Icon", "icon");
        this.addUIFormInput((UIFormInput)uiIconSelector);
        this.setActions(new String[]{"Save", "Back"});
    }

    public TreeNode getPageNode() {
        return this.pageNode_;
    }

    public void setValues(TreeNode pageNode) throws Exception {
        this.pageNode_ = pageNode;
        this.selectedLocale = (String)this.getUIFormSelectBox(LANGUAGES).getValue();
        this.cachedLabels = new HashMap();
        if (pageNode == null) {
            this.getUIStringInput("name").setEditable(true);
            ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon("Default");
            this.setShowPublicationDate(false);
            this.switchLabelMode(true);
            return;
        }
        this.getUIStringInput("name").setEditable(false);
        this.invokeGetBindingBean((Object)this.pageNode_);
    }

    private void initLanguageSelectBox(UIFormSelectBox langSelectBox) {
        ArrayList<SelectItemOption> lang = new ArrayList<SelectItemOption>();
        LocaleConfigService localeService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        Locale currentLocale = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getLocale();
        Iterator i = localeService.getLocalConfigs().iterator();
        String displayName = null;
        String language = null;
        String country = null;
        String defaultValue = null;
        while (i.hasNext()) {
            LocaleConfig config = (LocaleConfig)i.next();
            Locale locale = config.getLocale();
            language = locale.getLanguage();
            country = locale.getCountry();
            if (country != null && country.length() > 0) {
                language = new StringBuffer().append(language).append("_").append(country).toString();
            }
            displayName = null;
            try {
                String translation;
                ResourceBundle localeResourceBundle = this.getResourceBundle(currentLocale);
                String key = "Locale." + language;
                displayName = translation = localeResourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                displayName = this.capitalizeFirstLetter(locale.getDisplayName(currentLocale));
            }
            catch (Exception e) {
                LOG.error((Object)"Problem with ressource bundle recovery ", (Throwable)e);
            }
            SelectItemOption option = new SelectItemOption(displayName, (Object)language);
            if (locale.getDisplayName().equals(currentLocale.getDisplayName())) {
                option.setSelected(true);
                defaultValue = language;
            }
            lang.add(option);
        }
        Collections.sort(lang, new LanguagesComparator(this, null));
        langSelectBox.setOptions(lang);
        langSelectBox.setValue(defaultValue);
    }

    private ResourceBundle getResourceBundle(Locale locale) throws Exception {
        ExoContainer appContainer = ExoContainerContext.getCurrentContainer();
        ResourceBundleService service = (ResourceBundleService)appContainer.getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle res = service.getResourceBundle("locale.portal.webui", locale);
        return res;
    }

    private String capitalizeFirstLetter(String word) {
        if (word == null) {
            return null;
        }
        if (word.length() == 0) {
            return word;
        }
        StringBuilder result = new StringBuilder(word);
        result.replace(0, 1, result.substring(0, 1).toUpperCase());
        return result.toString();
    }

    public void invokeGetBindingBean(Object bean) throws Exception {
        super.invokeGetBindingBean(bean);
        TreeNode pageNode = (TreeNode)bean;
        String icon = pageNode.getIcon();
        if (icon == null || icon.length() < 0) {
            icon = "Default";
        }
        ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon(icon);
        this.getUIStringInput(LABEL).setValue((Object)pageNode.getLabel());
        Map i18nizedLabels = pageNode.getI18nizedLabels();
        if (i18nizedLabels != null) {
            for (Locale key : i18nizedLabels.keySet()) {
                String locale = key.getCountry() != null && !key.getCountry().isEmpty() ? key.getLanguage() + "_" + key.getCountry() : key.getLanguage();
                this.cachedLabels.put(locale, i18nizedLabels.get(key));
            }
        }
        if (this.cachedLabels.get(this.selectedLocale) != null) {
            this.getUIStringInput(I18N_LABEL).setValue((Object)((State)this.cachedLabels.get(this.selectedLocale)).getName());
        }
        if (pageNode.getVisibility() == Visibility.SYSTEM) {
            UIFormInputSet uiSettingSet = (UIFormInputSet)this.getChildById("PageNodeSetting");
            uiSettingSet.removeChildById(VISIBLE);
            uiSettingSet.removeChildById(SHOW_PUBLICATION_DATE);
            uiSettingSet.removeChildById(START_PUBLICATION_DATE);
            uiSettingSet.removeChildById(END_PUBLICATION_DATE);
        } else {
            Visibility visibility = pageNode.getVisibility();
            boolean isVisible = visibility == null || EnumSet.of(Visibility.DISPLAYED, Visibility.TEMPORAL).contains(visibility);
            this.getUIFormCheckBoxInput(VISIBLE).setChecked(isVisible);
            this.getUIFormCheckBoxInput(SHOW_PUBLICATION_DATE).setChecked(Visibility.TEMPORAL.equals((Object)visibility));
            this.setShowCheckPublicationDate(isVisible);
            Calendar cal = Calendar.getInstance();
            if (pageNode.getStartPublicationTime() != -1L) {
                cal.setTime(new Date(pageNode.getStartPublicationTime()));
                this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setCalendar(cal);
            } else {
                this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setValue(null);
            }
            if (pageNode.getEndPublicationTime() != -1L) {
                cal.setTime(new Date(pageNode.getEndPublicationTime()));
                this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setCalendar(cal);
            } else {
                this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setValue(null);
            }
        }
        boolean isExtendedMode = true;
        if (pageNode.getNode().getLabel() != null && pageNode.getNode().getLabel().trim().length() > 0) {
            isExtendedMode = false;
        }
        this.switchLabelMode(isExtendedMode);
    }

    public void invokeSetBindingBean(Object bean) throws Exception {
        super.invokeSetBindingBean(bean);
        TreeNode node = (TreeNode)bean;
        if (node.getVisibility() != Visibility.SYSTEM) {
            UIFormCheckBoxInput showPubDate;
            Visibility visibility = this.getUIFormCheckBoxInput(VISIBLE).isChecked() ? ((showPubDate = this.getUIFormCheckBoxInput(SHOW_PUBLICATION_DATE)).isChecked() ? Visibility.TEMPORAL : Visibility.DISPLAYED) : Visibility.HIDDEN;
            node.setVisibility(visibility);
            Calendar cal = this.getUIFormDateTimeInput(START_PUBLICATION_DATE).getCalendar();
            Date date = cal != null ? cal.getTime() : null;
            node.setStartPublicationTime(date == null ? -1L : date.getTime());
            cal = this.getUIFormDateTimeInput(END_PUBLICATION_DATE).getCalendar();
            date = cal != null ? cal.getTime() : null;
            node.setEndPublicationTime(date == null ? -1L : date.getTime());
        }
        this.cachedLabels.put(this.getUIFormSelectBox(LANGUAGES).getValue(), new State((String)this.getUIStringInput(I18N_LABEL).getValue(), null));
        HashMap labels = new HashMap(this.cachedLabels.size());
        this.getUIFormSelectBox(LANGUAGES).getValue();
        for (String strLocale : this.cachedLabels.keySet()) {
            String[] arr;
            Locale locale = strLocale.contains("_") ? ((arr = strLocale.split("_")).length > 2 ? new Locale(arr[0], arr[1], arr[2]) : new Locale(arr[0], arr[1])) : new Locale(strLocale);
            labels.put(locale, this.cachedLabels.get(strLocale));
        }
        node.setI18nizedLabels(labels);
        if (this.getUIFormCheckBoxInput(SWITCH_MODE).getValue().toString().equals("true")) {
            node.setLabel(null);
        }
    }

    public void setShowCheckPublicationDate(boolean show) {
        this.getUIFormCheckBoxInput(VISIBLE).setChecked(show);
        UIFormCheckBoxInput uiForm = this.getUIFormCheckBoxInput(SHOW_PUBLICATION_DATE);
        uiForm.setRendered(show);
        this.setShowPublicationDate(show && uiForm.isChecked());
    }

    public void setShowPublicationDate(boolean show) {
        this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setRendered(show);
        this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setRendered(show);
    }

    public Object getSelectedParent() {
        return this.selectedParent;
    }

    public void setSelectedParent(Object obj) {
        this.selectedParent = obj;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
        UIPageSelector uiPageSelector = (UIPageSelector)this.getChild(UIPageSelector.class);
        if (uiPageSelector == null) {
            return;
        }
        UIPopupWindow uiPopupWindowPage = (UIPopupWindow)uiPageSelector.getChild(UIPopupWindow.class);
        if (uiPopupWindowPage == null) {
            return;
        }
        uiPopupWindowPage.processRender(context);
    }

    public String getOwner() {
        return this.contextPageNavigation.getKey().getName();
    }

    public SiteType getOwnerType() {
        return this.contextPageNavigation.getKey().getType();
    }

    public void setContextPageNavigation(UserNavigation _contextPageNav) {
        this.contextPageNavigation = _contextPageNav;
    }

    public UserNavigation getContextPageNavigation() {
        return this.contextPageNavigation;
    }

    private String getLabelOnLocale(String locale) {
        if (this.cachedLabels.get(locale) != null) {
            return ((State)this.cachedLabels.get(locale)).getName();
        }
        return null;
    }

    private void updateCachedLabels(String locale, String label) {
        this.cachedLabels.put(locale, new State(label, null));
    }

    public void setSelectedLocale(String selectedLocale) {
        this.selectedLocale = selectedLocale;
    }

    public String getSelectedLocale() {
        return this.selectedLocale;
    }

    private void switchLabelMode(boolean isExtendedMode) {
        this.getUIFormCheckBoxInput(SWITCH_MODE).setChecked(isExtendedMode);
        this.getUIStringInput(LABEL).setRendered(!isExtendedMode);
        this.getUIStringInput(I18N_LABEL).setRendered(isExtendedMode);
        this.getUIFormSelectBox(LANGUAGES).setRendered(isExtendedMode);
    }

    static /* synthetic */ TreeNode access$102(UIPageNodeForm x0, TreeNode x1) {
        x0.pageNode_ = x1;
        return x0.pageNode_;
    }

    static /* synthetic */ void access$200(UIPageNodeForm x0, String x1, String x2) {
        x0.updateCachedLabels(x1, x2);
    }

    static /* synthetic */ String access$300(UIPageNodeForm x0, String x1) {
        return x0.getLabelOnLocale(x1);
    }

    static /* synthetic */ void access$400(UIPageNodeForm x0, boolean x1) {
        x0.switchLabelMode(x1);
    }
}

