/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.navigation.webui.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.navigation.webui.component.UIGroupNavigationManagement;
import org.exoplatform.navigation.webui.component.UINavigationManagement;
import org.exoplatform.navigation.webui.component.UIPageNodeForm;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIRepeater;
import org.exoplatform.webui.core.UIVirtualList;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormTabPane;

@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/navigation/webui/component/UIGroupNavigationManagement.gtmpl", events={@EventConfig(listeners={EditNavigationActionListener.class}), @EventConfig(listeners={EditPropertiesActionListener.class}), @EventConfig(listeners={ChangeDynamicLayoutActionListener.class}), @EventConfig(listeners={ChangeDynamicLayoutForAllActionListener.class}, confirm="UIGroupNavigationManagement.ChangeDynamicLayoutForAll.Confirm"), @EventConfig(listeners={AddNavigationActionListener.class}), @EventConfig(listeners={DeleteNavigationActionListener.class}, confirm="UIGroupNavigationManagement.Delete.Confirm")}), @ComponentConfig(id="UIGroupNavigationGrid", type=UIRepeater.class, template="app:/groovy/navigation/webui/component/UINavigationGrid.gtmpl"), @ComponentConfig(type=UIPageNodeForm.class, lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={UIPageNodeForm.SaveActionListener.class}), @EventConfig(listeners={BackActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.ChangeLanguageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.SwitchLabelModeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.SwitchPublicationDateActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.SwitchVisibleActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.ClearPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.CreatePageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIFormTabPane.SelectTabActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}, name="ClosePopup")})})
public class UIGroupNavigationManagement
extends UIContainer {
    private UINavigationManagement naviManager;
    private Scope navigationScope = Scope.GRANDCHILDREN;

    public UIGroupNavigationManagement() throws Exception {
        UIVirtualList virtualList = (UIVirtualList)this.addChild(UIVirtualList.class, null, "GroupNavigationList");
        UIRepeater repeater = (UIRepeater)this.createUIComponent(UIRepeater.class, "UIGroupNavigationGrid", null);
        virtualList.setUIComponent((UIComponent)repeater);
        UIPopupWindow editNavigation = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, null);
        editNavigation.setId(editNavigation.getId() + "-" + UUID.randomUUID().toString().replaceAll("-", ""));
    }

    public void loadNavigations() throws Exception {
        UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
        List allNavs = userPortal.getNavigations();
        ArrayList<UserNavigation> groupNav = new ArrayList<UserNavigation>();
        for (UserNavigation nav : allNavs) {
            if (!nav.getKey().getType().equals((Object)SiteType.GROUP) || !nav.isModifiable()) continue;
            groupNav.add(nav);
        }
        UIVirtualList virtualList = (UIVirtualList)this.getChild(UIVirtualList.class);
        int pageSize = 4;
        1 source = new /* Unavailable Anonymous Inner Class!! */;
        virtualList.dataBind((Iterator)source);
        virtualList.setAutoAdjustHeight(true);
    }

    private List<UserNavigation> getAllGroupNavigations() {
        UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
        return userPortal.getNavigations();
    }

    public void changeSiteDynamicLayout(DataStorage dataStorage, UserNavigation navigation, boolean useDynamicLayout) throws Exception {
        SiteKey siteKey = navigation.getKey();
        if (siteKey.getType() != SiteType.GROUP) {
            return;
        }
        this.changeSiteDynamicLayout(dataStorage, siteKey, useDynamicLayout);
    }

    public void changeSiteDynamicLayout(DataStorage dataStorage, SiteKey siteKey, boolean useDynamicLayout) throws Exception {
        PortalConfig portalConfig = dataStorage.getPortalConfig(siteKey.getTypeName(), siteKey.getName());
        if (portalConfig != null) {
            if (useDynamicLayout) {
                portalConfig.useDefaultPortalLayout();
            } else {
                portalConfig.setDefaultLayout(false);
            }
            dataStorage.save(portalConfig);
            Util.getUIPortalApplication().removeCachedUIPortal(siteKey.getTypeName(), siteKey.getName());
        }
    }

    public void setScope(Scope scope) {
        this.navigationScope = scope;
    }

    public Scope getScope() {
        return this.navigationScope;
    }

    private boolean userHasRightToAddNavigation() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String remoteUser = pcontext.getRemoteUser();
        if (remoteUser == null) {
            return false;
        }
        UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
        if (userACL.isUserInGroup(userACL.getAdminGroups())) {
            return true;
        }
        OrganizationService orgService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        try {
            Collection groups = orgService.getGroupHandler().resolveGroupByMembership(remoteUser, userACL.getMakableMT());
            return groups != null && groups.size() > 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isUseDynamicLayout(String groupSiteName) throws Exception {
        DataStorage dataStorage = (DataStorage)ExoContainerContext.getService(DataStorage.class);
        PortalConfig portalConfig = dataStorage.getPortalConfig(SiteType.GROUP.getName(), groupSiteName);
        if (portalConfig != null) {
            return portalConfig.isDefaultLayout();
        }
        return false;
    }
}

