/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.entity;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.leadcapture.entity.FieldEntity;
import org.exoplatform.leadcapture.entity.FormEntity;
import org.exoplatform.leadcapture.entity.LeadEntity;

@Entity(name="ResponseEntity")
@ExoEntity
@Table(name="ADDONS_LC_RESPONSE")
@NamedQueries(value={@NamedQuery(name="ResponseEntity.getResponsesByFormAndLead", query="SELECT response FROM ResponseEntity response where response.formEntity.id = :formId and response.leadEntity.id = :leadId"), @NamedQuery(name="ResponseEntity.getResponsesByLead", query="SELECT response FROM ResponseEntity response where response.leadEntity.id = :leadId")})
public class ResponseEntity
implements Serializable {
    @Id
    @SequenceGenerator(name="SEQ_ADDONS_LC_RESPONSE_ID", sequenceName="SEQ_ADDONS_LC_RESPONSE_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_ADDONS_LC_RESPONSE_ID")
    @Column(name="ID")
    protected Long id;
    @Column(name="CREATED_DATE")
    protected Date createdDate;
    @ManyToOne
    @JoinColumn(name="LC_FORM_ID", nullable=false)
    private FormEntity formEntity;
    @ManyToOne
    @JoinColumn(name="LC_LEAD_ID", nullable=false)
    private LeadEntity leadEntity;
    @OneToMany(orphanRemoval=true)
    @JoinColumn(name="ID")
    private Collection<FieldEntity> filelds;

    public ResponseEntity() {
    }

    public ResponseEntity(FormEntity formEntity, LeadEntity leadEntity) {
        this.formEntity = formEntity;
        this.leadEntity = leadEntity;
    }

    public Long getId() {
        return this.id;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public FormEntity getFormEntity() {
        return this.formEntity;
    }

    public LeadEntity getLeadEntity() {
        return this.leadEntity;
    }

    public Collection<FieldEntity> getFilelds() {
        return this.filelds;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public void setFormEntity(FormEntity formEntity) {
        this.formEntity = formEntity;
    }

    public void setLeadEntity(LeadEntity leadEntity) {
        this.leadEntity = leadEntity;
    }

    public void setFilelds(Collection<FieldEntity> filelds) {
        this.filelds = filelds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseEntity)) {
            return false;
        }
        ResponseEntity other = (ResponseEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Date this$createdDate = this.getCreatedDate();
        Date other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        FormEntity this$formEntity = this.getFormEntity();
        FormEntity other$formEntity = other.getFormEntity();
        if (this$formEntity == null ? other$formEntity != null : !((Object)this$formEntity).equals(other$formEntity)) {
            return false;
        }
        LeadEntity this$leadEntity = this.getLeadEntity();
        LeadEntity other$leadEntity = other.getLeadEntity();
        if (this$leadEntity == null ? other$leadEntity != null : !((Object)this$leadEntity).equals(other$leadEntity)) {
            return false;
        }
        Collection<FieldEntity> this$filelds = this.getFilelds();
        Collection<FieldEntity> other$filelds = other.getFilelds();
        return !(this$filelds == null ? other$filelds != null : !((Object)this$filelds).equals(other$filelds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Date $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        FormEntity $formEntity = this.getFormEntity();
        result = result * 59 + ($formEntity == null ? 43 : ((Object)$formEntity).hashCode());
        LeadEntity $leadEntity = this.getLeadEntity();
        result = result * 59 + ($leadEntity == null ? 43 : ((Object)$leadEntity).hashCode());
        Collection<FieldEntity> $filelds = this.getFilelds();
        result = result * 59 + ($filelds == null ? 43 : ((Object)$filelds).hashCode());
        return result;
    }

    public String toString() {
        return "ResponseEntity(id=" + this.getId() + ", createdDate=" + this.getCreatedDate() + ", formEntity=" + this.getFormEntity() + ", leadEntity=" + this.getLeadEntity() + ", filelds=" + this.getFilelds() + ")";
    }
}

