/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.services;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.leadcapture.Utils;
import org.exoplatform.leadcapture.dto.LeadCaptureSettings;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.legacy.service.ProjectService;
import org.exoplatform.task.legacy.service.StatusService;

public class LeadCaptureSettingsService {
    private final Log LOG = ExoLogger.getLogger(LeadCaptureSettingsService.class);
    private SettingService settingService;
    private LeadCaptureSettings configuredLeadCaptureSettings;

    public LeadCaptureSettingsService(SettingService settingService) {
        this.settingService = settingService;
    }

    public LeadCaptureSettings getSettings() {
        if (this.configuredLeadCaptureSettings != null) {
            return this.configuredLeadCaptureSettings.clone();
        }
        SettingValue settingsValue = this.settingService.get(Utils.LEAD_CAPTURE_CONTEXT, Utils.LEAD_CAPTURE_SCOPE, "LEAD_CAPTURE_SETTINGS");
        String settingsValueString = settingsValue == null || settingsValue.getValue() == null ? null : settingsValue.getValue().toString();
        LeadCaptureSettings leadCaptureSettings = null;
        leadCaptureSettings = settingsValueString == null ? new LeadCaptureSettings() : Utils.fromJsonString(settingsValueString, LeadCaptureSettings.class);
        if (leadCaptureSettings.getUserExperienceGroup() == null) {
            leadCaptureSettings.setUserExperienceGroup("/platform/ux-team");
        }
        this.configuredLeadCaptureSettings = leadCaptureSettings;
        return this.configuredLeadCaptureSettings;
    }

    public void saveSettings(LeadCaptureSettings leadCaptureSettings) throws Exception {
        if (leadCaptureSettings == null) {
            throw new IllegalArgumentException("Empty settings to save");
        }
        LeadCaptureSettings oldSettings = this.getSettings();
        String settingsString = Utils.toJsonString(leadCaptureSettings);
        this.settingService.set(Utils.LEAD_CAPTURE_CONTEXT, Utils.LEAD_CAPTURE_SCOPE, "LEAD_CAPTURE_SETTINGS", SettingValue.create((String)settingsString));
        this.configuredLeadCaptureSettings = null;
        try {
            if (StringUtils.isEmpty((String)oldSettings.getUserExperienceSpace()) || !oldSettings.getUserExperienceSpace().equals(leadCaptureSettings.getUserExperienceSpace())) {
                this.updateStatuses(leadCaptureSettings.getUserExperienceSpace(), leadCaptureSettings.getLeadTaskProject());
            } else if (StringUtils.isNotEmpty((String)leadCaptureSettings.getLeadTaskProject()) && !oldSettings.getLeadTaskProject().equals(leadCaptureSettings.getLeadTaskProject())) {
                this.updateStatuses(leadCaptureSettings.getUserExperienceSpace(), leadCaptureSettings.getLeadTaskProject());
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)e);
            throw e;
        }
    }

    void updateStatuses(String userExperienceSpace, String leadTaskProject) throws Exception {
        Project project;
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        StatusService statusService = (StatusService)CommonsUtils.getService(StatusService.class);
        Space uxSpace = spaceService.getSpaceByPrettyName(userExperienceSpace);
        if (uxSpace != null && (project = Utils.getTaskProject(uxSpace.getGroupId(), leadTaskProject)) != null) {
            try {
                project = ((ProjectService)CommonsUtils.getService(ProjectService.class)).getProject(Long.valueOf(project.getId()));
                Status intStatus = statusService.createStatus(project, "intStatus");
                for (Status status : statusService.getStatuses(project.getId())) {
                    if ("intStatus".equals(status.getName())) continue;
                    statusService.removeStatus(status.getId());
                }
                for (String status_ : Utils.LC_STATUSES) {
                    statusService.createStatus(project, status_);
                }
                statusService.removeStatus(intStatus.getId());
            }
            catch (Exception e) {
                this.LOG.error((Object)"Cannot update project statuses");
                throw e;
            }
        }
    }
}

