/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.listeners;

import java.util.Date;
import org.exoplatform.leadcapture.Utils;
import org.exoplatform.leadcapture.dao.LeadDAO;
import org.exoplatform.leadcapture.entity.LeadEntity;
import org.exoplatform.leadcapture.services.LeadCaptureSettingsService;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

@Asynchronous
public class NewUserListener
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger(NewUserListener.class);
    private LeadDAO leadDAO;
    private ListenerService listenerService;
    private LeadCaptureSettingsService leadCaptureSettingsService;

    public NewUserListener(LeadDAO leadDAO, LeadCaptureSettingsService leadCaptureSettingsService, ListenerService listenerService) throws Exception {
        this.leadDAO = leadDAO;
        this.listenerService = listenerService;
        this.leadCaptureSettingsService = leadCaptureSettingsService;
    }

    public void postSave(User user, boolean isNew) throws Exception {
        try {
            if (isNew && this.leadCaptureSettingsService.getSettings() != null && this.leadCaptureSettingsService.getSettings().isCaptureEnabled()) {
                LeadEntity lead = this.leadDAO.getLeadByMail(user.getEmail());
                if (lead != null) {
                    if (lead.getCommunityRegistration() == null || !lead.getCommunityRegistration().booleanValue()) {
                        lead.setUpdatedDate(new Date());
                        lead.setCommunityRegistration(true);
                        lead.setCommunityRegistrationDate(user.getCreatedDate());
                        lead.setCommunityUserName(user.getUserName());
                        this.leadDAO.update(lead);
                        LOG.info("Lead {} has been associated to the community user {}", new Object[]{lead.getId(), user.getUserName()});
                    }
                } else {
                    lead = new LeadEntity();
                    lead.setMail(user.getEmail());
                    lead.setFirstName(user.getFirstName());
                    lead.setLastName(user.getLastName());
                    lead.setCaptureMethod("Community registration");
                    lead.setCaptureType("Register form");
                    lead.setCaptureSourceInfo("Community registration");
                    lead.setOriginalReferrer("");
                    lead.setPersonSource("Web - Community");
                    lead.setUpdatedDate(new Date());
                    lead.setCreatedDate(new Date());
                    lead.setCommunityRegistration(true);
                    lead.setCommunityRegistrationDate(new Date());
                    lead.setCommunityUserName(user.getUserName());
                    lead.setCommunityRegistrationMethod("Register form");
                    lead.setStatus("Raw");
                    lead.setPersonSource(Utils.getLeadSource(lead.getOriginalReferrer()));
                    lead.setGeographiqueZone(Utils.getGeoZone(lead.getCountry()));
                    this.leadDAO.create(lead);
                    LOG.info("service=lead-capture operation=synchronize_lead parameters=\"lead_name:{},form_name:Community registration\"", new Object[]{lead.getFirstName() + " " + lead.getLastName()});
                    this.listenerService.broadcast("leadCapture.newLead.event", (Object)lead, (Object)"");
                }
                LOG.info("Lead {} has been associated to the community user {}", new Object[]{lead.getId(), user.getUserName()});
            }
        }
        catch (Exception e) {
            LOG.error((Object)"an error occured", (Throwable)e);
        }
    }

    public void postDelete(User user) throws Exception {
    }
}

