/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.leadcapture.entity.MailTemplateEntity;

@Entity(name="MailContentEntity")
@ExoEntity
@Table(name="ADDONS_LC_MAIL_CONTENT")
@NamedQueries(value={@NamedQuery(name="MailContentEntity.getContentByTemplate", query="SELECT content FROM MailContentEntity content where content.mailTemplateEntity.id = :templateId ")})
public class MailContentEntity
implements Serializable {
    @Id
    @SequenceGenerator(name="SEQ_ADDONS_LC_MAIL_CONTENT_ID", sequenceName="SEQ_ADDONS_LC_MAIL_CONTENT_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_ADDONS_LC_MAIL_CONTENT_ID")
    @Column(name="ID")
    protected Long id;
    @Column(name="LANGUAGE", nullable=false)
    protected String language;
    @Column(name="SUBJECT")
    protected String subject;
    @Column(name="CONTENT")
    protected String content;
    @ManyToOne
    @JoinColumn(name="LC_MAIL_TEMPLATE_ID")
    private MailTemplateEntity mailTemplateEntity;

    public MailContentEntity() {
    }

    public MailContentEntity(String language, String subject, String content, MailTemplateEntity mailTemplateEntity) {
        this.language = language;
        this.subject = subject;
        this.content = content;
        this.mailTemplateEntity = mailTemplateEntity;
    }

    public Long getId() {
        return this.id;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getContent() {
        return this.content;
    }

    public MailTemplateEntity getMailTemplateEntity() {
        return this.mailTemplateEntity;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setMailTemplateEntity(MailTemplateEntity mailTemplateEntity) {
        this.mailTemplateEntity = mailTemplateEntity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MailContentEntity)) {
            return false;
        }
        MailContentEntity other = (MailContentEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        MailTemplateEntity this$mailTemplateEntity = this.getMailTemplateEntity();
        MailTemplateEntity other$mailTemplateEntity = other.getMailTemplateEntity();
        return !(this$mailTemplateEntity == null ? other$mailTemplateEntity != null : !((Object)this$mailTemplateEntity).equals(other$mailTemplateEntity));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MailContentEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        MailTemplateEntity $mailTemplateEntity = this.getMailTemplateEntity();
        result = result * 59 + ($mailTemplateEntity == null ? 43 : ((Object)$mailTemplateEntity).hashCode());
        return result;
    }

    public String toString() {
        return "MailContentEntity(id=" + this.getId() + ", language=" + this.getLanguage() + ", subject=" + this.getSubject() + ", content=" + this.getContent() + ", mailTemplateEntity=" + String.valueOf(this.getMailTemplateEntity()) + ")";
    }
}

