/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.leadcapture.Utils;
import org.exoplatform.leadcapture.dao.FieldDAO;
import org.exoplatform.leadcapture.dao.FormDAO;
import org.exoplatform.leadcapture.dao.LeadDAO;
import org.exoplatform.leadcapture.dao.ResponseDAO;
import org.exoplatform.leadcapture.dto.FieldDTO;
import org.exoplatform.leadcapture.dto.FormDTO;
import org.exoplatform.leadcapture.dto.FormInfo;
import org.exoplatform.leadcapture.dto.LeadCaptureSettings;
import org.exoplatform.leadcapture.dto.LeadDTO;
import org.exoplatform.leadcapture.dto.LeadsAccessList;
import org.exoplatform.leadcapture.dto.PersonalTask;
import org.exoplatform.leadcapture.dto.ResponseDTO;
import org.exoplatform.leadcapture.entity.FieldEntity;
import org.exoplatform.leadcapture.entity.FormEntity;
import org.exoplatform.leadcapture.entity.LeadEntity;
import org.exoplatform.leadcapture.entity.ResponseEntity;
import org.exoplatform.leadcapture.services.LeadCaptureSettingsService;
import org.exoplatform.leadcapture.services.LeadsManagementService$AjcClosure1;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.dto.ChangeLogEntry;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.CommentService;
import org.exoplatform.task.service.LabelService;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.ResourceUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LeadsManagementService {
    private final Log LOG = ExoLogger.getLogger(LeadsManagementService.class);
    private LeadDAO leadDAO;
    private FormDAO formDAO;
    private FieldDAO fieldDAO;
    private ResponseDAO responseDAO;
    private ListenerService listenerService;
    private TaskService taskService;
    private StatusService statusService;
    private ProjectService projectService;
    private CommentService commentService;
    private LabelService labelService;
    private LeadCaptureSettingsService leadCaptureSettingsService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public LeadsManagementService(LeadDAO leadDAO, FormDAO formDAO, FieldDAO fieldDAO, ResponseDAO responseDAO, TaskService taskService, StatusService statusService, ProjectService projectService, LabelService labelService, CommentService commentService, LeadCaptureSettingsService leadCaptureSettingsService, ListenerService listenerService) {
        this.leadDAO = leadDAO;
        this.formDAO = formDAO;
        this.fieldDAO = fieldDAO;
        this.responseDAO = responseDAO;
        this.listenerService = listenerService;
        this.taskService = taskService;
        this.statusService = statusService;
        this.projectService = projectService;
        this.labelService = labelService;
        this.commentService = commentService;
        this.leadCaptureSettingsService = leadCaptureSettingsService;
    }

    public LeadEntity addLeadInfo(FormInfo leadInfo, boolean broadcast) throws Exception {
        LeadEntity leadEntity = null;
        LeadCaptureSettings settings = this.leadCaptureSettingsService.getSettings();
        try {
            LeadDTO lead = leadInfo.getLead();
            leadEntity = this.leadDAO.getLeadByMail(lead.getMail());
            if (leadEntity == null) {
                if (lead.getCreatedDate() == null) {
                    lead.setCreatedDate(new Date());
                }
                if (lead.getUpdatedDate() == null) {
                    lead.setUpdatedDate(new Date());
                }
                if (lead.getStatus() == null) {
                    lead.setStatus("Raw");
                    if (leadInfo.getResponse() != null && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{settings.getAutoOpeningForms()}) && settings.getAutoOpeningForms().contains(leadInfo.getResponse().getFormName())) {
                        lead.setStatus("Open");
                    }
                }
                if (lead.getBlogSubscription() != null && lead.getBlogSubscription().booleanValue()) {
                    lead.setBlogSubscriptionDate(new Date());
                    lead.setCaptureMethod("Blog");
                    lead.setCaptureType("Blog subscription");
                }
                if (leadInfo.getResponse() != null) {
                    FieldDTO fieldDTO;
                    Iterator<FieldDTO> iterator;
                    lead.setCaptureType(leadInfo.getResponse().getFormName());
                    lead.setCaptureMethod(Utils.getCaptureMethode(leadInfo.getResponse().getFormName()));
                    if (settings.getResourcesIdentifier() != null && (iterator = leadInfo.getResponse().getFields().iterator()).hasNext() && Utils.isResourceRequest((fieldDTO = iterator.next()).getValue())) {
                        lead.setCaptureSourceInfo(fieldDTO.getValue());
                    }
                }
                lead.setPersonSource(Utils.getLeadSource(lead.getOriginalReferrer()));
                lead.setGeographiqueZone(Utils.getGeoZone(lead.getInferredCountry()));
                leadEntity = this.createLead(lead);
                if (broadcast) {
                    this.listenerService.broadcast("leadCapture.newLead.event", (Object)leadEntity, (Object)"");
                }
            } else {
                TaskDto task_;
                leadEntity = this.mergeLead(leadEntity, lead);
                leadEntity.setUpdatedDate(new Date());
                if ((leadEntity.getTaskId() == null || leadEntity.getTaskId() == 0L) && leadEntity.getStatus().equals("Raw") && settings.getAutoOpeningForms() != null && leadInfo.getResponse() != null && settings.getAutoOpeningForms().contains(leadInfo.getResponse().getFormName()) && (task_ = this.createTask(leadEntity)) != null) {
                    leadEntity.setTaskId(task_.getId());
                    leadEntity.setTaskUrl(LeadsManagementService.buildTaskURL(task_));
                    leadEntity.setStatus("Open");
                }
                this.leadDAO.update(leadEntity);
            }
            if (leadInfo.getResponse() != null) {
                this.addResponse(leadInfo.getResponse(), leadEntity);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to synchronize lead", (Throwable)e);
            throw e;
        }
        return leadEntity;
    }

    public LeadEntity createLead(LeadDTO lead) {
        return (LeadEntity)this.leadDAO.create(this.toLeadEntity(lead));
    }

    @ExoTransactional
    public void deleteLead(LeadEntity lead) throws Exception {
        LeadEntity leadEntity = lead;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)leadEntity);
        Object[] objectArray = new Object[]{this, leadEntity, joinPoint};
        LeadsManagementService$AjcClosure1 leadsManagementService$AjcClosure1 = new LeadsManagementService$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(leadsManagementService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void deleteAllLeads(List<LeadEntity> leadEntityList) throws Exception {
        this.LOG.info("=============== Start Deleting of {} leads ===============", new Object[]{leadEntityList.size()});
        for (LeadEntity lead : leadEntityList) {
            try {
                if (lead.getTaskId() != null && lead.getTaskId() != 0L) {
                    this.taskService.removeTask(lead.getTaskId().longValue());
                    this.LOG.info("Task {} related to lead {} removed", new Object[]{lead.getTaskId(), lead.getId()});
                }
                this.leadDAO.delete(lead);
                this.LOG.info("-- Lead {} deleted successfully --", new Object[]{lead.getId()});
            }
            catch (Exception e) {
                this.LOG.error((Object)"cannot delete leads", (Throwable)e);
            }
        }
        this.LOG.info((Object)"=============== Leads deleted successfully ===============");
    }

    public void updateLead(LeadDTO lead) throws Exception {
        try {
            lead.setUpdatedDate(new Date());
            this.leadDAO.update(this.toLeadEntity(lead));
        }
        catch (Exception e) {
            this.LOG.error((Object)e);
            throw e;
        }
    }

    public void assigneLead(Long leadId, String assignee) throws Exception {
        try {
            LeadEntity leadEntity = (LeadEntity)this.leadDAO.find(leadId);
            leadEntity.setUpdatedDate(new Date());
            leadEntity.setAssignee(assignee);
            this.leadDAO.update(leadEntity);
            if (leadEntity.getTaskId() != null && leadEntity.getTaskId() != 0L) {
                TaskDto task = this.taskService.getTask(leadEntity.getTaskId().longValue());
                task.setAssignee(assignee);
                this.taskService.updateTask(task);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)e);
            throw e;
        }
    }

    public void resetTask(Long leadId) throws Exception {
        try {
            LeadEntity leadEntity = (LeadEntity)this.leadDAO.find(leadId);
            leadEntity.setTaskId(null);
            leadEntity.setTaskUrl("");
            leadEntity.setStatus("Raw");
            this.leadDAO.update(leadEntity);
        }
        catch (Exception e) {
            this.LOG.error((Object)e);
            throw e;
        }
    }

    public LeadEntity suspendLead(String mail, String cause) throws Exception {
        try {
            LeadEntity leadEntity = this.getLeadByMail(mail);
            if (leadEntity != null) {
                leadEntity.setUpdatedDate(new Date());
                leadEntity.setMarketingSuspended(true);
                leadEntity.setMarketingSuspendedCause("Unsubscribed - " + cause);
                leadEntity = (LeadEntity)this.leadDAO.update(leadEntity);
                return leadEntity;
            }
            return null;
        }
        catch (Exception e) {
            this.LOG.error((Object)e);
            throw e;
        }
    }

    public LeadEntity updateStatus(Long leadId, String status, String userName) throws Exception {
        try {
            TaskDto task_;
            LeadEntity leadEntity = (LeadEntity)this.leadDAO.find(leadId);
            leadEntity.setUpdatedDate(new Date());
            leadEntity.setStatus(status);
            boolean isBadStatus = Arrays.stream(Utils.LEAD_BAD_STATUSES).anyMatch(status::equals);
            boolean isCompletedStatus = Arrays.stream(Utils.LEAD_COMPLET_STATUSES).anyMatch(status::equals);
            if (leadEntity.getTaskId() != null && leadEntity.getTaskId() != 0L) {
                try {
                    this.getTask(leadEntity.getTaskId());
                }
                catch (EntityNotFoundException e) {
                    leadEntity.setTaskId(null);
                    leadEntity.setTaskUrl(null);
                }
            }
            if (!(leadEntity.getTaskId() != null && leadEntity.getTaskId() != 0L || isBadStatus || (task_ = this.createTask(leadEntity)) == null)) {
                leadEntity.setTaskId(task_.getId());
                leadEntity.setTaskUrl(LeadsManagementService.buildTaskURL(task_));
            }
            if ((leadEntity = (LeadEntity)this.leadDAO.update(leadEntity)).getTaskId() != null && leadEntity.getTaskId() != 0L) {
                this.updateTaskStatus(leadEntity.getTaskId(), status);
                if (isCompletedStatus) {
                    this.completeTask(leadEntity.getTaskId());
                }
            }
            return leadEntity;
        }
        catch (Exception e) {
            this.LOG.error((Object)e);
            throw e;
        }
    }

    public static String buildTaskURL(TaskDto task) {
        if (task == null) {
            return "#";
        }
        StringBuilder urlBuilder = new StringBuilder(ResourceUtil.buildBaseURL());
        if (urlBuilder.length() <= 1) {
            return urlBuilder.toString();
        }
        return urlBuilder.append("/taskDetail/").append(task.getId()).toString();
    }

    public List<LeadDTO> getLeads() {
        ArrayList<LeadDTO> leadsList = new ArrayList<LeadDTO>();
        List leadsEntities = this.leadDAO.findAll();
        if (leadsEntities != null) {
            for (LeadEntity leadEntity : leadsEntities) {
                if (leadEntity == null) continue;
                leadsList.add(this.toLeadDto(leadEntity));
            }
        }
        return leadsList;
    }

    public LeadsAccessList getLeads(String search, String status, String owner, String captureMethod, String from, String to, String zone, int min, int max, Boolean notassigned, String sortBy, Boolean sortDesc, int page, int limit, Boolean export) {
        Long leadsTotalNumber;
        ArrayList<LeadDTO> leadsList;
        block18: {
            int offset = (page - 1) * limit;
            leadsList = new ArrayList<LeadDTO>();
            List<LeadEntity> leadsEntities = this.leadDAO.getLeads(search, status, owner, captureMethod, from, to, zone, min, max, notassigned, offset, limit, sortBy, sortDesc);
            leadsTotalNumber = this.leadDAO.countLeads(search, status, owner, captureMethod, from, to, zone, min, max, notassigned);
            if (leadsEntities == null) break block18;
            if (export != null && export.booleanValue()) {
                for (LeadEntity leadEntity : leadsEntities) {
                    if (leadEntity == null) continue;
                    LeadDTO leadDTO = this.toLeadDto(leadEntity);
                    if (leadDTO.getTaskId() != null && leadDTO.getTaskId() != 0L) {
                        try {
                            TaskDto task = this.taskService.getTask(leadDTO.getTaskId().longValue());
                            List logs = this.taskService.getTaskLogs(leadDTO.getTaskId().longValue(), 0, -1);
                            leadDTO.setOpenedDate(Utils.formatter.format(task.getCreatedTime()));
                            for (ChangeLogEntry log : logs) {
                                if (!log.getActionName().equals("edit_status")) continue;
                                switch (log.getTarget()) {
                                    case "Qualified": {
                                        leadDTO.setQualifiedDate(Utils.formatter.format(log.getCreatedTime()));
                                        break;
                                    }
                                    case "Accepted": {
                                        leadDTO.setAcceptedDate(Utils.formatter.format(log.getCreatedTime()));
                                        break;
                                    }
                                    case "Recycled": {
                                        leadDTO.setRecycledDate(Utils.formatter.format(log.getCreatedTime()));
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            this.LOG.error("Cannot get Task log for lead {}", new Object[]{leadDTO.getId(), e});
                        }
                    }
                    leadsList.add(leadDTO);
                }
            } else {
                for (LeadEntity leadEntity : leadsEntities) {
                    if (leadEntity == null) continue;
                    leadsList.add(this.toLeadDto(leadEntity));
                }
            }
        }
        return new LeadsAccessList(leadsList, leadsTotalNumber);
    }

    public JSONArray getResponses(long leadId) {
        JSONArray formResponsesList = new JSONArray();
        List formEntities = this.formDAO.findAll();
        for (FormEntity formEntity : formEntities) {
            try {
                JSONObject formResponse = new JSONObject();
                formResponse.put("form", (Object)this.toFormJson(formEntity));
                List<ResponseEntity> responsesEntities = this.responseDAO.getResponsesByForm(formEntity.getId(), leadId);
                if (responsesEntities == null || responsesEntities.size() <= 0) continue;
                JSONArray responsesList = new JSONArray();
                for (ResponseEntity responseEntity : responsesEntities) {
                    if (responseEntity == null) continue;
                    responseEntity.setFilelds(this.fieldDAO.getFieldsByResponse(responseEntity.getId()));
                    responsesList.put((Object)Utils.toResponseJson(responseEntity));
                }
                formResponse.put("responses", (Object)responsesList);
                formResponsesList.put((Object)formResponse);
            }
            catch (Exception e) {
                this.LOG.error("Cannot get responses for form {}", new Object[]{formEntity.getName(), e});
            }
        }
        return formResponsesList;
    }

    public JSONArray getTimeLine(long leadId) {
        JSONArray responsesList = new JSONArray();
        try {
            LeadEntity lead = this.getLeadbyId(leadId);
            if (lead != null) {
                List<ResponseEntity> responsesEntities;
                JSONObject obj;
                if (lead.getCommunityRegistration() != null && lead.getCommunityRegistration().booleanValue()) {
                    obj = new JSONObject();
                    obj.put("form", (Object)"communityRegistration");
                    obj.put("communityUserName", (Object)lead.getCommunityUserName());
                    obj.put("communityRegistrationMethod", (Object)lead.getCommunityRegistrationMethod());
                    obj.put("createdDate", (Object)Utils.formatter.format(lead.getCommunityRegistrationDate()));
                    obj.put("time", lead.getCommunityRegistrationDate().getTime());
                    JSONArray fields = new JSONArray();
                    fields.put((Object)"communityUserName");
                    fields.put((Object)"communityRegistrationMethod");
                    obj.put("fields", (Object)fields);
                    responsesList.put((Object)obj);
                }
                if (lead.getBlogSubscription() != null && lead.getBlogSubscription().booleanValue()) {
                    obj = new JSONObject();
                    obj.put("form", (Object)"blogRegistration");
                    obj.put("createdDate", (Object)Utils.formatter.format(lead.getBlogSubscriptionDate()));
                    obj.put("time", lead.getBlogSubscriptionDate().getTime());
                    obj.put("fields", (Object)new JSONArray());
                    responsesList.put((Object)obj);
                }
                if ((responsesEntities = this.responseDAO.getResponsesByLead(leadId)) != null && responsesEntities.size() > 0) {
                    for (ResponseEntity responseEntity : responsesEntities) {
                        if (responseEntity == null) continue;
                        responseEntity.setFilelds(this.fieldDAO.getFieldsByResponse(responseEntity.getId()));
                        JSONObject obj2 = Utils.toResponseJson(responseEntity);
                        obj2.put("form", (Object)responseEntity.getFormEntity().getName());
                        obj2.put("fields", (Object)responseEntity.getFormEntity().getFields().split(","));
                        obj2.put("time", responseEntity.getCreatedDate().getTime());
                        responsesList.put((Object)obj2);
                    }
                }
                if (lead.getTaskId() != null && lead.getTaskId() > 0L) {
                    IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
                    List logs = this.taskService.getTaskLogs(lead.getTaskId().longValue(), 0, -1);
                    for (ChangeLogEntry log : logs) {
                        if (!log.getActionName().equals("edit_status")) continue;
                        JSONObject obj3 = new JSONObject();
                        obj3.put("form", (Object)"task");
                        obj3.put("author", (Object)log.getAuthor());
                        obj3.put("newStatus", (Object)log.getTarget());
                        Identity identity = identityManager.getOrCreateIdentity("organization", log.getAuthor());
                        if (identity != null) {
                            obj3.put("authorName", (Object)identity.getProfile().getFullName());
                        } else {
                            obj3.put("authorName", (Object)log.getAuthor());
                        }
                        obj3.put("createdDate", (Object)Utils.formatter.format(log.getCreatedTime()));
                        obj3.put("time", log.getCreatedTime());
                        obj3.put("fields", (Object)new JSONArray());
                        responsesList.put((Object)obj3);
                    }
                }
            }
        }
        catch (Exception e) {
            this.LOG.error("Cannot get responses for lead {}", new Object[]{leadId, e});
        }
        return responsesList;
    }

    public void addResponse(ResponseDTO responseDTO, LeadEntity leadEntity) throws Exception {
        try {
            FormEntity formEntity = this.formDAO.getFormByName(responseDTO.getFormName());
            if (formEntity == null) {
                fields = responseDTO.getFields().stream().map(n -> n.getName()).collect(Collectors.joining(","));
                if (!fields.contains("createdDate")) {
                    fields = fields.concat(",createdDate");
                }
                formEntity = this.createForm(new FormEntity(responseDTO.getFormName(), fields));
            } else {
                fields = formEntity.getFields();
                ArrayList<String> fieldList = new ArrayList<String>(Arrays.asList(fields.split(",")));
                if (!fieldList.contains("createdDate")) {
                    fieldList.add("createdDate");
                }
                boolean changed = false;
                for (FieldDTO field : responseDTO.getFields()) {
                    if (fieldList.contains(field.getName())) continue;
                    fieldList.add(field.getName());
                    changed = true;
                }
                if (changed) {
                    fields = fieldList.stream().collect(Collectors.joining(","));
                    formEntity.setFields(fields);
                    this.updateForm(formEntity);
                }
            }
            ResponseEntity responseEntity = new ResponseEntity(formEntity, leadEntity);
            if (responseDTO.getCreatedDate() != null) {
                responseEntity.setCreatedDate(responseDTO.getCreatedDate());
            }
            responseEntity = this.createResponse(responseEntity);
            for (FieldDTO field : responseDTO.getFields()) {
                FieldEntity fieldEntity = new FieldEntity(field.getName(), field.getValue(), responseEntity);
                this.fieldDAO.create(fieldEntity);
            }
            this.listenerService.broadcast("leadCapture.newResponse.event", (Object)leadEntity, (Object)responseEntity);
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to add response", (Throwable)e);
            throw e;
        }
    }

    public List<ResponseEntity> getAllResponses() {
        return this.responseDAO.findAll();
    }

    public FormEntity createForm(FormEntity formEntity) {
        return (FormEntity)this.formDAO.create(formEntity);
    }

    public FormEntity updateForm(FormEntity formEntity) {
        return (FormEntity)this.formDAO.update(formEntity);
    }

    public ResponseEntity createResponse(ResponseEntity responseEntity) {
        if (responseEntity.getCreatedDate() == null) {
            responseEntity.setCreatedDate(new Date());
        }
        return (ResponseEntity)this.responseDAO.create(responseEntity);
    }

    public LeadEntity getLeadbyId(long id) {
        return (LeadEntity)this.leadDAO.find(Long.valueOf(id));
    }

    public LeadEntity getLeadByMail(String mail) {
        return this.leadDAO.getLeadByMail(mail);
    }

    public LeadEntity getLeadByTask(Long taslId) {
        return this.leadDAO.getLeadByTask(taslId);
    }

    public List<LeadEntity> getLeadsByStatus(String status) {
        return this.leadDAO.getLeadsByStatus(status);
    }

    public JSONArray getTaskComments(long taskId) {
        return Utils.getCommentsJson(this.commentService.getComments(taskId, 0, -1));
    }

    public TaskDto getTask(long taskId) throws Exception {
        try {
            return this.taskService.getTask(taskId);
        }
        catch (EntityNotFoundException e) {
            this.LOG.error((Object)"Cannot get Task", (Throwable)e);
            throw e;
        }
    }

    public JSONObject addTaskComment(long taskId, String username, String comment) throws Exception {
        try {
            CommentDto comment_ = this.commentService.addComment(this.taskService.getTask(taskId), username, comment);
            OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            return Utils.commentToJson(comment_, comment_.getAuthor(), organizationService.getUserHandler().findUserByName(comment_.getAuthor()).getDisplayName());
        }
        catch (EntityNotFoundException enf) {
            this.LOG.error((Object)"Cannot Add Comment", (Throwable)enf);
            throw enf;
        }
        catch (Exception e) {
            this.LOG.error((Object)"Cannot conevert comment to json", (Throwable)e);
            throw e;
        }
    }

    public void updateTaskStatus(Long taskId, String status) throws Exception {
        try {
            LeadCaptureSettings settings = this.leadCaptureSettingsService.getSettings();
            TaskDto task = this.taskService.getTask(taskId.longValue());
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            Space uxSpace = spaceService.getSpaceByPrettyName(settings.getUserExperienceSpace());
            List statuses = this.statusService.getStatuses(Utils.getTaskProject(uxSpace.getGroupId(), settings.getLeadTaskProject()).getId());
            StatusDto newStatus = null;
            for (StatusDto status_ : statuses) {
                if (!status_.getName().equals(status)) continue;
                newStatus = status_;
            }
            if (newStatus != null) {
                task.setStatus(newStatus);
                this.taskService.updateTask(task);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"Cannot update Task status", (Throwable)e);
            throw e;
        }
    }

    public TaskDto createTask(LeadEntity lead) throws Exception {
        LeadCaptureSettings settings = this.leadCaptureSettingsService.getSettings();
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Space uxSpace = spaceService.getSpaceByPrettyName(settings.getUserExperienceSpace());
        if (uxSpace != null) {
            StatusDto status = this.statusService.getDefaultStatus(Utils.getTaskProject(uxSpace.getGroupId(), settings.getLeadTaskProject()).getId());
            TaskDto task = new TaskDto();
            task.setTitle(lead.getMail());
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{lead.getFirstName()}) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{lead.getLastName()})) {
                task.setTitle(lead.getFirstName() + " " + lead.getLastName());
            }
            task.setDescription("<a  href=\"" + this.leadCaptureSettingsService.getSettings().getLeadManagementAppUrl() + "?leadid=" + lead.getId() + "\">" + lead.getFirstName() + " " + lead.getLastName() + " </a>");
            task.setStatus(status);
            task.setPriority(Priority.NORMAL);
            task.setCreatedBy(settings.getUserExperienceBotUserName());
            task.setCreatedTime(new Date());
            task = this.taskService.createTask(task);
            return task;
        }
        return null;
    }

    public void completeTask(Long id) throws Exception {
        TaskDto task = this.taskService.getTask(id.longValue());
        task.setCompleted(true);
        this.taskService.updateTask(task);
    }

    public List<PersonalTask> getPersonalTasks(long id, String userId) throws Exception {
        try {
            LeadEntity leadEntity = this.getLeadbyId(id);
            ArrayList<PersonalTask> pTasks = new ArrayList<PersonalTask>();
            if (leadEntity.getTasksLabelId() != null && leadEntity.getTasksLabelId() > 0L) {
                List tasks = this.taskService.findTasksByLabel(this.labelService.getLabel(leadEntity.getTasksLabelId().longValue()), null, userId, null, 0, -1);
                for (TaskDto task : tasks) {
                    PersonalTask pTask = new PersonalTask(task.getId(), null, userId, task.getTitle(), task.getDueDate(), task.isCompleted());
                    pTasks.add(pTask);
                }
            }
            return pTasks;
        }
        catch (Exception e) {
            this.LOG.error((Object)"Cannot get personal Tasks", (Throwable)e);
            throw e;
        }
    }

    public PersonalTask createPersonalTask(PersonalTask personalTask) throws Exception {
        TaskDto task = new TaskDto();
        LeadDTO lead = personalTask.getLead();
        String title = personalTask.getTitle();
        String userId = personalTask.getUserId();
        Date dueDate = personalTask.getDueDate();
        task.setTitle(lead.getMail());
        task.setTitle(title);
        task.setDescription("<a  href=\"" + this.leadCaptureSettingsService.getSettings().getLeadManagementAppUrl() + "?leadid=" + lead.getId() + "\">" + lead.getFirstName() + " " + lead.getLastName() + " </a>");
        task.setCreatedBy(userId);
        task.setCreatedTime(new Date());
        task.setAssignee(userId);
        task.setDueDate(dueDate);
        task = this.taskService.createTask(task);
        LabelDto label = null;
        if (lead.getTasksLabelId() != null) {
            label = this.labelService.getLabel(lead.getTasksLabelId().longValue());
        }
        if (label == null) {
            List labels = this.labelService.findLabelsByUser(userId, 0, -1);
            for (LabelDto label_ : labels) {
                if (!label_.getName().equals(lead.getFirstName() + " " + lead.getLastName())) continue;
                label = label_;
                break;
            }
        }
        if (label == null) {
            label = new LabelDto();
            label.setName(lead.getFirstName() + " " + lead.getLastName());
            label.setUsername(userId);
            label = this.labelService.createLabel(label);
            lead.setTasksLabelId(label.getId());
            this.updateLead(lead);
        }
        this.labelService.addTaskToLabel(task, Long.valueOf(label.getId()));
        return new PersonalTask(task.getId(), null, userId, task.getTitle(), task.getDueDate(), task.isCompleted());
    }

    public TaskDto updatePersonalTask(PersonalTask pTask) throws Exception {
        TaskDto task = this.taskService.getTask(pTask.getId().longValue());
        if (task != null) {
            task.setCompleted(pTask.isCompleted());
            this.taskService.updateTask(task);
        }
        return task;
    }

    public LeadEntity mergeLead(LeadEntity leadEntity, LeadDTO leadDTO) {
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getFirstName())) {
            leadEntity.setFirstName(leadDTO.getFirstName());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getLastName())) {
            leadEntity.setLastName(leadDTO.getLastName());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getCompany())) {
            leadEntity.setCompany(leadDTO.getCompany());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getPosition())) {
            leadEntity.setPosition(leadDTO.getPosition());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getDepartment())) {
            leadEntity.setDepartment(leadDTO.getDepartment());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getCompanySize())) {
            leadEntity.setCompanySize(leadDTO.getCompanySize());
        }
        if (!(StringUtils.isEmpty((CharSequence)leadDTO.getInferredCountry()) || !StringUtils.isEmpty((CharSequence)leadEntity.getGeographiqueZone()) && leadDTO.getInferredCountry().equals(leadEntity.getCountry()))) {
            leadDTO.setGeographiqueZone(Utils.getGeoZone(leadDTO.getInferredCountry()));
            leadEntity.setGeographiqueZone(leadDTO.getGeographiqueZone());
            leadEntity.setCountry(leadDTO.getInferredCountry());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getPhone())) {
            leadEntity.setPhone(leadDTO.getPhone());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getLanguage())) {
            leadEntity.setLanguage(leadDTO.getLanguage());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getAssignee())) {
            leadEntity.setAssignee(leadDTO.getAssignee());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getCaptureMethod())) {
            leadEntity.setCaptureMethod(leadDTO.getCaptureMethod());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getCaptureType())) {
            leadEntity.setCaptureType(leadDTO.getCaptureType());
        }
        if (!(leadEntity.getBlogSubscription() != null && leadEntity.getBlogSubscription().booleanValue() || leadDTO.getBlogSubscription() == null)) {
            leadEntity.setBlogSubscription(true);
            leadEntity.setBlogSubscriptionDate(new Date());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getCommunityUserName())) {
            leadEntity.setCommunityUserName(leadDTO.getCommunityUserName());
        }
        if (leadDTO.getCommunityRegistration() != null) {
            leadEntity.setCommunityRegistration(leadDTO.getCommunityRegistration());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getCommunityRegistrationMethod())) {
            leadEntity.setCommunityRegistrationMethod(leadDTO.getCommunityRegistrationMethod());
        }
        if (leadDTO.getCommunityRegistrationDate() != null) {
            leadEntity.setCommunityRegistrationDate(leadDTO.getCommunityRegistrationDate());
        }
        return leadEntity;
    }

    public JSONObject toFormJson(FormEntity formEntity) throws JSONException {
        JSONObject formJson = new JSONObject();
        formJson.put("id", (Object)formEntity.getId());
        formJson.put("name", (Object)formEntity.getName());
        formJson.put("fields", (Object)formEntity.getFields().split(","));
        return formJson;
    }

    public LeadDTO toLeadDto(LeadEntity leadEntity) {
        LeadDTO leadDTO = new LeadDTO();
        leadDTO.setId(leadEntity.getId());
        leadDTO.setMail(leadEntity.getMail());
        leadDTO.setFirstName(leadEntity.getFirstName());
        leadDTO.setLastName(leadEntity.getLastName());
        leadDTO.setCompany(leadEntity.getCompany());
        leadDTO.setPosition(leadEntity.getPosition());
        leadDTO.setInferredCountry(leadEntity.getCountry());
        leadDTO.setStatus(leadEntity.getStatus());
        leadDTO.setPhone(leadEntity.getPhone());
        if (leadEntity.getCreatedDate() != null) {
            leadDTO.setCreatedDate(leadEntity.getCreatedDate());
            leadDTO.setFormattedCreatedDate(Utils.formatter.format(leadEntity.getCreatedDate()));
        }
        if (leadEntity.getUpdatedDate() != null) {
            leadDTO.setUpdatedDate(leadEntity.getUpdatedDate());
            leadDTO.setFormattedUpdatedDate(Utils.formatter.format(leadEntity.getUpdatedDate()));
        }
        leadDTO.setLanguage(leadEntity.getLanguage());
        leadDTO.setAssignee(leadEntity.getAssignee());
        leadDTO.setGeographiqueZone(leadEntity.getGeographiqueZone());
        leadDTO.setMarketingSuspended(leadEntity.getMarketingSuspended());
        leadDTO.setMarketingSuspendedCause(leadEntity.getMarketingSuspendedCause());
        leadDTO.setCaptureMethod(leadEntity.getCaptureMethod());
        leadDTO.setCaptureType(leadEntity.getCaptureType());
        leadDTO.setBlogSubscription(leadEntity.getBlogSubscription());
        leadDTO.setBlogSubscriptionDate(leadEntity.getBlogSubscriptionDate());
        if (leadEntity.getBlogSubscriptionDate() != null) {
            leadDTO.setFormattedBlogSubscriptionDate(Utils.formatter.format(leadEntity.getBlogSubscriptionDate()));
        }
        leadDTO.setCommunityUserName(leadEntity.getCommunityUserName());
        leadDTO.setCommunityRegistration(leadEntity.getCommunityRegistration());
        leadDTO.setCommunityRegistrationMethod(leadEntity.getCommunityRegistrationMethod());
        leadDTO.setCommunityRegistrationDate(leadEntity.getCommunityRegistrationDate());
        if (leadEntity.getCommunityRegistrationDate() != null) {
            leadDTO.setFormattedCommunityRegistrationDate(Utils.formatter.format(leadEntity.getCommunityRegistrationDate()));
        }
        leadDTO.setPersonSource(leadEntity.getPersonSource());
        leadDTO.setLandingPageInfo(leadEntity.getLandingPageInfo());
        leadDTO.setCaptureSourceInfo(leadEntity.getCaptureSourceInfo());
        leadDTO.setPersonIp(leadEntity.getPersonIp());
        leadDTO.setOriginalReferrer(leadEntity.getOriginalReferrer());
        leadDTO.setTaskId(leadEntity.getTaskId());
        leadDTO.setTaskUrl(leadEntity.getTaskUrl());
        leadDTO.setActivityId(leadEntity.getActivityId());
        leadDTO.setGoal(leadEntity.getGoal());
        leadDTO.setUsersNumber(leadEntity.getUsersNumber());
        leadDTO.setInteractionSummary(leadEntity.getInteractionSummary());
        leadDTO.setCurrentSolution(leadEntity.getCurrentSolution());
        leadDTO.setHowHear(leadEntity.getHowHear());
        leadDTO.setSolutionType(leadEntity.getSolutionType());
        leadDTO.setSolutionRequirements(leadEntity.getSolutionRequirements());
        leadDTO.setShortlistVendors(leadEntity.getShortlistVendors());
        leadDTO.setCompanyWebsite(leadEntity.getCompanyWebsite());
        leadDTO.setEmployeesNumber(leadEntity.getEmployeesNumber());
        leadDTO.setIndustry(leadEntity.getIndustry());
        leadDTO.setTasksLabelId(leadEntity.getTasksLabelId());
        leadDTO.setDepartment(leadEntity.getDepartment());
        leadDTO.setCompanySize(leadEntity.getCompanySize());
        leadDTO.setCustomer(leadEntity.getCustomer() != null && leadEntity.getCustomer() != false);
        return leadDTO;
    }

    public LeadEntity toLeadEntity(LeadDTO leadDTO) {
        LeadEntity leadEntity = new LeadEntity();
        leadEntity.setId(leadDTO.getId());
        leadEntity.setMail(leadDTO.getMail());
        leadEntity.setFirstName(leadDTO.getFirstName());
        leadEntity.setLastName(leadDTO.getLastName());
        leadEntity.setCompany(leadDTO.getCompany());
        leadEntity.setPosition(leadDTO.getPosition());
        leadEntity.setCountry(leadDTO.getInferredCountry());
        leadEntity.setStatus(leadDTO.getStatus());
        leadEntity.setPhone(leadDTO.getPhone());
        leadEntity.setCreatedDate(leadDTO.getCreatedDate());
        leadEntity.setUpdatedDate(leadDTO.getUpdatedDate());
        leadEntity.setLanguage(leadDTO.getLanguage());
        leadEntity.setAssignee(leadDTO.getAssignee());
        leadEntity.setGeographiqueZone(leadDTO.getGeographiqueZone());
        leadEntity.setMarketingSuspended(leadDTO.getMarketingSuspended());
        leadEntity.setMarketingSuspendedCause(leadDTO.getMarketingSuspendedCause());
        leadEntity.setCaptureMethod(leadDTO.getCaptureMethod());
        leadEntity.setCaptureType(leadDTO.getCaptureType());
        leadEntity.setBlogSubscription(leadDTO.getBlogSubscription());
        leadEntity.setBlogSubscriptionDate(leadDTO.getBlogSubscriptionDate());
        leadEntity.setCommunityUserName(leadDTO.getCommunityUserName());
        leadEntity.setCommunityRegistration(leadDTO.getCommunityRegistration());
        leadEntity.setCommunityRegistrationMethod(leadDTO.getCommunityRegistrationMethod());
        leadEntity.setCommunityRegistrationDate(leadDTO.getCommunityRegistrationDate());
        leadEntity.setPersonSource(leadDTO.getPersonSource());
        leadEntity.setLandingPageInfo(leadDTO.getLandingPageInfo());
        leadEntity.setCaptureSourceInfo(leadDTO.getCaptureSourceInfo());
        leadEntity.setPersonIp(leadDTO.getPersonIp());
        leadEntity.setOriginalReferrer(leadDTO.getOriginalReferrer());
        leadEntity.setTaskId(leadDTO.getTaskId());
        leadEntity.setTaskUrl(leadDTO.getTaskUrl());
        leadEntity.setActivityId(leadDTO.getActivityId());
        leadEntity.setGoal(leadDTO.getGoal());
        leadEntity.setUsersNumber(leadDTO.getUsersNumber());
        leadEntity.setInteractionSummary(leadDTO.getInteractionSummary());
        leadEntity.setCurrentSolution(leadDTO.getCurrentSolution());
        leadEntity.setHowHear(leadDTO.getHowHear());
        leadEntity.setSolutionType(leadDTO.getSolutionType());
        leadEntity.setSolutionRequirements(leadDTO.getSolutionRequirements());
        leadEntity.setShortlistVendors(leadDTO.getShortlistVendors());
        leadEntity.setCompanyWebsite(leadDTO.getCompanyWebsite());
        leadEntity.setEmployeesNumber(leadDTO.getEmployeesNumber());
        leadEntity.setIndustry(leadDTO.getIndustry());
        leadEntity.setTasksLabelId(leadDTO.getTasksLabelId());
        leadEntity.setDepartment(leadDTO.getDepartment());
        leadEntity.setCompanySize(leadDTO.getCompanySize());
        leadEntity.setCustomer(leadDTO.getCustomer());
        return leadEntity;
    }

    public FieldDTO toFieldDto(FieldEntity fieldEntity) {
        FieldDTO fieldDTO = new FieldDTO();
        fieldDTO.setId(fieldEntity.getId());
        fieldDTO.setName(fieldEntity.getName());
        fieldDTO.setValue(fieldEntity.getValue());
        return fieldDTO;
    }

    public FieldEntity toFieldEntity(FieldDTO fieldDTO) {
        FieldEntity fieldEntity = new FieldEntity();
        fieldEntity.setId(fieldDTO.getId());
        fieldEntity.setName(fieldDTO.getName());
        fieldEntity.setValue(fieldDTO.getValue());
        return fieldEntity;
    }

    public FormDTO toFormDto(FormEntity formEntity) {
        FormDTO formDTO = new FormDTO();
        formDTO.setId(formEntity.getId());
        formDTO.setName(formEntity.getName());
        formDTO.setFields(formEntity.getFields());
        return formDTO;
    }

    public FormEntity toFormEntity(FormDTO formDTO) {
        FormEntity formEntity = new FormEntity();
        formEntity.setId(formDTO.getId());
        formEntity.setName(formDTO.getName());
        formEntity.setFields(formDTO.getFields());
        return formEntity;
    }

    public ResponseDTO toResponseDto(ResponseEntity responseEntity) {
        ResponseDTO responseDTO = new ResponseDTO();
        responseDTO.setId(responseEntity.getId());
        responseDTO.setCreatedDate(responseEntity.getCreatedDate());
        responseDTO.setForm(this.toFormDto(responseEntity.getFormEntity()));
        responseDTO.setFormName(responseEntity.getFormEntity().getName());
        ArrayList<FieldDTO> fields = new ArrayList<FieldDTO>();
        for (FieldEntity fieald : this.fieldDAO.getFieldsByResponse(responseEntity.getId())) {
            fields.add(this.toFieldDto(fieald));
        }
        responseDTO.setFields(fields);
        return responseDTO;
    }

    public ResponseEntity toResponseEntity(ResponseDTO responseDTO) {
        ResponseEntity responseEntity = new ResponseEntity();
        responseEntity.setId(responseDTO.getId());
        responseEntity.setFormEntity(this.toFormEntity(responseDTO.getForm()));
        ArrayList<FieldEntity> fields = new ArrayList<FieldEntity>();
        for (FieldDTO fieald : responseDTO.getFields()) {
            fields.add(this.toFieldEntity(fieald));
        }
        responseEntity.setFilelds(fields);
        return responseEntity;
    }

    public boolean updateMethodes() throws Exception {
        List leadsEntities = this.leadDAO.findAll();
        for (LeadEntity lead : leadsEntities) {
            if (lead.getCaptureMethod() == null || lead.getCaptureMethod().equals("Blog")) continue;
            if (lead.getCaptureMethod().equals("Register form") || lead.getCaptureMethod().contains("community")) {
                lead.setCaptureType(lead.getCaptureMethod());
                lead.setCaptureMethod("Community registration");
                continue;
            }
            if (Utils.getCaptureMethode(lead.getCaptureMethod()).equals(lead.getCaptureMethod())) continue;
            lead.setCaptureMethod(Utils.getCaptureMethode(lead.getCaptureMethod()));
            lead.setCaptureSourceInfo(lead.getCaptureType());
            lead.setCaptureType(lead.getCaptureMethod());
        }
        this.leadDAO.updateAll(leadsEntities);
        return true;
    }

    public boolean mergezone() throws Exception {
        List leadsEntities = this.leadDAO.findAll();
        ArrayList<LeadEntity> leadsEntitiestoUpdate = new ArrayList<LeadEntity>();
        for (LeadEntity lead : leadsEntities) {
            if (lead.getGeographiqueZone() == null || !lead.getGeographiqueZone().equals("Western Europe") && !lead.getGeographiqueZone().equals("Eastern Europe")) continue;
            lead.setGeographiqueZone("Europe");
            leadsEntitiestoUpdate.add(lead);
        }
        this.leadDAO.updateAll(leadsEntitiestoUpdate);
        return true;
    }

    static {
        LeadsManagementService.ajc$preClinit();
    }

    static /* synthetic */ void deleteLead_aroundBody0(LeadsManagementService ajc$this, LeadEntity lead, JoinPoint joinPoint) {
        try {
            ajc$this.leadDAO.delete(lead);
        }
        catch (Exception e) {
            ajc$this.LOG.error((Object)e);
            throw e;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LeadsManagementService.java", LeadsManagementService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteLead", "org.exoplatform.leadcapture.services.LeadsManagementService", "org.exoplatform.leadcapture.entity.LeadEntity", "lead", "java.lang.Exception", "void"), 172);
    }
}

