/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.rest;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.leadcapture.Utils;
import org.exoplatform.leadcapture.dto.FormInfo;
import org.exoplatform.leadcapture.dto.LeadCaptureSettings;
import org.exoplatform.leadcapture.dto.LeadDTO;
import org.exoplatform.leadcapture.dto.PersonalTask;
import org.exoplatform.leadcapture.entity.LeadEntity;
import org.exoplatform.leadcapture.entity.ResponseEntity;
import org.exoplatform.leadcapture.services.LeadCaptureSettingsService;
import org.exoplatform.leadcapture.services.LeadsManagementService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/leadcapture/leadsmanagement")
@Produces(value={"application/json"})
public class LeadsManagementRest
implements ResourceContainer {
    private final Log LOG = ExoLogger.getLogger(LeadsManagementRest.class);
    private final String portalContainerName = "portal";
    private LeadsManagementService leadsManagementService;
    private LeadCaptureSettingsService leadCaptureSettingsService;

    public LeadsManagementRest(LeadsManagementService leadsManagementService, LeadCaptureSettingsService leadCaptureSettingsService) {
        this.leadsManagementService = leadsManagementService;
        this.leadCaptureSettingsService = leadCaptureSettingsService;
    }

    @OPTIONS
    @Path(value="leads")
    public Response allowCORS(@Context UriInfo uriInfo) throws Exception {
        LeadCaptureSettings settings = this.leadCaptureSettingsService.getSettings();
        Response.ResponseBuilder response = Response.ok();
        response.header("Access-Control-Allow-Origin", (Object)settings.getAllowedCaptureSourceDomain());
        response.header("Access-Control-Allow-Headers", (Object)"*");
        response.header("Access-Control-Request-Method", (Object)"POST");
        return response.build();
    }

    @GET
    @Path(value="leads")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response getLeads(@Context UriInfo uriInfo, @QueryParam(value="search") String search, @QueryParam(value="status") String status, @QueryParam(value="owner") String owner, @QueryParam(value="method") String captureMethod, @QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="zone") String zone, @QueryParam(value="min") int min, @QueryParam(value="max") int max, @QueryParam(value="notassigned") Boolean notassigned, @QueryParam(value="sortby") String sortBy, @QueryParam(value="sortdesc") Boolean sortDesc, @QueryParam(value="page") int page, @QueryParam(value="limit") int limit, @QueryParam(value="export") Boolean export) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok((Object)this.leadsManagementService.getLeads(search, status, owner, captureMethod, from, to, zone, min, max, notassigned, sortBy, sortDesc, page, limit, export)).build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to get leads list", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="leads/{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response getLead(@Context UriInfo uriInfo, @PathParam(value="id") Long id) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok((Object)this.leadsManagementService.toLeadDto(this.leadsManagementService.getLeadbyId(id))).build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to get leads list", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="leads")
    public Response add(@Context UriInfo uriInfo, @HeaderParam(value="token") String headerToken, FormInfo lead) throws Exception {
        LeadCaptureSettings settings = this.leadCaptureSettingsService.getSettings();
        String captureToken = settings.getCaptureToken();
        if (headerToken == null) {
            this.LOG.warn((Object)"Security Token for Lead capture not defined");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Access forbidden to the add lead rest service, Security Token not defined").build();
        }
        if (StringUtils.isEmpty((CharSequence)captureToken) || !captureToken.equals(headerToken)) {
            this.LOG.warn("Access forbidden to the add lead rest service, wrong token: {}", new Object[]{headerToken});
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Access forbidden to the add lead rest service, wrong token").build();
        }
        if (lead == null) {
            this.LOG.warn((Object)"Lead not captured, lead is null");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Lead is null").build();
        }
        if (lead.getLead() == null || StringUtils.isEmpty((CharSequence)lead.getLead().getMail())) {
            this.LOG.warn((Object)"Lead not captured, mail needed");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Lead mail needed").build();
        }
        if (this.isBlacklisted(lead.getLead())) {
            this.LOG.warn("Cannot capture lead {} with mail  {}, lead  blacklisted", new Object[]{lead.getLead().getFirstName() + " " + lead.getLead().getLastName(), lead.getLead().getMail()});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"lead blacklisted").build();
        }
        if (!this.leadCaptureSettingsService.getSettings().isCaptureEnabled()) {
            this.LOG.warn("Lead capture not enabled, New lead {} not captured ", new Object[]{lead.getLead().getFirstName() + " " + lead.getLead().getLastName()});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.LOG.info("start adding lead {}", new Object[]{lead.toString()});
        try {
            this.leadsManagementService.addLeadInfo(lead, true);
            this.LOG.info("service=lead-capture operation=synchronize_lead parameters=\"lead_name:{},form_name:{}\"", new Object[]{lead.getLead().getFirstName() + " " + lead.getLead().getLastName(), lead.getResponse() != null ? lead.getResponse().getFormName() : ""});
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"lead synchronized").header("Access-Control-Allow-Origin", (Object)settings.getAllowedCaptureSourceDomain()).build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to synchronise lead {}", new Object[]{lead.getLead().getFirstName() + " " + lead.getLead().getLastName(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("Access-Control-Allow-Origin", (Object)settings.getAllowedCaptureSourceDomain()).entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="leads/{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response deleteLead(@Context UriInfo uriInfo, @PathParam(value="id") Long id) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            LeadEntity lead = this.leadsManagementService.getLeadbyId(id);
            if (lead == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Lead Not found").build();
            }
            this.leadsManagementService.deleteLead(lead);
            this.LOG.info("Lead {} deleted by {}", new Object[]{lead.getId(), sourceIdentity.getRemoteId()});
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"lead deleted").build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to delete lead {}", new Object[]{id, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="leads/bulkdelete")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response deleteLeads(@Context UriInfo uriInfo, List<Long> ids) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            ArrayList<LeadEntity> leadEntityList = new ArrayList<LeadEntity>();
            LeadEntity lead = null;
            for (long id : ids) {
                lead = this.leadsManagementService.getLeadbyId(id);
                if (lead == null) {
                    this.LOG.warn("Lead {} Not found", new Object[]{id});
                    continue;
                }
                leadEntityList.add(lead);
            }
            this.leadsManagementService.deleteAllLeads(leadEntityList);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"leads deleted").build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to delete leads ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="leads/{id}")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response update(@Context UriInfo uriInfo, @PathParam(value="id") Long id, LeadDTO lead) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.leadsManagementService.updateLead(lead);
            this.LOG.info("Lead {} edited by {}", new Object[]{lead.getId(), sourceIdentity.getRemoteId()});
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"lead updated").build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to update lead {}", new Object[]{id, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="suspend")
    @Consumes(value={"application/json"})
    public Response suspend(@Context UriInfo uriInfo, Map<String, String> obj) throws Exception {
        try {
            String mail = obj.get("mail");
            String cause = obj.get("cause");
            LeadEntity lead = this.leadsManagementService.suspendLead(mail, cause);
            if (lead == null) {
                this.LOG.warn((Object)"Lead not found");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Lead Not found").build();
            }
            this.LOG.info((Object)"Lead  suspended");
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"lead suspended").build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to suspend lead ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PATCH
    @Path(value="assign")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response assign(@Context UriInfo uriInfo, LeadDTO lead) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.leadsManagementService.assigneLead(lead.getId(), lead.getAssignee());
            this.LOG.info("Lead {} assigned to {} by {}", new Object[]{lead.getId(), lead.getAssignee(), sourceIdentity.getRemoteId()});
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"lead assigned").build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to assign lead {} to {}", new Object[]{lead.getId(), lead.getAssignee(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @PATCH
    @Path(value="status")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response updateStatus(@Context UriInfo uriInfo, LeadDTO lead) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            LeadEntity leadEntity = this.leadsManagementService.updateStatus(lead.getId(), lead.getStatus(), sourceIdentity.getRemoteId());
            this.LOG.info("Lead {} status updated to {} by {}", new Object[]{lead.getId(), lead.getStatus(), sourceIdentity.getRemoteId()});
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.leadsManagementService.toLeadDto(leadEntity)).build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to update lead {} status to {}", new Object[]{lead.getId(), lead.getStatus(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @PATCH
    @Path(value="reset/task/{id}")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response resetTask(@Context UriInfo uriInfo, @PathParam(value="id") Long id) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            LeadEntity leadEntity = this.leadsManagementService.getLeadbyId(id);
            if (leadEntity == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"lead not found").build();
            }
            this.leadsManagementService.resetTask(id);
            this.LOG.info("Lead {} task reset by {}", new Object[]{leadEntity.getTaskId(), sourceIdentity.getRemoteId()});
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.leadsManagementService.toLeadDto(leadEntity)).build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to reset Task", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="responses/{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response getResponses(@Context UriInfo uriInfo, @PathParam(value="id") Long id) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok((Object)this.leadsManagementService.getResponses(id).toString()).build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to get responses for lead {}", new Object[]{id, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="timeline/{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response getTimeLine(@Context UriInfo uriInfo, @PathParam(value="id") Long id) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok((Object)this.leadsManagementService.getTimeLine(id).toString()).build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to get responses for lead {}", new Object[]{id, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="ptask")
    @RolesAllowed(value={"ux-team"})
    public Response addPersonalTask(@Context UriInfo uriInfo, PersonalTask task) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            task.setUserId(sourceIdentity.getRemoteId());
            task.setDueDate(Utils.taskFormatter.parse(task.getFormattedDueDate()));
            return Response.ok((Object)this.leadsManagementService.createPersonalTask(task)).build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to add personal task", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="ptask/{id}")
    @RolesAllowed(value={"ux-team"})
    public Response updateTask(@Context UriInfo uriInfo, @PathParam(value="id") Long id, PersonalTask task) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok((Object)this.leadsManagementService.updatePersonalTask(task)).build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to update personal task", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="ptask/{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response getPersonalTasks(@Context UriInfo uriInfo, @PathParam(value="id") long id) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok(this.leadsManagementService.getPersonalTasks(id, sourceIdentity.getRemoteId())).build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to get user  tasks", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="comments/{taskid}")
    @RolesAllowed(value={"ux-team"})
    public Response addComment(@Context UriInfo uriInfo, @PathParam(value="taskid") long taskId, String comment) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok((Object)this.leadsManagementService.addTaskComment(taskId, sourceIdentity.getRemoteId(), comment).toString()).build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to add comment to task {}", new Object[]{taskId, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="comments/{taskid}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response getComments(@Context UriInfo uriInfo, @PathParam(value="taskid") long taskId) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok((Object)this.leadsManagementService.getTaskComments(taskId).toString()).build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to get task {} comments", new Object[]{taskId, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="task/{taskid}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response getTask(@Context UriInfo uriInfo, @PathParam(value="taskid") long taskId) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok((Object)this.leadsManagementService.getTask(taskId)).build();
        }
        catch (EntityNotFoundException e) {
            this.LOG.error("task {} not found", new Object[]{taskId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to get task {}", new Object[]{taskId, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="marketers")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response getMarketers(@Context UriInfo uriInfo) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            JSONArray marketersList = new JSONArray();
            for (User user : Utils.getGroupMembers(this.leadCaptureSettingsService.getSettings().getUserExperienceGroup())) {
                JSONObject marketer = new JSONObject();
                marketer.put("userName", (Object)user.getUserName());
                marketer.put("fullName", (Object)(user.getFirstName() + " " + user.getLastName()));
                marketer.put("email", (Object)user.getEmail());
                marketersList.put((Object)marketer);
            }
            return Response.ok((Object)marketersList.toString()).build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to get marketers list", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    public boolean isBlacklisted(LeadDTO lead) {
        LeadCaptureSettings settings = this.leadCaptureSettingsService.getSettings();
        String mailBlackList = settings.getMailsBlackList();
        String firstNameBlackList = settings.getFirstNamesBlackList();
        String lastNameBlackList = settings.getLaslNamesBlackList();
        String companyBlackList = settings.getCompaniesBlackList();
        if (StringUtils.isNotEmpty((CharSequence)mailBlackList)) {
            for (String mail_ : mailBlackList.split(",")) {
                if (!lead.getMail().contains(mail_)) continue;
                return true;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)firstNameBlackList)) {
            for (String fName : firstNameBlackList.split(",")) {
                if (!lead.getFirstName().equals(fName)) continue;
                return true;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)lastNameBlackList)) {
            for (String lName : lastNameBlackList.split(",")) {
                if (!lead.getLastName().equals(lName)) continue;
                return true;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)companyBlackList)) {
            for (String company : companyBlackList.split(",")) {
                if (!lead.getCompany().equals(company)) continue;
                return true;
            }
        }
        return false;
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="leads/import")
    public Response importLeads(@Context UriInfo uriInfo, List<FormInfo> leads) throws Exception {
        LeadCaptureSettings settings = this.leadCaptureSettingsService.getSettings();
        if (!this.leadCaptureSettingsService.getSettings().isCaptureEnabled()) {
            this.LOG.warn((Object)"Leads capture not enabled ");
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
        }
        if (leads == null) {
            this.LOG.warn((Object)"Leads not imported, leads is null");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Lead is null").build();
        }
        try {
            for (FormInfo lead : leads) {
                if (lead.getLead() == null || StringUtils.isEmpty((CharSequence)lead.getLead().getMail())) {
                    this.LOG.warn((Object)"Lead not captured, mail needed");
                    continue;
                }
                if (this.isBlacklisted(lead.getLead())) {
                    this.LOG.warn("Cannot capture lead {} with mail  {}, lead  blacklisted", new Object[]{lead.getLead().getFirstName() + " " + lead.getLead().getLastName(), lead.getLead().getMail()});
                    continue;
                }
                this.LOG.info("start adding lead {}", new Object[]{lead.getLead().getFirstName() + " " + lead.getLead().getFirstName()});
                lead.getLead().setId(null);
                this.leadsManagementService.addLeadInfo(lead, true);
                this.LOG.info("service=lead-capture operation=synchronize_lead parameters=\"lead_name:{},form_name:{}\"", new Object[]{lead.getLead().getFirstName() + " " + lead.getLead().getLastName(), lead.getResponse() != null ? lead.getResponse().getFormName() : ""});
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"leads imported").build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to import leads", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("Access-Control-Allow-Origin", (Object)settings.getAllowedCaptureSourceDomain()).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="leads/export")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response exportLeads(@Context UriInfo uriInfo) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            ArrayList<FormInfo> leadsList = new ArrayList<FormInfo>();
            List<ResponseEntity> responseEntities = this.leadsManagementService.getAllResponses();
            for (ResponseEntity response : responseEntities) {
                FormInfo formInfo = new FormInfo();
                LeadDTO leadDTO = this.leadsManagementService.toLeadDto(response.getLeadEntity());
                leadDTO.setId(null);
                leadDTO.setTaskUrl(null);
                leadDTO.setTaskId(null);
                formInfo.setLead(leadDTO);
                formInfo.setResponse(this.leadsManagementService.toResponseDto(response));
                leadsList.add(formInfo);
            }
            List<LeadDTO> leadDTOS = this.leadsManagementService.getLeads();
            for (LeadDTO leadDTO : leadDTOS) {
                if (this.leadsManagementService.getResponses(leadDTO.getId()).length() != 0) continue;
                FormInfo formInfo = new FormInfo();
                leadDTO.setId(null);
                leadDTO.setTaskUrl(null);
                leadDTO.setTaskId(null);
                formInfo.setLead(leadDTO);
                leadsList.add(formInfo);
            }
            return Response.ok(leadsList).build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to get leads list", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    @Path(value="create")
    public Response createLead(@Context UriInfo uriInfo, LeadDTO lead) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (lead == null || StringUtils.isEmpty((CharSequence)lead.getMail())) {
            this.LOG.warn((Object)"Lead not captured, mail needed");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Lead mail needed").build();
        }
        this.LOG.info("start adding lead {}", new Object[]{lead.toString()});
        try {
            lead.setCreatedDate(new Date());
            lead.setUpdatedDate(new Date());
            lead.setStatus("Raw");
            lead.setCaptureMethod("manually_created");
            this.leadsManagementService.createLead(lead, sourceIdentity.getRemoteId());
            this.LOG.info("service=lead-capture operation=synchronize_lead parameters=\"lead_name:{}\"", new Object[]{lead.getFirstName() + " " + lead.getLastName()});
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"lead added").build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to synchronise lead {}", new Object[]{lead.getFirstName() + " " + lead.getLastName(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @RolesAllowed(value={"administrators"})
    @Path(value="updatemethodes")
    public Response updateMethodes(@Context UriInfo uriInfo) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.leadsManagementService.updateMethodes();
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"lead's methodes updated").build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to update methodes lead", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @RolesAllowed(value={"administrators"})
    @Path(value="mergezone")
    public Response mergeZone(@Context UriInfo uriInfo) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.leadsManagementService.mergezone();
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"leads geo zone updated").build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to update geo zone of leads", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }
}

